/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;

@Component(role=ContentsComparator.class, hint="zip")
public class NestedZipComparator
implements ContentsComparator {
    public static final String TYPE = "zip";
    @Requirement(hint="zip")
    private ArtifactComparator zipComparator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactDelta getDelta(InputStream baseline, InputStream reactor) throws IOException {
        File zip = File.createTempFile(TYPE, ".zip");
        try {
            ArtifactDelta artifactDelta;
            FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(baseline), (File)zip);
            File zip2 = File.createTempFile("zip2", ".zip");
            try {
                FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(reactor), (File)zip2);
                artifactDelta = this.zipComparator.getDelta(zip, zip2);
                zip2.delete();
            }
            catch (Throwable throwable) {
                zip2.delete();
                throw throwable;
            }
            return artifactDelta;
        }
        finally {
            zip.delete();
        }
    }
}

