/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.TraceClassVisitor;

@Component(role=ContentsComparator.class, hint="class")
public class ClassfileComparator
implements ContentsComparator {
    public static final String TYPE = "class";

    @Override
    public ArtifactDelta getDelta(InputStream baseline, InputStream reactor, MojoExecution mojo) throws IOException {
        boolean equal;
        byte[] baselineBytes = baseline.readAllBytes();
        byte[] reactorBytes = reactor.readAllBytes();
        String baselineDisassemble = null;
        String reactorDisassemble = null;
        try {
            baselineDisassemble = this.disassemble(baselineBytes);
            reactorDisassemble = this.disassemble(reactorBytes);
            equal = baselineDisassemble.equals(reactorDisassemble);
        }
        catch (RuntimeException e) {
            equal = Arrays.equals(baselineBytes, reactorBytes);
        }
        return !equal ? new SimpleArtifactDelta("different", baselineDisassemble, reactorDisassemble) : null;
    }

    private String disassemble(byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        ClassNode clazz = new ClassNode();
        reader.accept((ClassVisitor)clazz, 589830);
        if (clazz.innerClasses != null) {
            ArrayList sorted = new ArrayList(clazz.innerClasses);
            Collections.sort(sorted, (o1, o2) -> o1.name.compareTo(o2.name));
            clazz.innerClasses = sorted;
        }
        StringWriter buffer = new StringWriter();
        try (PrintWriter writer = new PrintWriter(buffer);){
            clazz.accept((ClassVisitor)new TraceClassVisitor(writer));
            writer.flush();
        }
        return buffer.toString();
    }
}

