/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.CompoundArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;

@Component(role=ContentsComparator.class, hint="manifest")
public class ManifestComparator
implements ContentsComparator {
    public static final String TYPE = "manifest";
    private static final Set<Attributes.Name> IGNORED_KEYS = Set.of(new Attributes.Name("Archiver-Version"), new Attributes.Name("Created-By"), new Attributes.Name("Build-Jdk"), new Attributes.Name("Built-By"), new Attributes.Name("Build-Jdk-Spec"), new Attributes.Name("Bnd-LastModified"), new Attributes.Name("Tool"), new Attributes.Name("Eclipse-SourceReferences"));

    @Override
    public ArtifactDelta getDelta(InputStream baseline, InputStream reactor, ArtifactComparator.ComparisonData data) throws IOException {
        TreeMap<String, ArtifactDelta> result = new TreeMap<String, ArtifactDelta>();
        Manifest manifest = new Manifest(baseline);
        Manifest manifest2 = new Manifest(reactor);
        Attributes attributes = manifest.getMainAttributes();
        Attributes attributes2 = manifest2.getMainAttributes();
        LinkedHashSet<Attributes.Name> names = new LinkedHashSet<Attributes.Name>();
        names.addAll(this.getNames(attributes));
        names.addAll(this.getNames(attributes2));
        for (Attributes.Name key : names) {
            String value = attributes.getValue(key);
            if (value == null) {
                this.addDelta(result, key, "not present in baseline version");
                continue;
            }
            String value2 = attributes2.getValue(key);
            if (value2 == null) {
                this.addDelta(result, key, "present in baseline version only");
                continue;
            }
            if (value.equals(value2)) continue;
            this.addDelta(result, key, "baseline='" + value + "' != reactor='" + value2 + "'");
        }
        return !result.isEmpty() ? new CompoundArtifactDelta("different", result) : null;
    }

    private void addDelta(TreeMap<String, ArtifactDelta> result, Attributes.Name key, String message) {
        result.put(key.toString(), new SimpleArtifactDelta(message));
    }

    protected Set<Attributes.Name> getNames(Attributes attributes) {
        LinkedHashSet<Attributes.Name> result = new LinkedHashSet<Attributes.Name>();
        for (Object key : attributes.keySet()) {
            Attributes.Name name = (Attributes.Name)key;
            if (IGNORED_KEYS.contains(name)) continue;
            result.add(name);
        }
        return result;
    }
}

