/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.MatchPatterns;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.CompoundArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;

@Component(role=ArtifactComparator.class, hint="zip")
public class ZipComparatorImpl
implements ArtifactComparator {
    public static final String TYPE = "zip";
    private static final List<String> IGNORED_PATTERNS = List.of("META-INF/maven/**");
    @Requirement
    private Logger log;
    @Requirement
    private Map<String, ContentsComparator> comparators;

    @Override
    public CompoundArtifactDelta getDelta(File baseline, File reactor, ArtifactComparator.ComparisonData data) throws IOException {
        LinkedHashMap<String, ArtifactDelta> result = new LinkedHashMap<String, ArtifactDelta>();
        HashSet<String> ignoredPatterns = new HashSet<String>(IGNORED_PATTERNS);
        ignoredPatterns.addAll(data.ignoredPattern());
        MatchPatterns ignored = MatchPatterns.from(ignoredPatterns);
        try (ZipFile baselineJar = new ZipFile(baseline);
             ZipFile reactorJar = new ZipFile(reactor);){
            Map<String, ZipEntry> baselineEntries = ZipComparatorImpl.toEntryMap(baselineJar, ignored);
            Map<String, ZipEntry> reachtorEntries = ZipComparatorImpl.toEntryMap(reactorJar, ignored);
            TreeSet<String> names = new TreeSet<String>();
            names.addAll(baselineEntries.keySet());
            names.addAll(reachtorEntries.keySet());
            for (String name : names) {
                ArtifactDelta delta = this.getDelta(name, baselineEntries, reachtorEntries, baselineJar, reactorJar, data);
                if (delta == null) continue;
                result.put(name, delta);
            }
        }
        return !result.isEmpty() ? new CompoundArtifactDelta("different", result) : null;
    }

    private ArtifactDelta getDelta(String name, Map<String, ZipEntry> baseline, Map<String, ZipEntry> reactor, ZipFile baselineJar, ZipFile reactorJar, ArtifactComparator.ComparisonData data) throws IOException {
        ZipEntry baselineEntry = baseline.get(name);
        if (baselineEntry == null) {
            return new SimpleArtifactDelta("not present in baseline");
        }
        ZipEntry reactorEntry = reactor.get(name);
        if (reactorEntry == null) {
            return new SimpleArtifactDelta("present in baseline only");
        }
        try (InputStream is = baselineJar.getInputStream(baselineEntry);){
            ArtifactDelta artifactDelta;
            block14: {
                InputStream is2 = reactorJar.getInputStream(reactorEntry);
                try {
                    ContentsComparator comparator = this.comparators.get(this.getContentType(name));
                    artifactDelta = comparator.getDelta(is, is2, data);
                    if (is2 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (is2 != null) {
                        try {
                            is2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is2.close();
            }
            return artifactDelta;
        }
    }

    private String getContentType(String name) {
        if ((name = name.toLowerCase(Locale.ENGLISH)).endsWith(".class")) {
            return "class";
        }
        if (name.endsWith(".jar") || name.endsWith(".zip")) {
            return TYPE;
        }
        if (name.endsWith(".properties") || name.endsWith(".mappings")) {
            return "properties";
        }
        if ("meta-inf/manifest.mf".equals(name)) {
            return "manifest";
        }
        return "default";
    }

    private static Map<String, ZipEntry> toEntryMap(ZipFile zip, MatchPatterns ignored) {
        LinkedHashMap<String, ZipEntry> result = new LinkedHashMap<String, ZipEntry>(zip.size());
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || ignored.matches(entry.getName(), false)) continue;
            result.put(entry.getName(), entry);
        }
        return result;
    }
}

