/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.artifactcomparator.ComparatorInputStream;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.TextComparator;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;

@Component(role=ContentsComparator.class, hint="xml")
public class XmlComparator
implements ContentsComparator {
    static final String HINT = "xml";
    private static final Set<String> ALIAS = Set.of("xml", "exsd", "genmodel", "xsd", "xsd2ecore", "ecore");

    @Override
    public ArtifactDelta getDelta(ComparatorInputStream baseline, ComparatorInputStream reactor, ArtifactComparator.ComparisonData data) throws IOException {
        try {
            Diff baselineDiff = this.computeDiff(baseline, reactor);
            if (baselineDiff.hasDifferences()) {
                String message = baselineDiff.fullDescription();
                return TextComparator.createDelta(message, baseline, reactor, data);
            }
            return null;
        }
        catch (RuntimeException e) {
            return TextComparator.createDelta(ArtifactDelta.DEFAULT.getMessage(), baseline, reactor, data);
        }
    }

    private Diff computeDiff(InputStream baseline, InputStream reactor) {
        return DiffBuilder.compare((Object)Input.fromStream((InputStream)baseline)).withTest((Object)Input.fromStream((InputStream)reactor)).checkForSimilar().ignoreComments().ignoreWhitespace().build();
    }

    @Override
    public boolean matches(String nameOrExtension) {
        return ALIAS.contains(nameOrExtension.toLowerCase());
    }
}

