/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.MatchPatterns;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.CompoundArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;

@Component(role=ArtifactComparator.class, hint="zip")
public class ZipComparatorImpl
implements ArtifactComparator {
    public static final String TYPE = "zip";
    private static final List<String> IGNORED_PATTERNS = List.of("META-INF/maven/**");
    @Requirement
    private Logger log;
    @Requirement
    private Map<String, ContentsComparator> comparators;

    @Override
    public ArtifactDelta getDelta(File baseline, File reactor, ArtifactComparator.ComparisonData data) throws IOException {
        LinkedHashMap<String, ArtifactDelta> result = new LinkedHashMap<String, ArtifactDelta>();
        HashSet<String> ignoredPatterns = new HashSet<String>(IGNORED_PATTERNS);
        ignoredPatterns.addAll(data.ignoredPattern());
        MatchPatterns ignored = MatchPatterns.from(ignoredPatterns);
        try (ZipFile baselineJar = new ZipFile(baseline);
             ZipFile reactorJar = new ZipFile(reactor);){
            Map<String, ZipEntry> baselineEntries = ZipComparatorImpl.toEntryMap(baselineJar, ignored);
            Map<String, ZipEntry> reachtorEntries = ZipComparatorImpl.toEntryMap(reactorJar, ignored);
            TreeSet<String> names = new TreeSet<String>();
            names.addAll(baselineEntries.keySet());
            names.addAll(reachtorEntries.keySet());
            for (String name : names) {
                ArtifactDelta delta = this.getDelta(name, baselineEntries, reachtorEntries, baselineJar, reactorJar, data);
                if (delta == null) continue;
                result.put(name, delta);
            }
        }
        catch (IOException e) {
            this.log.debug("Comparing baseline=" + baseline + " with reactor=" + reactor + " failed: " + e + " using direct byte compare!", (Throwable)e);
            if (FileUtils.contentEquals((File)baseline, (File)reactor)) {
                return null;
            }
            return ArtifactDelta.DEFAULT;
        }
        return !result.isEmpty() ? new CompoundArtifactDelta("different", result) : null;
    }

    /*
     * Exception decompiling
     */
    private ArtifactDelta getDelta(String name, Map<String, ZipEntry> baselineMap, Map<String, ZipEntry> reactorMap, ZipFile baselineJar, ZipFile reactorJar, ArtifactComparator.ComparisonData data) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ContentsComparator getContentsComparator(String name) {
        String extension = FilenameUtils.getExtension((String)name).toLowerCase();
        ContentsComparator comparator = this.comparators.get(extension);
        if (comparator != null) {
            return comparator;
        }
        if (name.equalsIgnoreCase("meta-inf/manifest.mf")) {
            return this.comparators.get("manifest");
        }
        return this.comparators.values().stream().filter(c -> c.matches(name) || c.matches(extension)).findFirst().orElseGet(() -> this.comparators.get("default"));
    }

    private static Map<String, ZipEntry> toEntryMap(ZipFile zip, MatchPatterns ignored) {
        return zip.stream().filter(e -> !e.isDirectory() && !ignored.matches(e.getName(), false)).collect(Collectors.toMap(e -> e.getName(), Function.identity()));
    }
}

