/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.artifactcomparator.ComparatorInputStream;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;

@Component(role=ContentsComparator.class, hint="zip")
public class NestedZipComparator
implements ContentsComparator {
    public static final String TYPE = "zip";
    @Requirement(hint="zip")
    private ArtifactComparator zipComparator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactDelta getDelta(ComparatorInputStream baseline, ComparatorInputStream reactor, ArtifactComparator.ComparisonData data) throws IOException {
        Path baselineZip = Files.createTempFile("baseline", ".zip", new FileAttribute[0]);
        Path reactorZip = Files.createTempFile("reactor", ".zip", new FileAttribute[0]);
        try {
            Files.copy(baseline, baselineZip, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(reactor, reactorZip, StandardCopyOption.REPLACE_EXISTING);
            ArtifactDelta artifactDelta = this.zipComparator.getDelta(baselineZip.toFile(), reactorZip.toFile(), data);
            return artifactDelta;
        }
        finally {
            Files.deleteIfExists(baselineZip);
            Files.deleteIfExists(reactorZip);
        }
    }

    @Override
    public boolean matches(String extension) {
        return TYPE.equalsIgnoreCase(extension) || "jar".equalsIgnoreCase(extension) || "war".equalsIgnoreCase(extension);
    }
}

