/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;

public class SimpleArtifactDelta
implements ArtifactDelta {
    private final String message;
    private final String baseline;
    private final String reactor;
    private final String detailed;

    public SimpleArtifactDelta(String message) {
        this(message, null, null);
    }

    public SimpleArtifactDelta(String message, String baseline, String reactor) {
        this(message, message, baseline, reactor);
    }

    public SimpleArtifactDelta(String message, String detailed, String baseline, String reactor) {
        this.detailed = detailed;
        this.baseline = baseline;
        this.reactor = reactor;
        if (message == null) {
            throw new IllegalArgumentException();
        }
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getDetailedMessage() {
        return this.detailed;
    }

    public String getBaseline() {
        return this.baseline;
    }

    public String getReactor() {
        return this.reactor;
    }

    @Override
    public void writeDetails(File destination) throws IOException {
        if (this.getBaseline() != null) {
            SimpleArtifactDelta.writeFile(destination.getParentFile(), destination.getName() + "-baseline", this.getBaseline());
        }
        if (this.getReactor() != null) {
            SimpleArtifactDelta.writeFile(destination.getParentFile(), destination.getName() + "-build", this.getReactor());
        }
    }

    protected static void writeFile(File basedir, String path, String data) throws IOException {
        File file = new File(basedir, path).getAbsoluteFile();
        file.getParentFile().mkdirs();
        Files.writeString(file.toPath(), (CharSequence)data, new OpenOption[0]);
    }

    protected static void writeFile(File basedir, String path, InputStream data) throws IOException {
        File file = new File(basedir, path).getAbsoluteFile();
        file.getParentFile().mkdirs();
        Files.copy(data, file.toPath(), new CopyOption[0]);
    }
}

