/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.zipcomparator.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.zipcomparator.internal.SimpleArtifactDelta;

public class CompoundArtifactDelta
extends SimpleArtifactDelta {
    private final Map<String, ArtifactDelta> members;

    public CompoundArtifactDelta(String message, Map<String, ? extends ArtifactDelta> members) {
        super(message);
        if (members == null || members.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.members = Collections.unmodifiableMap(new LinkedHashMap<String, ArtifactDelta>(members));
    }

    public Map<String, ArtifactDelta> getMembers() {
        return this.members;
    }

    @Override
    public String getDetailedMessage() {
        StringBuilder message = new StringBuilder(this.getMessage()).append(System.lineSeparator());
        this.appendDetailedMessage(message, 1);
        return message.toString();
    }

    protected void appendDetailedMessage(StringBuilder message, int indent) {
        for (Map.Entry<String, ArtifactDelta> member : this.members.entrySet()) {
            this.indent(message, indent);
            message.append(member.getKey()).append(": ").append(member.getValue().getMessage());
            message.append(System.lineSeparator());
            ArtifactDelta artifactDelta = member.getValue();
            if (!(artifactDelta instanceof CompoundArtifactDelta)) continue;
            CompoundArtifactDelta compoundDelta = (CompoundArtifactDelta)artifactDelta;
            compoundDelta.appendDetailedMessage(message, indent + 1);
        }
    }

    private void indent(StringBuilder message, int indent) {
        for (int i = 0; i < indent; ++i) {
            message.append("   ");
        }
    }

    @Override
    public void writeDetails(File basedir) throws IOException {
        for (Map.Entry<String, ArtifactDelta> member : this.members.entrySet()) {
            ArtifactDelta memberDelta = member.getValue();
            memberDelta.writeDetails(new File(basedir, member.getKey()));
        }
    }
}

