/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.baseline;

import de.vandermeer.asciitable.AT_Cell;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.artifactcomparator.ComparatorInputStream;
import org.eclipse.tycho.baseline.ArtifactBaselineComparator;
import org.eclipse.tycho.baseline.BaselineContext;
import org.eclipse.tycho.p2.metadata.P2Generator;
import org.eclipse.tycho.p2.metadata.PublisherOptions;
import org.eclipse.tycho.p2maven.io.MetadataIO;
import org.eclipse.tycho.p2maven.repository.P2RepositoryManager;
import org.eclipse.tycho.p2resolver.ArtifactFacade;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;

@Component(role=ArtifactBaselineComparator.class, hint="eclipse-feature")
public class FeatureBaselineComparator
implements ArtifactBaselineComparator {
    private static final int WIDTH = 160;
    private static final String GROUP_SUFFIX = ".feature.group";
    private static final String JAR_SUFFIX = ".feature.jar";
    @Requirement(hint="zip")
    ContentsComparator zipComparator;
    @Requirement
    MetadataIO metadataIO;
    @Requirement
    P2Generator p2generator;
    @Requirement
    P2RepositoryManager repositoryManager;

    @Override
    public boolean compare(MavenProject project, BaselineContext context) throws Exception {
        ArtifactKey key = context.getArtifactKey();
        IInstallableUnit baselineGroupUnit = this.getBaselineUnit(key, context.getMetadataRepository());
        if (baselineGroupUnit == null) {
            return false;
        }
        IInstallableUnit baselineJarUnit = this.getJarUnit(key, baselineGroupUnit, context.getMetadataRepository());
        if (baselineJarUnit == null) {
            return false;
        }
        IQueryable<IInstallableUnit> projectUnits = this.getProjectUnits(project);
        IInstallableUnit projectGroupUnit = this.getBaselineUnit(key, projectUnits);
        IInstallableUnit projectJarUnit = this.getJarUnit(key, projectGroupUnit, projectUnits);
        if (projectGroupUnit == null || projectJarUnit == null) {
            throw new MojoExecutionException("Can't find required project units!");
        }
        List<Diff> propertyDiffs = FeatureBaselineComparator.computePropertyDiff(baselineGroupUnit.getProperties(), projectGroupUnit.getProperties());
        List<Diff> jarDiffs = this.computeJarDelta(project, context, baselineJarUnit);
        List<Diff> requirementDiffs = this.computeRequirementDelta(this.getRequirements(baselineGroupUnit), this.getRequirements(projectGroupUnit));
        ImpliedVersionChange change = jarDiffs.isEmpty() && propertyDiffs.isEmpty() ? ImpliedVersionChange.UNCHANGED : ImpliedVersionChange.MICRO;
        for (Diff diff : requirementDiffs) {
            if (diff.change.ordinal() <= change.ordinal()) continue;
            change = diff.change;
        }
        if (this.needsVersionBump(baselineGroupUnit.getVersion(), projectGroupUnit.getVersion(), change, context)) {
            Version suggestedVersion = this.getSuggestedVersion(projectGroupUnit.getVersion(), change, context);
            AsciiTable at = new AsciiTable();
            at.addRule();
            at.addRow(new Object[]{"Change", "Delta", "Type", "Name", "Project Version", "Baseline Version", "Suggested Version"});
            at.addRule();
            at.addRow(new Object[]{change, Delta.CHANGED, "FEATURE", project.getName(), projectGroupUnit.getVersion(), baselineGroupUnit.getVersion(), suggestedVersion});
            ImpliedVersionChange threshold = this.computeThreshold(baselineGroupUnit.getVersion(), projectGroupUnit.getVersion());
            this.addDiffs(requirementDiffs, threshold, at);
            this.addDiffs(propertyDiffs, threshold, at);
            this.addDiffs(jarDiffs, threshold, at);
            at.addRule();
            Logger logger = context.getLogger();
            try {
                at.renderAsIterator(160).forEachRemaining(arg_0 -> ((Logger)logger).error(arg_0));
            }
            catch (RuntimeException e) {
                for (AT_Row row : at.getRawContent()) {
                    LinkedList cells = row.getCells();
                    if (cells == null) continue;
                    StringBuilder sb = new StringBuilder();
                    for (AT_Cell cell : cells) {
                        sb.append(cell.getContent());
                        sb.append(" |\t");
                    }
                    logger.error(sb.toString());
                }
            }
            StringBuilder message = new StringBuilder("Baseline problems found! ");
            message.append("Project version: ");
            message.append(projectGroupUnit.getVersion());
            message.append(", baseline version: ");
            message.append(baselineGroupUnit.getVersion());
            message.append(", suggested version: ");
            message.append(suggestedVersion);
            context.reportBaselineProblem(message.toString(), new org.osgi.framework.Version(suggestedVersion.toString()));
        }
        return true;
    }

    private ImpliedVersionChange computeThreshold(Version baselineVersion, Version projectVersion) {
        org.osgi.framework.Version bv = this.baseVersion(baselineVersion);
        org.osgi.framework.Version pv = this.baseVersion(projectVersion);
        if (pv.compareTo(bv) > 0) {
            if (pv.getMinor() > bv.getMinor()) {
                return ImpliedVersionChange.MAJOR;
            }
            if (pv.getMicro() > bv.getMicro()) {
                return ImpliedVersionChange.MINOR;
            }
        }
        return ImpliedVersionChange.UNCHANGED;
    }

    private boolean needsVersionBump(Version baselineVersion, Version projectVersion, ImpliedVersionChange change, BaselineContext context) {
        if (change == ImpliedVersionChange.UNCHANGED) {
            return false;
        }
        org.osgi.framework.Version bv = this.baseVersion(baselineVersion);
        return this.baseVersion(projectVersion).compareTo(switch (change.ordinal()) {
            case 3 -> new org.osgi.framework.Version(bv.getMajor() + 1, 0, 0);
            case 2 -> new org.osgi.framework.Version(bv.getMajor(), bv.getMinor() + 1, 0);
            case 1 -> new org.osgi.framework.Version(bv.getMajor(), bv.getMinor(), bv.getMicro() + context.getMicroIncrement());
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)change));
        }) < 0;
    }

    private void addDiffs(List<Diff> diffs, ImpliedVersionChange threshold, AsciiTable at) {
        for (Diff diff : diffs) {
            if (diff.change.ordinal() < threshold.ordinal()) continue;
            at.addRule();
            at.addRow(new Object[]{diff.change, diff.delta, diff.type, null, null, null, diff.message.replace(System.lineSeparator(), "<br>")}).setTextAlignment(TextAlignment.LEFT);
        }
    }

    private Version getSuggestedVersion(Version version, ImpliedVersionChange change, BaselineContext context) {
        if (change == ImpliedVersionChange.UNCHANGED) {
            return version;
        }
        org.osgi.framework.Version v = this.baseVersion(version);
        if (change == ImpliedVersionChange.MAJOR) {
            return Version.createOSGi((int)(v.getMajor() + 1), (int)0, (int)0);
        }
        if (change == ImpliedVersionChange.MINOR) {
            return Version.createOSGi((int)v.getMajor(), (int)(v.getMinor() + 1), (int)0);
        }
        return Version.createOSGi((int)v.getMajor(), (int)v.getMinor(), (int)(v.getMicro() + context.getMicroIncrement()));
    }

    private Collection<IRequiredCapability> getRequirements(IInstallableUnit unit) {
        return Stream.concat(unit.getRequirements().stream(), unit.getMetaRequirements().stream()).filter(IRequiredCapability.class::isInstance).map(IRequiredCapability.class::cast).filter(req -> this.isSingleVersionRequirement((IRequiredCapability)req)).toList();
    }

    private boolean isSingleVersionRequirement(IRequiredCapability cap) {
        VersionRange range = cap.getRange();
        return range.getMinimum().equals(range.getMaximum());
    }

    private List<Diff> computeRequirementDelta(Collection<IRequiredCapability> baselineRequirements, Collection<IRequiredCapability> projectRequirements) {
        Map<RequirementId, List<IRequiredCapability>> baselineMap = baselineRequirements.stream().collect(Collectors.groupingBy(FeatureBaselineComparator::idOf));
        Map<RequirementId, List<IRequiredCapability>> projectMap = projectRequirements.stream().collect(Collectors.groupingBy(FeatureBaselineComparator::idOf));
        HashSet<RequirementId> allIds = new HashSet<RequirementId>();
        allIds.addAll(baselineMap.keySet());
        allIds.addAll(projectMap.keySet());
        ArrayList<Diff> list = new ArrayList<Diff>();
        for (RequirementId id : allIds) {
            org.osgi.framework.Version projectVersion;
            List<IRequiredCapability> baselineValue = baselineMap.get(id);
            if (baselineValue == null || baselineValue.isEmpty()) {
                list.add(new Diff(ImpliedVersionChange.MINOR, Type.REQUIREMENT, Delta.ADDED, String.format("Requirement %s:%s not present in baseline version", id.namespace, id.name)));
                continue;
            }
            List<IRequiredCapability> projectValue = projectMap.get(id);
            if (projectValue == null || projectValue.isEmpty()) {
                list.add(new Diff(ImpliedVersionChange.MAJOR, Type.REQUIREMENT, Delta.REMOVED, String.format("Requirement %s:%s is removed from baseline version", id.namespace, id.name)));
                continue;
            }
            if (baselineValue.size() != 1 || projectValue.size() != 1) continue;
            IRequiredCapability baselineCapability = baselineValue.get(0);
            IRequiredCapability projectCapability = projectValue.get(0);
            org.osgi.framework.Version baselineVersion = this.baseVersion(baselineCapability);
            ImpliedVersionChange versionChange = this.computeVersionChange(baselineVersion, projectVersion = this.baseVersion(projectCapability));
            if (versionChange == ImpliedVersionChange.UNCHANGED) continue;
            list.add(new Diff(versionChange, Type.REQUIREMENT, Delta.CHANGED, String.format("Requirement %s:%s changed version from %s > %s", id.namespace, id.name, baselineVersion.toString(), projectVersion.toString())));
        }
        Collections.sort(list, Comparator.comparing(diff -> diff.change));
        return list;
    }

    private ImpliedVersionChange computeVersionChange(org.osgi.framework.Version baselineVersion, org.osgi.framework.Version projectVersion) {
        if (projectVersion.compareTo(baselineVersion) < 0) {
            return ImpliedVersionChange.MAJOR;
        }
        if (projectVersion.getMajor() > baselineVersion.getMajor()) {
            return ImpliedVersionChange.MAJOR;
        }
        if (projectVersion.getMinor() > baselineVersion.getMinor()) {
            return ImpliedVersionChange.MINOR;
        }
        if (projectVersion.getMicro() > baselineVersion.getMicro()) {
            return ImpliedVersionChange.MICRO;
        }
        return ImpliedVersionChange.UNCHANGED;
    }

    private org.osgi.framework.Version baseVersion(IRequiredCapability baselineCapability) {
        return this.baseVersion(baselineCapability.getRange().getMinimum());
    }

    private org.osgi.framework.Version baseVersion(Version p2Version) {
        org.osgi.framework.Version version = new org.osgi.framework.Version(p2Version.toString());
        return new org.osgi.framework.Version(version.getMajor(), version.getMinor(), version.getMicro());
    }

    private static RequirementId idOf(IRequiredCapability cap) {
        return new RequirementId(cap.getNamespace(), cap.getName());
    }

    private List<Diff> computeJarDelta(MavenProject project, BaselineContext context, IInstallableUnit baselineJarUnit) throws IOException {
        File file = project.getArtifact().getFile();
        try (FileInputStream reactor = new FileInputStream(file);){
            ArrayList<String> ignores = new ArrayList<String>();
            ignores.add("feature.xml");
            ignores.addAll(context.getIgnores());
            ArtifactDelta artifactDelta = this.zipComparator.getDelta(this.getStream(baselineJarUnit, context), new ComparatorInputStream((InputStream)reactor), new ArtifactComparator.ComparisonData(ignores, false));
            if (artifactDelta == null) {
                List<Diff> list = List.of();
                return list;
            }
            List<Diff> list = List.of(new Diff(ImpliedVersionChange.MICRO, Type.CONTENT, Delta.CHANGED, artifactDelta.getDetailedMessage()));
            return list;
        }
    }

    private ComparatorInputStream getStream(IInstallableUnit unit, BaselineContext context) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.repositoryManager.downloadArtifact(unit, context.getArtifactRepository(), (OutputStream)outputStream);
        return new ComparatorInputStream(outputStream.toByteArray());
    }

    private static final List<Diff> computePropertyDiff(Map<String, String> base, Map<String, String> project) {
        ArrayList<Diff> list = new ArrayList<Diff>();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.addAll(base.keySet());
        names.addAll(project.keySet());
        for (String name : names) {
            String baselineValue = base.get(name);
            if (baselineValue == null) {
                list.add(new Diff(ImpliedVersionChange.MICRO, Type.PROPERTY, Delta.ADDED, String.format("Property %s not present in baseline version", name)));
                continue;
            }
            String projectValue = project.get(name);
            if (projectValue == null) {
                list.add(new Diff(ImpliedVersionChange.MICRO, Type.PROPERTY, Delta.REMOVED, String.format("Property %s present in baseline version only", name)));
                continue;
            }
            if (FeatureBaselineComparator.propertyEquals(baselineValue, projectValue)) continue;
            int indexOfDifference = FeatureBaselineComparator.indexOfDifference(baselineValue, projectValue);
            list.add(new Diff(ImpliedVersionChange.MICRO, Type.PROPERTY, Delta.CHANGED, String.format("Property %s is different, baseline = %s, project = %s (first index of difference is %s", name, baselineValue, projectValue, indexOfDifference)));
        }
        return list;
    }

    private static boolean propertyEquals(String baselineValue, String projectValue) {
        if (baselineValue.equals(projectValue)) {
            return true;
        }
        String normalizdBl = baselineValue.replaceAll("\\s", " ").replaceAll("\\s+", " ").trim();
        String normalizdPr = projectValue.replaceAll("\\s", " ").replaceAll("\\s+", " ").trim();
        return normalizdBl.equals(normalizdPr);
    }

    private static int indexOfDifference(CharSequence s1, CharSequence s2) {
        int length = Math.min(s1.length(), s2.length());
        for (int i = 0; i < length; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i))) continue;
            return i;
        }
        return length;
    }

    private IQueryable<IInstallableUnit> getProjectUnits(MavenProject project) throws IOException {
        for (Artifact artifact : project.getAttachedArtifacts()) {
            File file;
            if (!"p2metadata".equals(artifact.getClassifier()) || (file = artifact.getFile()) == null || !file.exists()) continue;
            return new CollectionResult((Collection)this.metadataIO.readXML(file));
        }
        File targetDir = new File(project.getBuild().getDirectory());
        ArtifactFacade projectDefaultArtifact = new ArtifactFacade(project.getArtifact());
        Map generatedMetadata = this.p2generator.generateMetadata(List.of(projectDefaultArtifact), new PublisherOptions(), targetDir);
        return new CollectionResult(generatedMetadata.values().stream().flatMap(a -> a.getInstallableUnits().stream()).toList());
    }

    private IInstallableUnit getJarUnit(ArtifactKey key, IInstallableUnit baselineUnit, IQueryable<IInstallableUnit> metadataRepository) {
        IQueryResult result = metadataRepository.query(QueryUtil.createIUQuery((String)(key.getId() + JAR_SUFFIX), (Version)baselineUnit.getVersion()), null);
        if (result.isEmpty()) {
            return null;
        }
        return (IInstallableUnit)result.iterator().next();
    }

    private IInstallableUnit getBaselineUnit(ArtifactKey key, IQueryable<IInstallableUnit> metadataRepository) {
        org.osgi.framework.Version artifactVersion = org.osgi.framework.Version.parseVersion((String)key.getVersion());
        Version maxVersion = Version.createOSGi((int)artifactVersion.getMajor(), (int)artifactVersion.getMinor(), (int)(artifactVersion.getMicro() + 1));
        IQueryResult result = metadataRepository.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)(key.getId() + GROUP_SUFFIX), (VersionRange)new VersionRange(Version.emptyVersion, true, maxVersion, false))), null);
        if (result.isEmpty()) {
            return null;
        }
        return (IInstallableUnit)result.iterator().next();
    }

    private static enum ImpliedVersionChange {
        UNCHANGED,
        MICRO,
        MINOR,
        MAJOR;

    }

    private record Diff(ImpliedVersionChange change, Type type, Delta delta, String message) {
    }

    private static enum Delta {
        ADDED,
        REMOVED,
        CHANGED;

    }

    private static enum Type {
        CONTENT,
        PROPERTY,
        REQUIREMENT;

    }

    private record RequirementId(String namespace, String name) {
    }
}

