/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.baseline.analyze;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.tycho.baseline.analyze.JrtClasses;
import org.eclipse.tycho.baseline.analyze.MethodSignature;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassUsage {
    private Set<MethodSignature> usedMethodSignatures = new HashSet<MethodSignature>();
    private Map<MethodSignature, Collection<String>> classRef = new HashMap<MethodSignature, Collection<String>>();

    public ClassUsage(byte[] classbytes, final JrtClasses jrt) {
        ClassReader reader = new ClassReader(classbytes);
        reader.accept(new ClassVisitor(589824){
            private String className;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name.replace('/', '.');
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                return new MethodVisitor(589824){

                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        if (jrt.apply(owner).isPresent()) {
                            return;
                        }
                        MethodSignature sig = new MethodSignature(owner, name, descriptor);
                        ClassUsage.this.classRef.computeIfAbsent(sig, nil -> new TreeSet()).add(className);
                        ClassUsage.this.usedMethodSignatures.add(sig);
                    }
                };
            }
        }, 4);
    }

    public Stream<MethodSignature> signatures() {
        return this.usedMethodSignatures.stream();
    }

    public Collection<String> classRef(MethodSignature mthd) {
        return this.classRef.getOrDefault(mthd, List.of());
    }
}

