/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.baseline.analyze;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.tycho.baseline.analyze.ClassMethods;
import org.eclipse.tycho.baseline.analyze.DependencyAnalyzer;

public class JrtClasses
implements Function<String, Optional<ClassMethods>> {
    private Path rootPath;
    private Map<String, Optional<ClassMethods>> cache = new ConcurrentHashMap<String, Optional<ClassMethods>>();

    public JrtClasses(String javaHome) {
        try {
            Map<Object, Object> map = javaHome != null ? Map.of("java.home", javaHome) : Map.of();
            FileSystem fs = FileSystems.newFileSystem(URI.create("jrt:/"), map);
            this.rootPath = fs.getPath("/packages", new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Optional<ClassMethods> apply(String className) {
        if (this.rootPath == null) {
            return Optional.empty();
        }
        return this.cache.computeIfAbsent(className.replace('.', '/'), path -> this.lookupJreClass(className));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<ClassMethods> lookupJreClass(String classPath) {
        String packageName = DependencyAnalyzer.getPackageName(classPath);
        Path modulesPath = this.rootPath.resolve(packageName);
        if (!Files.isDirectory(modulesPath, new LinkOption[0])) return Optional.empty();
        try (Stream<Path> module = Files.list(modulesPath);){
            Path modulePath;
            Path classFile;
            Iterator iterator = module.iterator();
            do {
                if (!iterator.hasNext()) return Optional.empty();
            } while (!Files.isRegularFile(classFile = (modulePath = (Path)iterator.next()).resolve(classPath + ".class"), new LinkOption[0]));
            Optional<ClassMethods> optional = Optional.of(new ClassMethods(Files.readAllBytes(classFile), this));
            return optional;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }
}

