/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.baseline.provider;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.artifacts.ArtifactVersion;
import org.eclipse.tycho.artifacts.ArtifactVersionProvider;
import org.eclipse.tycho.copyfrom.oomph.P2Index;
import org.eclipse.tycho.copyfrom.oomph.P2IndexImpl;
import org.eclipse.tycho.core.resolver.target.ArtifactMatcher;
import org.eclipse.tycho.p2maven.repository.P2RepositoryManager;
import org.eclipse.tycho.p2maven.transport.TransportCacheConfig;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

@Named
public class EclipseIndexArtifactVersionProvider
implements ArtifactVersionProvider {
    private P2Index p2Index;
    private P2RepositoryManager repositoryManager;
    private Logger logger;

    @Inject
    public EclipseIndexArtifactVersionProvider(TransportCacheConfig cacheConfig, P2RepositoryManager repositoryManager, Logger logger) {
        this.repositoryManager = repositoryManager;
        this.logger = logger;
        this.p2Index = new P2IndexImpl(new File(cacheConfig.getCacheLocation(), "index"));
    }

    public Stream<ArtifactVersion> getPackageVersions(IInstallableUnit unit, String packageName, VersionRange versionRange, MavenProject mavenProject) {
        Map<P2Index.Repository, Set<org.eclipse.equinox.p2.metadata.Version>> map = this.p2Index.lookupCapabilities("java.package", packageName);
        HashMap found = new HashMap();
        map.entrySet().forEach(entry -> ((Set)entry.getValue()).stream().filter(v -> v.isOSGiCompatible()).forEach(v -> found.computeIfAbsent(v, x -> new ArrayList()).add((P2Index.Repository)entry.getKey())));
        String id = unit.getId();
        return found.entrySet().stream().map(entry -> new EclipseIndexArtifactVersion((List)entry.getValue(), id, packageName, (org.eclipse.equinox.p2.metadata.Version)entry.getKey(), this.logger)).filter(eia -> versionRange.includes(eia.getVersion())).sorted(Comparator.comparing(EclipseIndexArtifactVersion::getVersion).reversed()).map(ArtifactVersion.class::cast);
    }

    private class EclipseIndexArtifactVersion
    implements ArtifactVersion {
        private org.eclipse.equinox.p2.metadata.Version version;
        private String packageName;
        private Path tempFile;
        private String unitId;
        private List<P2Index.Repository> repositories;
        private Version osgiVersion;
        private Optional<IInstallableUnit> unit;
        private P2Index.Repository unitRepo;

        public EclipseIndexArtifactVersion(List<P2Index.Repository> repositories, String unitId, String packageName, org.eclipse.equinox.p2.metadata.Version version, Logger logger) {
            this.osgiVersion = Version.parseVersion((String)version.getOriginal());
            this.repositories = repositories;
            this.unitId = unitId;
            this.packageName = packageName;
            this.version = version;
        }

        public Path getArtifact() {
            IInstallableUnit unit;
            if (this.tempFile == null && (unit = (IInstallableUnit)this.getUnit().orElse(null)) != null) {
                Path file;
                try {
                    file = Files.createTempFile(unit.getId(), ".jar", new FileAttribute[0]);
                }
                catch (IOException e) {
                    return null;
                }
                file.toFile().deleteOnExit();
                ArrayList<P2Index.Repository> list = new ArrayList<P2Index.Repository>(this.repositories);
                if (this.unitRepo != null) {
                    list.remove(this.unitRepo);
                    list.add(0, this.unitRepo);
                }
                for (P2Index.Repository repository : list) {
                    Path path;
                    block13: {
                        Repository r = new Repository();
                        r.setUrl(repository.getLocation().toString());
                        OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);
                        try {
                            EclipseIndexArtifactVersionProvider.this.repositoryManager.downloadArtifact(unit, EclipseIndexArtifactVersionProvider.this.repositoryManager.getArtifactRepository(r), stream);
                            path = this.tempFile = file;
                            if (stream == null) break block13;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                EclipseIndexArtifactVersionProvider.this.logger.error("Fetch artifact for unit " + unit.getId() + " from " + String.valueOf(repository.getLocation()) + " failed: " + String.valueOf(e));
                            }
                        }
                        stream.close();
                    }
                    return path;
                }
                file.toFile().delete();
            }
            return this.tempFile;
        }

        private Optional<IInstallableUnit> getUnit() {
            if (this.unit == null) {
                for (P2Index.Repository repository : this.repositories) {
                    try {
                        Repository r = new Repository();
                        r.setUrl(repository.getLocation().toString());
                        IMetadataRepository metadataRepository = EclipseIndexArtifactVersionProvider.this.repositoryManager.getMetadataRepository(r);
                        Optional optional = ArtifactMatcher.findPackage((String)this.packageName, (IQueryResult)metadataRepository.query(QueryUtil.createIUQuery((String)this.unitId), null), (org.eclipse.equinox.p2.metadata.Version)this.version);
                        if (optional.isPresent()) {
                            this.unitRepo = repository;
                            this.unit = optional;
                            return this.unit;
                        }
                        EclipseIndexArtifactVersionProvider.this.logger.debug("Package " + this.packageName + " not found in metadata of " + String.valueOf(repository.getLocation()));
                    }
                    catch (Exception e) {
                        EclipseIndexArtifactVersionProvider.this.logger.error("Fetch metadata from " + String.valueOf(repository.getLocation()) + ":: " + String.valueOf(e));
                    }
                }
                this.unit = Optional.empty();
            }
            return Objects.requireNonNullElse(this.unit, Optional.empty());
        }

        public Version getVersion() {
            return this.osgiVersion;
        }

        public String toString() {
            if (this.unit != null && this.unit.isPresent()) {
                return String.valueOf(this.getVersion()) + " (" + String.valueOf(this.unit.get()) + ")";
            }
            return this.getVersion().toString();
        }

        public String getProvider() {
            return this.getUnit().map(unit -> unit.getId() + " " + String.valueOf(unit.getVersion())).orElse(null);
        }
    }
}

