/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.copyfrom.oomph;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.tycho.copyfrom.oomph.P2Index;

public class P2IndexImpl
implements P2Index {
    private static final String INDEX_BASE = "https://download.eclipse.org/oomph/index/";
    private long timeStamp;
    private Map<Integer, RepositoryImpl> repositories;
    private P2Index.Repository[] repositoriesArray;
    private Map<String, Set<String>> capabilitiesMap;
    private File repositoriesCacheFile;
    private File capabilitiesCacheFile;
    private int capabilitiesRefreshHours = -1;
    private int repositoriesRefreshHours = -1;
    private File basedir;

    public P2IndexImpl(File basedir) {
        this.basedir = basedir;
        basedir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initCapabilities() {
        block16: {
            if (this.capabilitiesMap == null || this.capabilitiesCacheFile.lastModified() + (long)(this.capabilitiesRefreshHours * 60 * 60 * 1000) < System.currentTimeMillis()) {
                this.capabilitiesMap = new LinkedHashMap<String, Set<String>>();
                ZipFile zipFile = null;
                InputStream inputStream = null;
                try {
                    this.initCapabilitiesCacheFile();
                    zipFile = new ZipFile(this.capabilitiesCacheFile);
                    ZipEntry zipEntry = zipFile.getEntry("capabilities");
                    inputStream = zipFile.getInputStream(zipEntry);
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
                    options.put("DATA_CONVERTER", Boolean.TRUE);
                    options.put("BUFFER_CAPACITY", 8192);
                    BinaryResourceImpl.EObjectInputStream stream = new BinaryResourceImpl.EObjectInputStream(inputStream, options);
                    this.capabilitiesRefreshHours = stream.readInt();
                    int mapSize = stream.readCompressedInt();
                    for (int i = 0; i < mapSize; ++i) {
                        String key = stream.readSegmentedString();
                        int valuesSize = stream.readCompressedInt();
                        for (int j = 0; j < valuesSize; ++j) {
                            String value = stream.readSegmentedString();
                            P2IndexImpl.add(this.capabilitiesMap, key, value);
                        }
                    }
                    P2IndexImpl.closeSilent(inputStream);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    break block16;
                }
                finally {
                    P2IndexImpl.closeSilent(inputStream);
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException zipEntry) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void initRepositories(boolean force) {
        if (this.repositories != null && !force) {
            if (this.repositoriesCacheFile.lastModified() + (long)(this.repositoriesRefreshHours * 60 * 60 * 1000) >= System.currentTimeMillis()) return;
        }
        this.repositories = new HashMap<Integer, RepositoryImpl>();
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            this.initRepositoriesCacheFile();
            zipFile = new ZipFile(this.repositoriesCacheFile);
            ZipEntry zipEntry22 = zipFile.getEntry("repositories");
            inputStream = zipFile.getInputStream(zipEntry22);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
            options.put("DATA_CONVERTER", Boolean.TRUE);
            options.put("BUFFER_CAPACITY", 8192);
            BinaryResourceImpl.EObjectInputStream stream = new BinaryResourceImpl.EObjectInputStream(inputStream, options);
            this.timeStamp = stream.readLong();
            this.repositoriesRefreshHours = stream.readInt();
            int repositoryCount = stream.readInt();
            HashMap<RepositoryImpl, List<Integer>> composedRepositories = new HashMap<RepositoryImpl, List<Integer>>();
            for (int id = 1; id <= repositoryCount; ++id) {
                RepositoryImpl repository = new RepositoryImpl(stream, id, composedRepositories);
                this.repositories.put(id, repository);
            }
            for (Map.Entry entry : composedRepositories.entrySet()) {
                RepositoryImpl repository = (RepositoryImpl)entry.getKey();
                Iterator iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    int compositeID = (Integer)iterator.next();
                    RepositoryImpl composite = this.repositories.get(compositeID);
                    if (composite == null) continue;
                    composite.addChild(repository);
                    repository.addComposite(composite);
                }
            }
            try {
                int problematicRepositories = stream.readInt();
                for (int i = 0; i < problematicRepositories; ++i) {
                    int id = stream.readInt();
                    int unresolvedChildren = stream.readInt();
                    RepositoryImpl repository = this.repositories.get(id);
                    repository.unresolvedChildren = unresolvedChildren;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repositoriesArray = this.repositories.values().toArray(new P2Index.Repository[this.repositories.size()]);
            P2IndexImpl.close(inputStream);
            if (zipFile == null) return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            zipFile.close();
            return;
        }
        catch (IOException zipEntry22) {
            return;
        }
        finally {
            P2IndexImpl.close(inputStream);
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean initRepositoriesCacheFile() throws Exception {
        if (this.repositoriesCacheFile == null) {
            this.repositoriesCacheFile = new File(this.basedir, "repositories");
        }
        P2IndexImpl.downloadIfModifiedSince(new URL("https://download.eclipse.org/oomph/index/repositories"), this.repositoriesCacheFile);
        return true;
    }

    private boolean initCapabilitiesCacheFile() throws Exception {
        if (this.capabilitiesCacheFile == null) {
            this.capabilitiesCacheFile = new File(this.basedir, "capabilities");
        }
        P2IndexImpl.downloadIfModifiedSince(new URL("https://download.eclipse.org/oomph/index/capabilities"), this.capabilitiesCacheFile);
        return true;
    }

    @Override
    public P2Index.Repository[] getRepositories() {
        this.initRepositories(false);
        return this.repositoriesArray;
    }

    @Override
    public Map<String, Set<String>> getCapabilities() {
        this.initCapabilities();
        return Collections.unmodifiableMap(this.capabilitiesMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<P2Index.Repository, Set<Version>> lookupCapabilities(String namespace, String name) {
        this.initCapabilities();
        HashMap<P2Index.Repository, Set<Version>> capabilities = new HashMap<P2Index.Repository, Set<Version>>();
        if (!P2IndexImpl.isEmpty(namespace) && !P2IndexImpl.isEmpty(name)) {
            namespace = URI.encodeSegment((String)namespace, (boolean)false);
            name = URI.encodeSegment((String)name, (boolean)false);
            BufferedReader reader = null;
            try {
                InputStream inputStream = new URL(INDEX_BASE + namespace + "/" + name).openStream();
                reader = new BufferedReader(new InputStreamReader(inputStream));
                String line = reader.readLine();
                if (line == null) {
                    HashMap<P2Index.Repository, Set<Version>> hashMap = capabilities;
                    P2IndexImpl.close(reader);
                    return hashMap;
                }
                long timeStamp = Long.parseLong(line);
                this.initRepositories(timeStamp != this.timeStamp);
                while ((line = reader.readLine()) != null) {
                    String[] tokens = line.split(",");
                    int repositoryID = Integer.parseInt(tokens[0]);
                    P2Index.Repository repository = this.repositories.get(repositoryID);
                    if (repository == null) continue;
                    HashSet<Version> versions = new HashSet<Version>();
                    for (int i = 1; i < tokens.length; ++i) {
                        versions.add(Version.parseVersion((String)tokens[i]));
                    }
                    capabilities.put(repository, versions);
                }
                P2IndexImpl.close(reader);
            }
            catch (FileNotFoundException inputStream) {
                P2IndexImpl.close(reader);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                P2IndexImpl.close(reader);
            }
        }
        return capabilities;
    }

    @Override
    public Map<P2Index.Repository, Set<Version>> generateCapabilitiesFromComposedRepositories(Map<P2Index.Repository, Set<Version>> capabilitiesFromSimpleRepositories) {
        HashMap<P2Index.Repository, Set<Version>> capabilities = new HashMap<P2Index.Repository, Set<Version>>();
        for (Map.Entry<P2Index.Repository, Set<Version>> entry : capabilitiesFromSimpleRepositories.entrySet()) {
            P2Index.Repository repository = entry.getKey();
            Set<Version> versions = entry.getValue();
            this.recurseComposedRepositories(capabilities, repository, versions);
        }
        return capabilities;
    }

    private void recurseComposedRepositories(Map<P2Index.Repository, Set<Version>> capabilities, P2Index.Repository repository, Set<Version> versions) {
        for (P2Index.Repository composite : repository.getComposites()) {
            Set<Version> set = capabilities.get(composite);
            if (set == null) {
                set = new HashSet<Version>();
                capabilities.put(composite, set);
            }
            set.addAll(versions);
            this.recurseComposedRepositories(capabilities, composite, versions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadIfModifiedSince(URL url, File file) throws IOException {
        HttpURLConnection connection;
        FileOutputStream outputStream;
        InputStream inputStream;
        block5: {
            long lastModified = -1L;
            if (file.isFile()) {
                lastModified = file.lastModified();
            }
            inputStream = null;
            outputStream = null;
            try {
                connection = (HttpURLConnection)url.openConnection();
                if (lastModified != -1L) {
                    connection.setIfModifiedSince(lastModified);
                }
                connection.connect();
                inputStream = connection.getInputStream();
                if (connection.getResponseCode() != 304) break block5;
            }
            catch (Throwable throwable) {
                P2IndexImpl.close(outputStream);
                P2IndexImpl.close(inputStream);
                throw throwable;
            }
            P2IndexImpl.close(outputStream);
            P2IndexImpl.close(inputStream);
            return;
        }
        outputStream = new FileOutputStream(file);
        P2IndexImpl.copy(inputStream, outputStream);
        ((OutputStream)outputStream).close();
        file.setLastModified(connection.getLastModified());
        P2IndexImpl.close(outputStream);
        P2IndexImpl.close(inputStream);
    }

    public static <K, V> boolean add(Map<K, Set<V>> map, K key, V value) {
        Set<V> set = P2IndexImpl.getSet(map, key);
        return set.add(value);
    }

    public static <K, V> Set<V> getSet(Map<K, Set<V>> map, K key) {
        Set<V> set = map.get(key);
        if (set == null) {
            set = new LinkedHashSet<V>();
            map.put(key, set);
        }
        return set;
    }

    public static void close(Closeable closeable) throws RuntimeException {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Exception closeSilent(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return null;
        }
        catch (Exception ex) {
            return ex;
        }
    }

    public static long copy(InputStream input, OutputStream output) {
        byte[] buffer = new byte[8192];
        try {
            int n;
            long length = 0L;
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
                length += (long)n;
            }
            return length;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static final class RepositoryImpl
    implements P2Index.Repository {
        public static final int UNINITIALIZED = -1;
        private static final P2Index.Repository[] NO_REPOSITORIES = new P2Index.Repository[0];
        private final URI location;
        private final int id;
        private final boolean composed;
        private final boolean compressed;
        private final long timestamp;
        private int capabilityCount;
        private int unresolvedChildren;
        private P2Index.Repository[] children;
        private P2Index.Repository[] composites;

        public RepositoryImpl(BinaryResourceImpl.EObjectInputStream stream, int id, Map<RepositoryImpl, List<Integer>> composedRepositories) throws IOException {
            this.id = id;
            this.location = stream.readURI();
            this.composed = stream.readBoolean();
            this.compressed = stream.readBoolean();
            this.timestamp = stream.readLong();
            this.capabilityCount = this.composed ? -1 : stream.readInt();
            ArrayList<Integer> composites = null;
            while (stream.readBoolean()) {
                if (composites == null) {
                    composites = new ArrayList<Integer>();
                    composedRepositories.put(this, composites);
                }
                int composite = stream.readInt();
                composites.add(composite);
            }
        }

        @Override
        public URI getLocation() {
            return this.location;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public boolean isComposed() {
            return this.composed;
        }

        @Override
        public boolean isCompressed() {
            return this.compressed;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public int getCapabilityCount() {
            if (this.composed && this.capabilityCount == -1) {
                this.capabilityCount = 0;
                for (P2Index.Repository child : this.getChildren()) {
                    this.capabilityCount += child.getCapabilityCount();
                }
            }
            return this.capabilityCount;
        }

        @Override
        public int getUnresolvedChildren() {
            return this.unresolvedChildren;
        }

        @Override
        public P2Index.Repository[] getChildren() {
            if (this.children == null) {
                return NO_REPOSITORIES;
            }
            return this.children;
        }

        @Override
        public P2Index.Repository[] getComposites() {
            if (this.composites == null) {
                return NO_REPOSITORIES;
            }
            return this.composites;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RepositoryImpl other = (RepositoryImpl)obj;
            return this.id == other.id;
        }

        @Override
        public int compareTo(P2Index.Repository o) {
            return this.location.toString().compareTo(o.getLocation().toString());
        }

        public String toString() {
            return this.location.toString();
        }

        public void addChild(P2Index.Repository child) {
            this.children = this.addRepository(this.children, child);
        }

        public void addComposite(P2Index.Repository composite) {
            this.composites = this.addRepository(this.composites, composite);
        }

        private P2Index.Repository[] addRepository(P2Index.Repository[] repositories, P2Index.Repository repository) {
            if (repositories == null) {
                return new P2Index.Repository[]{repository};
            }
            int length = repositories.length;
            P2Index.Repository[] newRepositories = new P2Index.Repository[length + 1];
            System.arraycopy(repositories, 0, newRepositories, 0, length);
            newRepositories[length] = repository;
            return newRepositories;
        }
    }
}

