/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.baseline;

import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Diff;
import aQute.bnd.service.diff.Differ;
import aQute.bnd.service.diff.Tree;
import aQute.bnd.service.diff.Type;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Reporter;
import de.vandermeer.asciitable.AT_Cell;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.function.Function;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.artifactcomparator.ArtifactComparator;
import org.eclipse.tycho.artifactcomparator.ArtifactDelta;
import org.eclipse.tycho.artifactcomparator.ComparatorInputStream;
import org.eclipse.tycho.baseline.ArtifactBaselineComparator;
import org.eclipse.tycho.baseline.BaselineContext;
import org.eclipse.tycho.p2maven.repository.P2RepositoryManager;
import org.eclipse.tycho.zipcomparator.internal.ContentsComparator;
import org.eclipse.tycho.zipcomparator.internal.ManifestComparator;
import org.osgi.framework.BundleException;

@Component(role=ArtifactBaselineComparator.class, hint="eclipse-plugin")
public class BundleArtifactBaselineComparator
implements ArtifactBaselineComparator {
    private static final String X_INTERNAL_ATTRIBUTE = "x-internal";
    private static final String X_FRIENDS_ATTRIBUTE = "x-friends";
    private static final String INDENT = "..";
    private static final int WIDTH = 160;
    @Requirement
    private P2RepositoryManager repositoryManager;
    @Requirement(role=ContentsComparator.class)
    Map<String, ContentsComparator> contentComparators;

    @Override
    public boolean compare(MavenProject project, BaselineContext context) throws Exception {
        byte[] baselineData = this.getBaseline(context);
        if (baselineData == null) {
            return false;
        }
        File artifact = project.getArtifact().getFile();
        if (artifact == null) {
            throw new MojoExecutionException("Artifact is null");
        }
        if (!artifact.exists()) {
            throw new MojoExecutionException("Artifact (" + String.valueOf(artifact) + ") does not exists.");
        }
        try (Processor processor = new Processor();
             Jar projectJar = new Jar(artifact);
             Jar baselineJar = new Jar("baseline", (InputStream)new ByteArrayInputStream(baselineData));){
            Baseline baseliner = this.createBaselineCompare(context, processor);
            Instructions packageFilters = this.getPackageFilters(context, processor, projectJar);
            List<Baseline.Info> infos = baseliner.baseline(projectJar, baselineJar, packageFilters).stream().filter(info -> info.packageDiff.getDelta() != Delta.UNCHANGED).sorted(Comparator.comparing(info -> info.packageName)).toList();
            Baseline.BundleInfo bundleInfo = baseliner.getBundleInfo();
            boolean failed = false;
            LinkedHashMap<Diff, ArtifactDelta> resourcediffs = new LinkedHashMap<Diff, ArtifactDelta>();
            this.collectResources(baseliner.getDiff(), resourcediffs, baselineJar, projectJar, context);
            ArrayList<Diff> manifestdiffs = new ArrayList<Diff>();
            this.collectManifest(baseliner.getDiff(), manifestdiffs);
            this.processManifestDiff(manifestdiffs);
            if (!(infos.isEmpty() && resourcediffs.isEmpty() && manifestdiffs.isEmpty())) {
                AsciiTable at = new AsciiTable();
                at.addRule();
                at.addRow(new Object[]{"Delta", "Type", "Name", "Project Version", "Baseline Version", "Suggested Version"});
                for (Baseline.Info info2 : infos) {
                    Diff packageDiff = info2.packageDiff;
                    this.addDiff(packageDiff, info2, at, 0);
                    failed |= info2.mismatch;
                }
                org.osgi.framework.Version pv = this.getBaseVersion(projectJar.getVersion());
                org.osgi.framework.Version bv = this.getBaseVersion(baselineJar.getVersion());
                aQute.bnd.version.Version sv = new aQute.bnd.version.Version(bv.getMajor(), bv.getMinor(), bv.getMicro() + context.getMicroIncrement());
                if (!manifestdiffs.isEmpty()) {
                    failed |= this.requireVersionBump(bundleInfo, pv, bv, sv);
                    at.addRule();
                    at.addRow(new Object[]{Delta.MICRO, Type.MANIFEST, artifact.getName(), pv, bv, sv});
                    for (Diff diff : manifestdiffs) {
                        String name = diff.getName();
                        at.addRule();
                        at.addRow(new Object[]{INDENT + String.valueOf(this.getResourceDeltaString(diff)), diff.getType(), null, null, null, name});
                    }
                }
                if (!resourcediffs.isEmpty()) {
                    failed |= this.requireVersionBump(bundleInfo, pv, bv, sv);
                    at.addRule();
                    at.addRow(new Object[]{Delta.MICRO, Type.RESOURCES, artifact.getName(), pv, bv, sv});
                    for (Map.Entry entry : resourcediffs.entrySet()) {
                        Diff diff = (Diff)entry.getKey();
                        String name = diff.getName();
                        at.addRule();
                        at.addRow(new Object[]{INDENT + String.valueOf(this.getResourceDeltaString(diff)), this.getResourceTypeString(diff), null, null, null, name});
                        String message = ((ArtifactDelta)entry.getValue()).getDetailedMessage();
                        if (message == null || message.isBlank() || message.equals("different")) continue;
                        at.addRule();
                        at.addRow(new Object[]{null, null, null, null, null, message.replace(System.lineSeparator(), "<br>")}).setTextAlignment(TextAlignment.LEFT);
                    }
                }
                if (failed) {
                    at.addRule();
                    Logger logger = context.getLogger();
                    try {
                        at.renderAsIterator(160).forEachRemaining(arg_0 -> ((Logger)logger).error(arg_0));
                    }
                    catch (RuntimeException runtimeException) {
                        for (AT_Row row : at.getRawContent()) {
                            LinkedList cells = row.getCells();
                            if (cells == null) continue;
                            StringBuilder sb = new StringBuilder();
                            for (AT_Cell cell : cells) {
                                sb.append(cell.getContent());
                                sb.append(" |\t");
                            }
                            logger.error(sb.toString());
                        }
                    }
                }
            }
            if (failed) {
                org.osgi.framework.Version suggestedVersion;
                StringBuilder message = new StringBuilder("Baseline problems found! ");
                message.append("Project version: ");
                message.append(projectJar.getVersion());
                message.append(", baseline version: ");
                message.append(baselineJar.getVersion());
                if (bundleInfo.suggestedVersion != null) {
                    message.append(", suggested version: ");
                    message.append(bundleInfo.suggestedVersion);
                    suggestedVersion = new org.osgi.framework.Version(bundleInfo.suggestedVersion.toString());
                } else {
                    suggestedVersion = null;
                }
                if (bundleInfo.reason != null && !bundleInfo.reason.isBlank()) {
                    message.append(", ");
                    message.append(bundleInfo.reason);
                }
                context.reportBaselineProblem(message.toString(), suggestedVersion);
            }
        }
        return true;
    }

    private void processManifestDiff(List<Diff> manifestdiffs) {
        try {
            Diff capDiff;
            Map capDiffMap;
            Diff breeDiff;
            if (manifestdiffs.size() > 1 && (breeDiff = (Diff)manifestdiffs.stream().filter(diff -> "Bundle-RequiredExecutionEnvironment".equalsIgnoreCase(this.getHeaderName((Diff)diff))).findFirst().orElse(null)) != null && breeDiff.getDelta() == Delta.REMOVED && !(capDiffMap = manifestdiffs.stream().filter(diff -> "Require-Capability".equalsIgnoreCase(this.getHeaderName((Diff)diff))).collect(Collectors.toMap(Diff::getDelta, Function.identity()))).isEmpty() && (capDiff = (Diff)capDiffMap.get(Delta.ADDED)) != null) {
                Diff capDiffPrev;
                if (ManifestComparator.isEquivialentBreeCap((String)this.getOldHeaderValue(breeDiff), (String)this.getNewHeaderValue(capDiff))) {
                    manifestdiffs.remove(capDiff);
                    manifestdiffs.remove(breeDiff);
                }
                if ((capDiffPrev = (Diff)capDiffMap.get(Delta.REMOVED)) != null && ManifestComparator.isEquivialentBreeCap((String)this.getOldHeaderValue(breeDiff), (String)this.getOldHeaderValue(capDiffPrev), (String)this.getNewHeaderValue(capDiff))) {
                    manifestdiffs.remove(capDiff);
                    manifestdiffs.remove(breeDiff);
                    manifestdiffs.remove(capDiffPrev);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private String getNewHeaderValue(Diff diff) {
        String name = diff.getName();
        String[] split = name.split(":", 2);
        return split[1].trim();
    }

    private String getOldHeaderValue(Diff diff) {
        int n = 0;
        Tree older = diff.getOlder();
        Tree[] treeArray = older.getChildren();
        int n2 = treeArray.length;
        if (n < n2) {
            Tree child = treeArray[n];
            return child.getName();
        }
        return this.getNewHeaderValue(diff);
    }

    private boolean requireVersionBump(Baseline.BundleInfo bundleInfo, org.osgi.framework.Version projectVersion, org.osgi.framework.Version baselineVersion, aQute.bnd.version.Version suggestedVersion) {
        if (baselineVersion.compareTo(projectVersion) >= 0) {
            if (bundleInfo.suggestedVersion == null || suggestedVersion.compareTo(bundleInfo.suggestedVersion) > 0) {
                bundleInfo.suggestedVersion = suggestedVersion;
            }
            return true;
        }
        return false;
    }

    private byte[] getBaseline(BaselineContext context) throws IOException {
        ArtifactKey key = context.getArtifactKey();
        org.osgi.framework.Version artifactVersion = org.osgi.framework.Version.parseVersion((String)key.getVersion());
        Version maxVersion = Version.createOSGi((int)artifactVersion.getMajor(), (int)artifactVersion.getMinor(), (int)(artifactVersion.getMicro() + 1));
        IQueryResult result = context.getMetadataRepository().query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)key.getId(), (VersionRange)new VersionRange(Version.emptyVersion, true, maxVersion, false))), null);
        if (result.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.repositoryManager.downloadArtifact((IInstallableUnit)result.iterator().next(), context.getArtifactRepository(), (OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    private Instructions getPackageFilters(BaselineContext context, Processor processor, Jar projectJar) {
        SequencedCollection<String> packages;
        if (context.isExtensionsEnabled()) {
            packages = new LinkedHashSet();
            Map<String, Boolean> projectPackages = this.getPackagesMap(context, projectJar);
            Map<String, Boolean> baselinePackages = this.getPackagesMap(context, projectJar);
            Logger logger = context.getLogger();
            for (Map.Entry<String, Boolean> entry : baselinePackages.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                logger.debug("Ignore package " + entry.getKey() + " as it is marked as internal in the baseline.");
                packages.add("!" + entry.getKey());
            }
            for (Map.Entry<String, Boolean> entry : projectPackages.entrySet()) {
                if (!entry.getValue().booleanValue() || baselinePackages.containsKey(entry.getKey())) continue;
                logger.debug("Ignore package " + entry.getKey() + " as it is marked as internal in the project.");
                packages.add("!" + entry.getKey());
            }
            packages.addAll(context.getPackages());
        } else {
            packages = context.getPackages();
        }
        return new Instructions(new Parameters(Strings.join(packages), (Reporter)processor));
    }

    private Map<String, Boolean> getPackagesMap(BaselineContext context, Jar jar) {
        HashMap<String, Boolean> internalPackages;
        block9: {
            internalPackages = new HashMap<String, Boolean>();
            Logger logger = context.getLogger();
            try {
                Manifest manifest = jar.getManifest();
                if (manifest == null) {
                    return Map.of();
                }
                String exportPackageHeader = manifest.getMainAttributes().getValue("Export-Package");
                if (exportPackageHeader == null) break block9;
                try {
                    ManifestElement[] exports;
                    for (ManifestElement export : exports = ManifestElement.parseHeader((String)"Export-Package", (String)exportPackageHeader)) {
                        boolean internal = export.getDirective(X_FRIENDS_ATTRIBUTE) != null || Boolean.parseBoolean(export.getDirective(X_INTERNAL_ATTRIBUTE));
                        internalPackages.put(export.getValue(), internal);
                    }
                }
                catch (BundleException e) {
                    String message = "Cannot get export package from Manifest, extensions cannot be processed";
                    if (logger.isDebugEnabled()) {
                        logger.error(message, (Throwable)e);
                    } else {
                        logger.warn(message);
                    }
                }
            }
            catch (Exception e) {
                String message = "Cannot get manifest from jar, extensions cannot be processed";
                if (logger.isDebugEnabled()) {
                    logger.error(message, (Throwable)e);
                }
                logger.warn(message);
            }
        }
        return internalPackages;
    }

    private Object getResourceDeltaString(Diff diff) {
        Delta delta = diff.getDelta();
        if (delta == Delta.MAJOR) {
            return "CHANGED";
        }
        return delta.toString();
    }

    private Object getResourceTypeString(Diff diff) {
        Type type = diff.getType();
        String name = diff.getName();
        if (name != null && name.endsWith(".class")) {
            return "CLASS";
        }
        return type;
    }

    private org.osgi.framework.Version getBaseVersion(String version) {
        org.osgi.framework.Version fullVersion = new org.osgi.framework.Version(version);
        return new org.osgi.framework.Version(fullVersion.getMajor(), fullVersion.getMinor(), fullVersion.getMicro());
    }

    private void collectManifest(Diff diff, List<Diff> manifestdiffs) {
        if (diff.getDelta() == Delta.UNCHANGED) {
            return;
        }
        if (this.isValidHeaderDif(diff)) {
            manifestdiffs.add(diff);
        }
        for (Diff child : diff.getChildren()) {
            this.collectManifest(child, manifestdiffs);
        }
    }

    private boolean isValidHeaderDif(Diff diff) {
        return diff.getType() == Type.HEADER && !ManifestComparator.isIgnoredHeaderName((String)this.getHeaderName(diff));
    }

    private String getHeaderName(Diff diff) {
        if (diff == null) {
            return null;
        }
        String name = diff.getName();
        String[] split = name.split(":", 2);
        return split[0];
    }

    private void collectResources(Diff diff, Map<Diff, ArtifactDelta> resourcediffs, Jar baselineJar, Jar projectJar, BaselineContext baselineContext) {
        ArtifactDelta delta;
        if (diff.getDelta() == Delta.UNCHANGED) {
            return;
        }
        if (diff.getType() == Type.RESOURCE && (delta = this.getDelta(diff, baselineJar, projectJar, baselineContext)) != null) {
            resourcediffs.put(diff, delta);
        }
        for (Diff child : diff.getChildren()) {
            this.collectResources(child, resourcediffs, baselineJar, projectJar, baselineContext);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArtifactDelta getDelta(Diff diff, Jar baselineJar, Jar projectJar, BaselineContext baselineContext) {
        String name = diff.getName();
        ContentsComparator comparator = this.getComparator(name);
        if (comparator == null) return ArtifactDelta.DEFAULT;
        Resource baseResource = baselineJar.getResource(name);
        Resource currenttResource = projectJar.getResource(name);
        if (baseResource == null) return ArtifactDelta.DEFAULT;
        if (currenttResource == null) return ArtifactDelta.DEFAULT;
        try (InputStream baseStream = baseResource.openInputStream();
             InputStream currentStream = currenttResource.openInputStream();){
            ComparatorInputStream baseline = new ComparatorInputStream(baseStream);
            ComparatorInputStream reactor = new ComparatorInputStream(currentStream);
            if (baseline.size() >= ContentsComparator.THRESHOLD) return ArtifactDelta.DEFAULT;
            if (reactor.size() >= ContentsComparator.THRESHOLD) return ArtifactDelta.DEFAULT;
            ArtifactDelta artifactDelta = comparator.getDelta(baseline, reactor, new ArtifactComparator.ComparisonData(baselineContext.getIgnores(), false));
            return artifactDelta;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ArtifactDelta.DEFAULT;
    }

    private ContentsComparator getComparator(String name) {
        String extension = FilenameUtils.getExtension((String)name).toLowerCase();
        ContentsComparator comparator = this.contentComparators.get(extension);
        if (comparator == null) {
            for (ContentsComparator alternative : this.contentComparators.values()) {
                if (!alternative.matches(name) && !alternative.matches(extension)) continue;
                return alternative;
            }
            return this.contentComparators.get("default");
        }
        return comparator;
    }

    private void addDiff(Diff diff, Baseline.Info info, AsciiTable at, int indent) {
        Delta delta = diff.getDelta();
        if (delta == Delta.UNCHANGED) {
            return;
        }
        at.addRule();
        String deltaString = INDENT.repeat(indent) + String.valueOf(delta);
        if (info != null) {
            row = new Object[]{deltaString, diff.getType(), diff.getName(), info.newerVersion, info.olderVersion, Objects.requireNonNullElse(info.suggestedVersion, "-")};
            at.addRow(row);
        } else {
            row = new Object[]{deltaString, diff.getType(), null, null, null, diff.getName()};
            at.addRow(row);
        }
        if (diff.getType() == Type.METHOD && delta == Delta.ADDED) {
            return;
        }
        if (diff.getType() == Type.PACKAGE && delta == Delta.REMOVED) {
            return;
        }
        for (Diff child : diff.getChildren()) {
            this.addDiff(child, null, at, indent + 1);
        }
    }

    private Baseline createBaselineCompare(BaselineContext context, Processor processor) throws IOException {
        DiffPluginImpl differ = new DiffPluginImpl();
        differ.setIgnore(new Parameters(Strings.join(context.getIgnores()), (Reporter)processor));
        return new Baseline((Reporter)processor, (Differ)differ);
    }
}

