/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.baseline;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.artifacts.ArtifactVersion;
import org.eclipse.tycho.artifacts.ArtifactVersionProvider;
import org.eclipse.tycho.baseline.analyze.ClassCollection;
import org.eclipse.tycho.baseline.analyze.ClassMethods;
import org.eclipse.tycho.baseline.analyze.ClassUsage;
import org.eclipse.tycho.baseline.analyze.DependencyAnalyzer;
import org.eclipse.tycho.baseline.analyze.JrtClasses;
import org.eclipse.tycho.baseline.analyze.MethodSignature;
import org.eclipse.tycho.core.MarkdownBuilder;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.maven.OSGiJavaToolchain;
import org.eclipse.tycho.core.maven.ToolchainProvider;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.resolver.target.ArtifactMatcher;
import org.eclipse.tycho.model.manifest.MutableBundleManifest;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.VersionRange;

@Mojo(defaultPhase=LifecyclePhase.VERIFY, name="check-dependencies", threadSafe=true, requiresProject=true)
public class DependencyCheckMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.build.directory}/versionProblems.md", property="tycho.dependency.check.report")
    private File reportFileName;
    @Parameter(defaultValue="${project.basedir}/META-INF/MANIFEST.MF", property="tycho.dependency.check.manifest")
    private File manifestFile;
    @Parameter(defaultValue="false", property="tycho.dependency.check.apply")
    private boolean applySuggestions;
    @Parameter(property="tycho.dependency.check.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="tycho.dependency.check.verbose", defaultValue="false")
    private boolean verbose;
    @Component
    private TychoProjectManager projectManager;
    @Component
    private List<ArtifactVersionProvider> versionProvider;
    @Component
    private BundleReader bundleReader;
    @Component
    ToolchainProvider toolchainProvider;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (!"jar".equals(this.project.getPackaging()) && !"eclipse-plugin".equals(this.project.getPackaging())) {
            return;
        }
        DependencyArtifacts artifacts = this.projectManager.getDependencyArtifacts(this.project).orElse(null);
        File file = this.project.getArtifact().getFile();
        if (file == null || !file.isFile()) {
            throw new MojoFailureException("Project artifact is not a valid file");
        }
        JrtClasses jrtClassResolver = this.getJRTClassResolver();
        List<ClassUsage> usages = DependencyAnalyzer.analyzeUsage(file, jrtClassResolver);
        if (usages.isEmpty()) {
            return;
        }
        Collection units = artifacts.getInstallableUnits();
        ModuleRevisionBuilder builder = this.readOSGiInfo(file);
        List requirements = builder.getRequirements();
        ArrayList<DependencyVersionProblem> dependencyProblems = new ArrayList<DependencyVersionProblem>();
        HashMap<Path, ClassCollection> analyzeCache = new HashMap<Path, ClassCollection>();
        Log log = this.getLog();
        HashMap<String, org.osgi.framework.Version> lowestPackageVersion = new HashMap<String, org.osgi.framework.Version>();
        HashMap<String, Set> allPackageVersion = new HashMap<String, Set>();
        HashSet<String> packageWithError = new HashSet<String>();
        DependencyAnalyzer dependencyAnalyzer = new DependencyAnalyzer((m, e) -> this.getLog().error((CharSequence)m, e));
        Function<String, Optional<ClassMethods>> classResolver = dependencyAnalyzer.createDependencyClassResolver(jrtClassResolver, artifacts);
        for (ModuleRevisionBuilder.GenericInfo genericInfo : requirements) {
            if (!"osgi.wiring.package".equals(genericInfo.getNamespace())) continue;
            Map<String, String> pkgInfo = this.getVersionInfo(genericInfo, "version");
            String packageVersion = pkgInfo.getOrDefault("version", "0.0.0");
            String packageName = pkgInfo.get("osgi.wiring.package");
            Optional packageProvidingUnit = ArtifactMatcher.findPackage((String)packageName, (Collection)units);
            if (packageProvidingUnit.isEmpty()) continue;
            IInstallableUnit unit = (IInstallableUnit)packageProvidingUnit.get();
            Optional matchedPackageVersion = ArtifactMatcher.getPackageVersion((IInstallableUnit)unit, (String)packageName);
            if (matchedPackageVersion.isEmpty() || ((Version)matchedPackageVersion.get()).equals(Version.emptyVersion)) {
                log.warn((CharSequence)("Package " + packageName + " has no version exported and can not be checked for compatibility"));
                continue;
            }
            matchedPackageVersion.filter(v -> v.isOSGiCompatible()).ifPresent(v -> {
                org.osgi.framework.Version current = new org.osgi.framework.Version(v.toString());
                allPackageVersion.computeIfAbsent(packageName, nil -> new TreeSet()).add(current);
                lowestPackageVersion.put(packageName, current);
            });
            VersionRange versionRange = VersionRange.valueOf((String)packageVersion);
            List list = this.versionProvider.stream().flatMap(avp -> avp.getPackageVersions(unit, packageName, versionRange, this.project)).toList();
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("== " + packageName + " " + packageVersion + " is provided by " + String.valueOf(unit) + " with version range " + String.valueOf(versionRange) + ", matching versions: " + list.stream().map(av -> av.getVersion()).map(String::valueOf).collect(Collectors.joining(", "))));
            }
            TreeSet packageMethods = new TreeSet();
            HashMap references = new HashMap();
            for (ClassUsage usage : usages) {
                usage.signatures().filter(ms -> packageName.equals(ms.packageName())).forEach(sig -> {
                    packageMethods.add(sig);
                    references.computeIfAbsent(sig, nil -> new TreeSet()).addAll(usage.classRef((MethodSignature)sig));
                });
            }
            if (packageMethods.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                for (MethodSignature signature : packageMethods) {
                    log.debug((CharSequence)("Referenced: " + signature.id()));
                }
            }
            for (ArtifactVersion v3 : list) {
                org.osgi.framework.Version version = v3.getVersion();
                if (version == null || !allPackageVersion.computeIfAbsent(packageName, nil -> new TreeSet()).add(version)) continue;
                Path artifact = v3.getArtifact();
                log.debug((CharSequence)(String.valueOf(v3) + "=" + String.valueOf(artifact)));
                if (artifact == null) continue;
                ClassCollection collection = (ClassCollection)analyzeCache.get(artifact);
                if (collection == null) {
                    collection = dependencyAnalyzer.analyzeProvides(artifact.toFile(), classResolver);
                    analyzeCache.put(artifact, collection);
                }
                boolean ok = true;
                Set set = collection.provides().collect(Collectors.toSet());
                for (MethodSignature mthd : packageMethods) {
                    if (set.contains(mthd)) continue;
                    List<MethodSignature> provided = collection.get(mthd.className());
                    if (provided != null) {
                        provided = provided.stream().filter(ms -> packageName.equals(ms.packageName())).toList();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Not found: " + String.valueOf(mthd)));
                        if (provided != null) {
                            for (MethodSignature s : provided) {
                                log.debug((CharSequence)("Provided:  " + String.valueOf(s)));
                            }
                        }
                    }
                    dependencyProblems.add(new DependencyVersionProblem(packageName + "_" + String.valueOf(version), String.format("Import-Package `%s %s` (compiled against `%s` provided by `%s %s`) includes `%s` (provided by `%s`) but this version is missing the method `%s#%s`", packageName, packageVersion, matchedPackageVersion.orElse(Version.emptyVersion).toString(), unit.getId(), unit.getVersion(), version, v3.getProvider(), mthd.className(), this.getMethodRef(mthd)), (Collection)references.get(mthd), provided));
                    ok = false;
                    packageWithError.add(packageName);
                }
                if (!ok) continue;
                lowestPackageVersion.merge(packageName, version, (v1, v2) -> {
                    if (v1.compareTo(v2) > 0) {
                        return v2;
                    }
                    return v1;
                });
            }
        }
        if (dependencyProblems.isEmpty()) {
            return;
        }
        if (this.applySuggestions) {
            this.applyLowerBounds(packageWithError, lowestPackageVersion);
        }
        MarkdownBuilder results = new MarkdownBuilder(this.reportFileName);
        HashSet<String> keys = new HashSet<String>();
        for (DependencyVersionProblem problem : dependencyProblems) {
            List<MethodSignature> provided;
            String message;
            if (!this.verbose && !keys.add(problem.key())) continue;
            Collection<String> references = problem.references();
            if (references == null || references.isEmpty()) {
                message = problem.message();
            } else if (this.verbose) {
                String delimiter = System.lineSeparator() + "- ";
                message = String.format("%s referenced by:%s%s ", problem.message(), delimiter, problem.references().stream().collect(Collectors.joining(delimiter)));
            } else {
                int size = references.size();
                message = size == 1 ? String.format("%s referenced by `%s`.", problem.message(), references.iterator().next()) : String.format("%s referenced by `%s` and %d other.", problem.message(), references.iterator().next(), size - 1);
            }
            log.error((CharSequence)message);
            results.add(message);
            if (this.verbose && (provided = problem.provided()) != null && !provided.isEmpty()) {
                results.add("Provided Methods in this version are:");
                for (MethodSignature sig2 : provided) {
                    results.add("\t" + sig2.id());
                }
            }
            results.add("");
        }
        if (!packageWithError.isEmpty()) {
            results.add("");
            for (String pkg : packageWithError) {
                Object suggestion = String.format("Suggested lower version for package `%s` is `%s`", pkg, lowestPackageVersion.get(pkg));
                Set all = (Set)allPackageVersion.get(pkg);
                if (all != null && !all.isEmpty()) {
                    suggestion = (String)suggestion + " out of " + all.stream().map(v -> String.format("`%s`", v)).collect(Collectors.joining(", ", "[", "]"));
                }
                log.info((CharSequence)suggestion);
                results.add((String)suggestion);
            }
        }
        results.write();
    }

    private String getMethodRef(MethodSignature mthd) {
        if (this.verbose) {
            return String.format("%s %s", mthd.methodName(), mthd.signature());
        }
        return mthd.methodName();
    }

    private void applyLowerBounds(Set<String> packageWithError, Map<String, org.osgi.framework.Version> lowestPackageVersion) throws MojoFailureException {
        if (packageWithError.isEmpty()) {
            return;
        }
        try {
            MutableBundleManifest manifest = MutableBundleManifest.read((File)this.manifestFile);
            Map exportedPackagesVersion = manifest.getExportedPackagesVersion();
            HashMap<String, String> updates = new HashMap<String, String>();
            for (String packageName : packageWithError) {
                org.osgi.framework.Version lowestVersion = lowestPackageVersion.getOrDefault(packageName, org.osgi.framework.Version.emptyVersion);
                String current = (String)exportedPackagesVersion.get(packageName);
                if (current == null) {
                    updates.put(packageName, String.format("[%s,%d)", lowestVersion, lowestVersion.getMajor() + 1));
                    continue;
                }
                VersionRange range = VersionRange.valueOf((String)current);
                org.osgi.framework.Version right = range.getRight();
                updates.put(packageName, String.format("[%s,%s%c", lowestVersion, right, Character.valueOf(range.getRightType())));
            }
            manifest.updateImportedPackageVersions(updates);
            MutableBundleManifest.write((MutableBundleManifest)manifest, (File)this.manifestFile);
        }
        catch (IOException e) {
            throw new MojoFailureException((Throwable)e);
        }
    }

    private Map<String, String> getVersionInfo(ModuleRevisionBuilder.GenericInfo genericInfo, String versionAttribute) {
        FilterImpl filterImpl;
        HashMap directives = new HashMap(genericInfo.getDirectives());
        String filter = (String)directives.remove("filter");
        try {
            filterImpl = FilterImpl.newInstance((String)filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter directive", e);
        }
        return filterImpl.getStandardOSGiAttributes(new String[]{versionAttribute});
    }

    private ModuleRevisionBuilder readOSGiInfo(File file) throws MojoFailureException {
        ModuleRevisionBuilder builder;
        OsgiManifest manifest = this.bundleReader.loadManifest(file);
        try {
            builder = OSGiManifestBuilderFactory.createBuilder((Map)manifest.getHeaders());
        }
        catch (BundleException e) {
            throw new MojoFailureException((Throwable)e);
        }
        return builder;
    }

    private JrtClasses getJRTClassResolver() {
        OSGiJavaToolchain osgiToolchain;
        String profileName = this.projectManager.getExecutionEnvironments(this.project, this.session).findFirst().map(ee -> ee.getProfileName()).orElse(null);
        if (profileName != null && (osgiToolchain = (OSGiJavaToolchain)this.toolchainProvider.getToolchain(profileName).orElse(null)) != null) {
            return new JrtClasses(osgiToolchain.getJavaHome());
        }
        return new JrtClasses(null);
    }

    private record DependencyVersionProblem(String key, String message, Collection<String> references, List<MethodSignature> provided) {
    }
}

