/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.baseline.analyze;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.tycho.baseline.analyze.ClassMethods;
import org.eclipse.tycho.baseline.analyze.MethodSignature;

public class ClassCollection
implements Function<String, Optional<ClassMethods>>,
Consumer<ClassMethods> {
    private Map<String, ClassMethods> classLookupMap = new HashMap<String, ClassMethods>();

    @Override
    public Optional<ClassMethods> apply(String className) {
        return Optional.ofNullable(this.classLookupMap.get(className));
    }

    public Stream<MethodSignature> provides() {
        return this.classLookupMap.values().stream().distinct().flatMap(cm -> cm.provides());
    }

    public List<MethodSignature> get(String className) {
        return this.apply(className).stream().flatMap(cm -> cm.provides()).toList();
    }

    public Function<String, Optional<ClassMethods>> chain(Function<String, Optional<ClassMethods>> chained) {
        return cls -> this.apply((String)cls).or(() -> (Optional)chained.apply((String)cls));
    }

    @Override
    public void accept(ClassMethods methods) {
        methods.definitions().forEach(def -> this.classLookupMap.put(def.name(), methods));
    }
}

