/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.baseline.analyze;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.tycho.baseline.analyze.ClassDef;
import org.eclipse.tycho.baseline.analyze.ClassMethodSignature;
import org.eclipse.tycho.baseline.analyze.MethodSignature;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassMethods {
    private List<ClassDef> classDefs = new ArrayList<ClassDef>();
    private List<ClassMethodSignature> signatures = new ArrayList<ClassMethodSignature>();
    private Function<String, Optional<ClassMethods>> supplier;
    private Set<MethodSignature> collect;

    public ClassMethods(byte[] classbytes, Function<String, Optional<ClassMethods>> supplier) {
        this.supplier = supplier;
        ClassReader reader = new ClassReader(classbytes);
        reader.accept(new ClassVisitor(589824){
            private ClassDef classDef;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if ((access & 2) != 0) {
                    return;
                }
                this.classDef = new ClassDef(access, name, signature, superName, interfaces);
                ClassMethods.this.classDefs.add(this.classDef);
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                ClassMethods.this.signatures.add(new ClassMethodSignature(this.classDef, access, name, descriptor, signature));
                return null;
            }
        }, 4);
    }

    Stream<ClassDef> definitions() {
        return this.classDefs.stream();
    }

    Stream<MethodSignature> provides() {
        Stream<MethodSignature> declared = this.signatures.stream().map(cms -> new MethodSignature(cms.clazz().name(), cms.name(), cms.descriptor()));
        Stream supermethods = this.classDefs.stream().flatMap(cd -> Optional.ofNullable(cd.superName()).flatMap(cn -> this.findRef((String)cn)).stream().flatMap(cm -> cm.provides()).filter(ms -> !ms.isContructor()).map(ms -> this.inherit((ClassDef)cd, (MethodSignature)ms)));
        Stream interfaces = this.classDefs.stream().flatMap(cd -> Optional.ofNullable(cd.interfaces()).stream().flatMap(Arrays::stream).flatMap(cn -> this.findRef((String)cn).stream()).flatMap(cm -> cm.provides()).filter(ms -> !ms.isContructor()).map(ms -> this.inherit((ClassDef)cd, (MethodSignature)ms)));
        Stream inherited = Stream.concat(supermethods, interfaces);
        return Stream.concat(declared, inherited).distinct();
    }

    private MethodSignature inherit(ClassDef cd, MethodSignature ms) {
        return new MethodSignature(cd.name(), ms.methodName(), ms.signature());
    }

    private Optional<ClassMethods> findRef(String cn) {
        return this.supplier.apply(cn);
    }
}

