/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.baseline.analyze;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.baseline.analyze.ClassCollection;
import org.eclipse.tycho.baseline.analyze.ClassMethods;
import org.eclipse.tycho.baseline.analyze.ClassUsage;
import org.eclipse.tycho.baseline.analyze.JrtClasses;

public class DependencyAnalyzer {
    static final String CLASS_SUFFIX = ".class";
    static final int ASM_API = 589824;
    private BiConsumer<String, Throwable> errorConsumer;

    public DependencyAnalyzer(BiConsumer<String, Throwable> errorConsumer) {
        this.errorConsumer = errorConsumer;
    }

    public static String getPackageName(String className) {
        int idx = (className = className.replace('/', '.')).lastIndexOf(46);
        if (idx > 0) {
            return className.substring(0, idx);
        }
        return className;
    }

    public Function<String, Optional<ClassMethods>> createDependencyClassResolver(JrtClasses jrtClassResolver, DependencyArtifacts artifacts) throws MojoFailureException {
        ClassCollection allClassMethods = new ClassCollection();
        Function<String, Optional<ClassMethods>> function = allClassMethods.chain(jrtClassResolver);
        List list = artifacts.getArtifacts("eclipse-plugin");
        for (ArtifactDescriptor descriptor : list) {
            File file = (File)descriptor.fetchArtifact().join();
            this.analyzeProvides(file, function, allClassMethods);
        }
        return function;
    }

    public static List<ClassUsage> analyzeUsage(File file, JrtClasses jre) throws MojoFailureException {
        ArrayList<ClassUsage> usages = new ArrayList<ClassUsage>();
        try {
            try (JarFile jar = new JarFile(file);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    String name = jarEntry.getName();
                    if (!name.endsWith(CLASS_SUFFIX)) continue;
                    InputStream stream = jar.getInputStream(jarEntry);
                    usages.add(new ClassUsage(stream.readAllBytes(), jre));
                }
            }
            return usages;
        }
        catch (IOException e) {
            throw new MojoFailureException((Throwable)e);
        }
    }

    public ClassCollection analyzeProvides(File file, Function<String, Optional<ClassMethods>> classResolver) throws MojoFailureException {
        return this.analyzeProvides(file, classResolver, null);
    }

    public ClassCollection analyzeProvides(File file, Function<String, Optional<ClassMethods>> classResolver, Consumer<ClassMethods> consumer) throws MojoFailureException {
        try {
            ClassCollection local = new ClassCollection();
            Function<String, Optional<ClassMethods>> resolver = local.chain(classResolver);
            try (JarFile jar = new JarFile(file);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    ClassMethods methods;
                    JarEntry jarEntry = entries.nextElement();
                    String name = jarEntry.getName();
                    if (!name.endsWith(CLASS_SUFFIX)) continue;
                    InputStream stream = jar.getInputStream(jarEntry);
                    try {
                        methods = new ClassMethods(stream.readAllBytes(), resolver);
                    }
                    catch (RuntimeException e) {
                        this.errorConsumer.accept("Can't analyze class '" + name + "' because of error while parsing", e);
                        continue;
                    }
                    if (consumer != null) {
                        consumer.accept(methods);
                    }
                    local.accept(methods);
                }
            }
            return local;
        }
        catch (IOException e) {
            throw new MojoFailureException((Throwable)e);
        }
    }
}

