/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.baseline.provider;

import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.SessionScoped;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.tycho.artifacts.ArtifactVersion;
import org.eclipse.tycho.artifacts.ArtifactVersionProvider;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

@Named
@SessionScoped
public class MavenArtifactVersionProvider
implements ArtifactVersionProvider {
    private MavenSession session;
    private RepositorySystem repoSystem;
    private BundleReader bundleReader;

    @Inject
    public MavenArtifactVersionProvider(MavenSession session, RepositorySystem repoSystem, BundleReader bundleReader) {
        this.session = session;
        this.repoSystem = repoSystem;
        this.bundleReader = bundleReader;
    }

    public Stream<ArtifactVersion> getPackageVersions(IInstallableUnit unit, String packageName, VersionRange versionRange, MavenProject mavenProject) {
        String groupId = unit.getProperty("maven-groupId");
        String artifactId = unit.getProperty("maven-artifactId");
        String classifier = unit.getProperty("maven-classifier");
        if (groupId != null && artifactId != null && !"sources".equals(classifier)) {
            List repositories = RepositoryUtils.toRepos((List)mavenProject.getRemoteArtifactRepositories());
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, "jar", "[0,)");
            VersionRangeRequest rangeRequest = new VersionRangeRequest((Artifact)artifact, repositories, "");
            try {
                VersionRangeResult range = this.repoSystem.resolveVersionRange(this.session.getRepositorySession(), rangeRequest);
                List versions = range.getVersions().stream().sorted(Comparator.naturalOrder().reversed()).toList();
                return versions.stream().map(v -> new MavenPackageArtifactVersion((Artifact)artifact, (org.eclipse.aether.version.Version)v, packageName, repositories)).filter(mav -> mav.getVersion() != null).dropWhile(mav -> !versionRange.includes(mav.getVersion())).takeWhile(mav -> versionRange.includes(mav.getVersion())).map(ArtifactVersion.class::cast);
            }
            catch (VersionRangeResolutionException versionRangeResolutionException) {
                // empty catch block
            }
        }
        return Stream.empty();
    }

    private ModuleRevisionBuilder readOSGiInfo(Path path) {
        if (path != null) {
            try {
                OsgiManifest manifest = this.bundleReader.loadManifest(path.toFile());
                return OSGiManifestBuilderFactory.createBuilder((Map)manifest.getHeaders());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private class MavenPackageArtifactVersion
    implements ArtifactVersion {
        private Artifact artifact;
        private List<RemoteRepository> repositories;
        private Path path;
        private String packageName;
        private Version packageVersion;

        public MavenPackageArtifactVersion(Artifact artifact, org.eclipse.aether.version.Version version, String packageName, List<RemoteRepository> repositories) {
            this.artifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), version.toString());
            this.packageName = packageName;
            this.repositories = repositories;
        }

        public Path getArtifact() {
            try {
                ArtifactRequest request = new ArtifactRequest(this.artifact, this.repositories, "");
                ArtifactResult result = MavenArtifactVersionProvider.this.repoSystem.resolveArtifact(MavenArtifactVersionProvider.this.session.getRepositorySession(), request);
                this.path = result.getArtifact().getFile().toPath();
            }
            catch (ArtifactResolutionException artifactResolutionException) {
                // empty catch block
            }
            return this.path;
        }

        public Version getVersion() {
            ModuleRevisionBuilder builder;
            if (this.packageVersion == null && (builder = MavenArtifactVersionProvider.this.readOSGiInfo(this.getArtifact())) != null) {
                List capabilities = builder.getCapabilities("osgi.wiring.package");
                for (ModuleRevisionBuilder.GenericInfo info : capabilities) {
                    Map attributes = info.getAttributes();
                    if (!this.packageName.equals(attributes.get("osgi.wiring.package"))) continue;
                    this.packageVersion = attributes.getOrDefault("version", Version.emptyVersion);
                }
            }
            return this.packageVersion;
        }

        public String toString() {
            return String.valueOf(this.getVersion()) + " (maven artifact " + String.valueOf(this.artifact) + ")";
        }

        public String getProvider() {
            ModuleRevisionBuilder info = MavenArtifactVersionProvider.this.readOSGiInfo(this.getArtifact());
            if (info != null) {
                return info.getSymbolicName() + " " + String.valueOf(info.getVersion());
            }
            return null;
        }
    }
}

