/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.baseline;

import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.baseline.ArtifactBaselineComparator;
import org.eclipse.tycho.baseline.BaselineContext;
import org.eclipse.tycho.baseline.BaselineMode;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.exceptions.VersionBumpRequiredException;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.OsgiManifestParserException;
import org.eclipse.tycho.p2maven.repository.P2RepositoryManager;
import org.osgi.framework.Version;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(defaultPhase=LifecyclePhase.VERIFY, name="verify", threadSafe=true)
public class BaselineMojo
extends AbstractMojo
implements BaselineContext {
    @Parameter(property="baselines", name="baselines")
    private List<Repository> baselines;
    @Component
    private P2RepositoryManager repositoryManager;
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Parameter(property="tycho.baseline.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="tycho.baseline.mode", defaultValue="evolve")
    private BaselineMode mode = BaselineMode.evolve;
    @Parameter(property="tycho.baseline.packages")
    private List<String> packages;
    @Parameter(property="tycho.baseline.diffignores")
    private List<String> ignores;
    @Parameter(property="tycho.baseline.extensions", defaultValue="false")
    private boolean extensions;
    @Parameter(property="tycho.baseline.increment", defaultValue="1")
    private int increment = 1;
    @Component
    protected TychoProjectManager projectManager;
    @Component
    private Logger logger;
    @Component
    private Map<String, ArtifactBaselineComparator> comparators;
    @Component
    BuildContext buildContext;
    @Component
    private BundleReader bundleReader;
    private ThreadLocal<IArtifactRepository> contextArtifactRepository = new ThreadLocal();
    private ThreadLocal<IQueryable<IInstallableUnit>> contextMetadataRepository = new ThreadLocal();
    private ThreadLocal<ArtifactKey> contexArtifactKey = new ThreadLocal();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.buildContext.removeMessages(this.project.getBasedir());
        if (this.skip || this.baselines == null || this.baselines.isEmpty()) {
            this.logger.info("Skipped.");
            return;
        }
        Optional<ArtifactKey> artifactKeyLookup = this.lookupArtifactKey();
        if (artifactKeyLookup.isEmpty()) {
            this.logger.info("Not an artifact based project.");
            return;
        }
        ArtifactKey artifactKey = artifactKeyLookup.get();
        ArtifactBaselineComparator comparator = this.comparators.get(artifactKey.getType());
        if (comparator == null) {
            this.logger.info("Not a baseline comparable project.");
            return;
        }
        try {
            this.loadRepositories();
            this.contexArtifactKey.set(artifactKey);
            if (comparator.compare(this.project, this)) {
                this.logger.info("No baseline problems found.");
                return;
            }
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unknown error", e);
        }
        finally {
            this.contextArtifactRepository.set(null);
            this.contextMetadataRepository.set(null);
            this.contexArtifactKey.set(null);
        }
        String message = "No baseline artifact found!";
        if (this.mode == BaselineMode.evolve) {
            this.logger.info(message);
            return;
        }
        this.reportBaselineProblem(message);
    }

    private Optional<ArtifactKey> lookupArtifactKey() {
        File file;
        Artifact artifact;
        Optional key = this.projectManager.getArtifactKey(this.project);
        if (key.isEmpty() && ("jar".equalsIgnoreCase(this.project.getPackaging()) || "bundle".equalsIgnoreCase(this.project.getPackaging())) && (artifact = this.project.getArtifact()) != null && (file = artifact.getFile()) != null && file.isFile()) {
            try {
                OsgiManifest manifest = this.bundleReader.loadManifest(file);
                return Optional.of(manifest.toArtifactKey());
            }
            catch (OsgiManifestParserException osgiManifestParserException) {
                // empty catch block
            }
        }
        return key;
    }

    private void loadRepositories() throws MojoExecutionException {
        try {
            this.contextMetadataRepository.set((IQueryable<IInstallableUnit>)this.repositoryManager.getCompositeMetadataRepository(this.baselines));
            this.contextArtifactRepository.set(this.repositoryManager.getCompositeArtifactRepository(this.baselines));
        }
        catch (URISyntaxException | ProvisionException e) {
            throw new MojoExecutionException("Loading baseline repositories " + this.baselines.stream().map(r -> r.getUrl()).collect(Collectors.joining(", ")) + " failed!", (Exception)e);
        }
    }

    @Override
    public void reportBaselineProblem(String message) throws MojoFailureException {
        this.reportBaselineProblem(message, null);
    }

    @Override
    public void reportBaselineProblem(String message, Version suggestedVersion) throws MojoFailureException {
        if (this.mode != BaselineMode.warn) {
            this.buildContext.addMessage(this.project.getBasedir(), 0, 0, message, 2, null);
            if (suggestedVersion != null) {
                throw new VersionBumpRequiredException(message, this.project, suggestedVersion);
            }
            throw new MojoFailureException(message);
        }
        this.buildContext.addMessage(this.project.getBasedir(), 0, 0, message, 1, null);
        this.logger.warn(message);
    }

    @Override
    public List<String> getIgnores() {
        if (this.ignores == null) {
            return List.of();
        }
        return this.ignores;
    }

    @Override
    public List<String> getPackages() {
        if (this.packages == null) {
            return List.of("*");
        }
        return this.packages;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isExtensionsEnabled() {
        return this.extensions;
    }

    @Override
    public int getMicroIncrement() {
        return this.increment;
    }

    @Override
    public IArtifactRepository getArtifactRepository() {
        return this.contextArtifactRepository.get();
    }

    @Override
    public IQueryable<IInstallableUnit> getMetadataRepository() {
        return this.contextMetadataRepository.get();
    }

    @Override
    public ArtifactKey getArtifactKey() {
        return this.contexArtifactKey.get();
    }
}

