/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd.mojos;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.JarResource;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.service.reporter.Report;
import biz.aQute.resolve.Bndrun;
import biz.aQute.resolve.ResolveProcess;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.tycho.bnd.BndRunFile;
import org.eclipse.tycho.bnd.mojos.AbstractBndMojo;
import org.osgi.service.resolver.ResolutionException;

@Mojo(name="run", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class BndRunMojo
extends AbstractBndMojo {
    public static final String NAME = "run";
    public static final String BNDRUN_EXPORTS_NAME = "exports";
    public static final String BNDRUN_EXPORTS_PROPERTY = "bndrun.exports";
    public static final String BNDRUN = ".bndrun";
    @Parameter(name="exports", property="bndrun.exports")
    private Set<String> exports;
    @Parameter
    private Map<String, String> options;
    @Parameter(property="bndrun.exporter", defaultValue="bnd.executablejar")
    private String exporter;
    @Parameter(property="bndrun.attatch", defaultValue="true")
    private boolean attatch;
    @Parameter(property="bndrun.resolve", defaultValue="false")
    private boolean resolve;
    @Component
    MavenProjectHelper helper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.exports == null || this.exports.isEmpty()) {
            return;
        }
        List<BndRunFile> bndRuns = BndRunMojo.getBndRuns(this.mavenProject.getBasedir().toPath(), this.exports);
        if (bndRuns.isEmpty()) {
            return;
        }
        Workspace workspace = this.getWorkspace();
        this.checkResult((Report)workspace, workspace.isFailOk());
        for (BndRunFile bndRunFile : bndRuns) {
            this.getLog().info((CharSequence)String.format("Exporting %s ...", bndRunFile.name()));
            try {
                Bndrun run = this.getBndRun(workspace, bndRunFile);
                try {
                    Path export;
                    if (this.resolve) {
                        try {
                            this.getLog().info((CharSequence)String.format("Resolve %s...", bndRunFile.name()));
                            this.resolveRun(run);
                        }
                        catch (ResolutionException e) {
                            String msg = ResolveProcess.format((ResolutionException)e, (boolean)false);
                            this.getLog().error((CharSequence)msg);
                            throw new MojoFailureException("resolve bnd run failed: " + msg, (Throwable)e);
                        }
                    }
                    if ((export = this.export(run, bndRunFile)) == null) continue;
                    this.getLog().info((CharSequence)String.format("Exported to %s", export));
                    if (!this.attatch || !Files.isRegularFile(export, new LinkOption[0])) continue;
                    this.helper.attachArtifact(this.mavenProject, "jar", bndRunFile.name(), export.toFile());
                }
                finally {
                    if (run == null) continue;
                    run.close();
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"failed to close Bndrun", (Throwable)e);
            }
        }
    }

    private void resolveRun(Bndrun run) throws ResolutionException, MojoFailureException {
        try {
            String runBundles = run.resolve(false, false);
            if (runBundles != null && run.isOk()) {
                run.setProperty("-runbundles", runBundles);
                Collection collection = run.getRunbundles();
                if (collection.size() > 0) {
                    String collect = collection.stream().map(cont -> cont.getBundleSymbolicName() + " " + cont.getVersion()).collect(Collectors.joining(System.lineSeparator() + "\t"));
                    this.getLog().info((CharSequence)String.format("%s:%s\t%s", "-runbundles", System.lineSeparator(), collect));
                }
            }
        }
        catch (ResolutionException re) {
            throw re;
        }
        catch (Exception e) {
            throw new MojoFailureException("Error resolving bnd run", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path export(Bndrun run, BndRunFile bndRunFile) throws MojoFailureException {
        try {
            Map.Entry result = run.export(this.exporter, this.options);
            try (Resource export = (Resource)result.getValue();){
                Path exportBasePath = Path.of(this.mavenProject.getBuild().getDirectory(), new String[0]).resolve(this.getOutputFolder());
                Files.createDirectories(exportBasePath, new FileAttribute[0]);
                if (this.exporter.equals("bnd.runbundles")) {
                    if (export instanceof JarResource) {
                        JarResource jar = (JarResource)export;
                        Path exportPath = exportBasePath.resolve(bndRunFile.name());
                        Files.createDirectories(exportPath, new FileAttribute[0]);
                        jar.getJar().writeFolder(exportPath.toFile());
                        Path path = exportPath;
                        return path;
                    }
                    Path jar = null;
                    return jar;
                }
                Path exportPath = exportBasePath.resolve((String)result.getKey());
                export.write(exportPath);
                Files.setLastModifiedTime(exportPath, FileTime.fromMillis(export.lastModified()));
                Path path = exportPath;
                return path;
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("error exporting bnd run!", (Throwable)e);
        }
    }

    private String getOutputFolder() {
        if (this.exporter.equals("bnd.runbundles")) {
            return "runbundles";
        }
        if (this.exporter.equals("bnd.executablejar")) {
            return "executable";
        }
        return "export";
    }

    private Bndrun getBndRun(Workspace workspace, BndRunFile run) throws MojoFailureException {
        Bndrun bndRun;
        try {
            bndRun = Bndrun.createBndrun((Workspace)workspace, (File)run.path().toFile());
            Project project = workspace.getProject(this.mavenProject.getBasedir().getName());
            if (project != null) {
                bndRun.setParent((Processor)project);
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("error creating bnd run!", (Throwable)e);
        }
        this.checkResult((Report)bndRun, workspace.isFailOk());
        return bndRun;
    }

    public static List<BndRunFile> getBndRuns(Path path, Collection<String> match) throws MojoExecutionException {
        ArrayList<BndRunFile> bndRuns = new ArrayList<BndRunFile>();
        try {
            Iterator iterator = Files.list(path).iterator();
            while (iterator.hasNext()) {
                String key;
                Path child = (Path)iterator.next();
                String fn = child.getFileName().toString();
                if (!fn.endsWith(BNDRUN) || !match.contains(key = fn.substring(0, fn.length() - BNDRUN.length()))) continue;
                bndRuns.add(new BndRunFile(key, child));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        return bndRuns;
    }
}

