/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd.mojos;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.tycho.bnd.mojos.AbstractBndMojo;

@Mojo(name="initialize", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class BndInitMojo
extends AbstractBndMojo {
    @Parameter(defaultValue=".tycho-consumer-pom.xml", property="tycho.bnd.consumerpom.file")
    protected String tychoPomFilename;
    @Parameter(defaultValue="true", property="tycho.bnd.consumerpom.delete")
    protected boolean deleteOnExit = true;
    @Parameter(defaultValue="true", property="tycho.bnd.consumerpom.update")
    protected boolean updatePomFile = true;
    @Parameter(defaultValue="false", property="tycho.bnd.consumerpom.skip")
    protected boolean skipPomGeneration;
    @Parameter(defaultValue="${project.basedir}", property="tycho.bnd.consumerpom.directory")
    protected File outputDirectory;
    @Component(role=ModelWriter.class)
    protected ModelWriter modelWriter;
    @Component(role=ModelReader.class)
    protected ModelReader modelReader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.fixupPolyglot();
        this.writeConsumerPom();
    }

    private void writeConsumerPom() throws MojoExecutionException {
        Model projectModel;
        if (this.skipPomGeneration) {
            return;
        }
        try {
            projectModel = this.modelReader.read(this.mavenProject.getFile(), Map.of());
        }
        catch (IOException e) {
            throw new MojoExecutionException("reading the model failed!", (Exception)e);
        }
        projectModel.setBuild(null);
        projectModel.setVersion(this.mavenProject.getVersion());
        projectModel.setGroupId(this.mavenProject.getGroupId());
        projectModel.setParent(null);
        List dependencies = projectModel.getDependencies();
        dependencies.clear();
        dependencies.addAll(Objects.requireNonNullElse(this.mavenProject.getDependencies(), Collections.emptyList()));
        File output = new File(this.outputDirectory, this.tychoPomFilename);
        if (this.deleteOnExit) {
            output.deleteOnExit();
        }
        try {
            this.modelWriter.write(output, Map.of(), projectModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException("writing the model failed!", (Exception)e);
        }
        if (this.updatePomFile) {
            this.mavenProject.setFile(output);
        }
    }

    private void fixupPolyglot() {
        File[] files;
        File basedir = this.mavenProject.getBasedir();
        for (File file : files = basedir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(".polyglot.") && pathname.getName().endsWith(".bnd");
            }
        })) {
            File moved = new File(file.getParentFile(), ".polyglot.xml");
            if (!file.renameTo(moved)) continue;
            this.mavenProject.setFile(moved);
            moved.deleteOnExit();
        }
    }
}

