/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd.mojos;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.SubProject;
import aQute.bnd.osgi.Jar;
import aQute.service.reporter.Report;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.jar.JarOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.tycho.bnd.mojos.AbstractBndProjectMojo;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class BndBuildMojo
extends AbstractBndProjectMojo {
    @Component
    MavenProjectHelper helper;

    @Override
    protected void execute(Project project) throws Exception {
        List subProjects = project.getSubProjects();
        if (subProjects.isEmpty()) {
            this.getLog().info((CharSequence)String.format("Building bundle '%s'", project.getName()));
            File[] files = project.build();
            if (files != null && files.length > 0) {
                Artifact artifact = this.mavenProject.getArtifact();
                artifact.setFile(files[0]);
            }
        } else {
            for (SubProject subProject : subProjects) {
                ProjectBuilder builder = subProject.getProjectBuilder();
                this.getLog().info((CharSequence)String.format("Building sub bundle '%s'", subProject.getName()));
                Jar jar = builder.build();
                this.checkResult((Report)builder, project.getWorkspace().isFailOk());
                String name = subProject.getName();
                File file = project.getOutputFile(builder.getBsn(), builder.getVersion());
                file.getParentFile().mkdirs();
                jar.write(file);
                this.helper.attachArtifact(this.mavenProject, "jar", name, file);
            }
        }
        this.ensureArtifactIsSet();
    }

    private void ensureArtifactIsSet() throws IOException, FileNotFoundException {
        if ("pom".equals(this.mavenProject.getPackaging())) {
            return;
        }
        Artifact artifact = this.mavenProject.getArtifact();
        if (artifact.getFile() == null) {
            artifact.setFile(new File(this.mavenProject.getBuild().getDirectory(), this.mavenProject.getArtifactId() + ".jar"));
        }
        if (!artifact.getFile().exists()) {
            JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(artifact.getFile()));
            jarOutputStream.close();
        }
    }
}

