/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd;

import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.ManifestResource;
import aQute.bnd.osgi.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.bnd.MavenProjectResource;

public class MavenProjectJar
extends Jar {
    private Path outputFolder;

    public MavenProjectJar(MavenProject project, Predicate<Path> filter) throws IOException {
        super(project.getId());
        this.outputFolder = Path.of(project.getBuild().getOutputDirectory(), new String[0]);
        Files.walkFileTree(this.outputFolder, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String path = MavenProjectJar.this.outputFolder.relativize(file).toString();
                MavenProjectJar.this.putResource(path, new MavenProjectResource(file));
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void setManifest(Manifest manifest) {
        super.setManifest(manifest);
        this.putResource("META-INF/MANIFEST.MF", (Resource)new ManifestResource(manifest));
    }

    public boolean putResource(String path, Resource resource, boolean overwrite) {
        Path file;
        block16: {
            if (resource instanceof MavenProjectResource) {
                return super.putResource(path, resource, overwrite);
            }
            file = this.outputFolder.resolve(path);
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                if (!overwrite && Files.exists(file, new LinkOption[0])) break block16;
                try (InputStream stream = resource.openInputStream();
                     OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
                    stream.transferTo(outputStream);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return super.putResource(path, (Resource)new MavenProjectResource(file), overwrite);
    }
}

