/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd.mojos;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.RepositoryPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.bnd.MavenProjectJar;
import org.eclipse.tycho.classpath.ClasspathContributor;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.core.osgitools.BundleClassPath;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;
import org.eclipse.tycho.helper.PluginRealmHelper;

@Mojo(name="process", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class GenerateManifestMojo
extends AbstractMojo {
    private static final Predicate<Path> CLASS_FILTER = resource -> {
        if (Files.isRegularFile(resource, new LinkOption[0])) {
            return resource.getFileName().endsWith(".class");
        }
        return true;
    };
    @Component
    private Map<String, RepositoryPlugin> repositoryPlugins;
    @Parameter(property="project", readonly=true)
    protected MavenProject mavenProject;
    @Parameter(property="session", readonly=true)
    protected MavenSession session;
    @Component
    private PluginRealmHelper pluginRealmHelper;
    @Component
    private TychoProjectManager projectManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        TychoProject tychoProject = this.projectManager.getTychoProject(this.mavenProject).orElse(null);
        if (tychoProject instanceof OsgiBundleProject) {
            OsgiBundleProject osgi = (OsgiBundleProject)tychoProject;
            File basedir = this.mavenProject.getBasedir();
            File instructionsFile = new File(basedir, "pde.bnd");
            if (instructionsFile.isFile()) {
                try (Project project = new Project(this.getWorkspace(), basedir, instructionsFile);
                     ProjectBuilder builder = new ProjectBuilder(project);
                     MavenProjectJar jar = new MavenProjectJar(this.mavenProject, CLASS_FILTER);){
                    this.setupProject(project);
                    BundleClassPath bundleClassPath = osgi.getBundleClassPath(DefaultReactorProject.adapt((MavenProject)this.mavenProject));
                    builder.setBase(project.getBase());
                    builder.setJar((Jar)jar);
                    for (ClasspathEntry cpe : bundleClassPath.getClasspathEntries()) {
                        cpe.getLocations().forEach(arg_0 -> ((Project)project).addClasspath(arg_0));
                    }
                    try {
                        this.pluginRealmHelper.visitPluginExtensions(this.mavenProject, this.session, ClasspathContributor.class, cpc -> {
                            List list = cpc.getAdditionalClasspathEntries(this.mavenProject, "compile");
                            if (list != null && !list.isEmpty()) {
                                for (ClasspathEntry entry : list) {
                                    try {
                                        builder.addClasspath((Collection)entry.getLocations());
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new MojoExecutionException("can't call classpath contributors", e);
                    }
                    builder.build();
                }
                catch (MojoExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MojoFailureException("Can't generate manifest data", (Throwable)e);
                }
            }
        }
    }

    void setupProject(Project bnd) throws Exception {
        bnd.setBase(this.mavenProject.getBasedir());
        bnd.setProperty("src", this.mavenProject.getCompileSourceRoots().stream().collect(Collectors.joining(",")));
        bnd.setProperty("bin", this.mavenProject.getBuild().getOutputDirectory());
        bnd.setProperty("target-dir", this.mavenProject.getBuild().getDirectory());
    }

    Workspace getWorkspace() throws Exception {
        Processor run = new Processor();
        run.setProperty("-standalone", "true");
        Workspace workspace = Workspace.createStandaloneWorkspace((Processor)run, (URI)new File(this.mavenProject.getBuild().getDirectory(), "cnf").toURI());
        for (RepositoryPlugin repositoryPlugin : this.repositoryPlugins.values()) {
            workspace.addBasicPlugin((Object)repositoryPlugin);
        }
        workspace.refresh();
        return workspace;
    }
}

