/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.build;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.graph.DefaultGraphBuilder;
import org.apache.maven.graph.DefaultProjectDependencyGraph;
import org.apache.maven.graph.GraphBuilder;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.Result;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.tycho.build.MavenLoggerAdapter;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.p2.target.ee.NoExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2.util.resolution.ExecutionEnvironmentResolutionHints;
import org.eclipse.tycho.p2.util.resolution.ProjectorResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.ResolutionData;
import org.eclipse.tycho.p2.util.resolution.ResolutionDataImpl;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

@Component(role=GraphBuilder.class, hint="graphBuilder")
public class TychoGraphBuilder
extends DefaultGraphBuilder {
    public static final String TYPE_ECLIPSE_PLUGIN = "eclipse-plugin";
    public static final String TYPE_ECLIPSE_TEST_PLUGIN = "eclipse-test-plugin";
    public static final String TYPE_ECLIPSE_FEATURE = "eclipse-feature";
    public static final String TYPE_ECLIPSE_REPOSITORY = "eclipse-repository";
    public static final String TYPE_ECLIPSE_TARGET_DEFINITION = "eclipse-target-definition";
    @Requirement
    private Logger log;
    @Requirement(hint="plexus")
    private BundleContext bundleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<ProjectDependencyGraph> build(MavenSession session) {
        boolean makeDownstream;
        MavenExecutionRequest request = session.getRequest();
        ProjectDependencyGraph dependencyGraph = session.getProjectDependencyGraph();
        Result graphResult = super.build(session);
        if (dependencyGraph != null || graphResult.hasErrors()) {
            return graphResult;
        }
        session.getUserProperties().put("tycho.mode", "extension");
        MavenLoggerAdapter loggerAdapter = new MavenLoggerAdapter(this.log, Boolean.valueOf(session.getUserProperties().getProperty("tycho.debug.resolver")));
        String makeBehavior = request.getMakeBehavior();
        if (loggerAdapter.isExtendedDebugEnabled()) {
            loggerAdapter.debug("TychoGraphBuilder:");
            loggerAdapter.debug("  - SelectedProjects: " + request.getSelectedProjects());
            loggerAdapter.debug("  - ExcludedProjects: " + request.getExcludedProjects());
            loggerAdapter.debug("  - MakeBehavior:     " + makeBehavior);
        }
        boolean makeUpstream = "make-upstream".equals(makeBehavior) || "make-both".equals(makeBehavior);
        boolean bl = makeDownstream = "make-downstream".equals(makeBehavior) || "make-both".equals(makeBehavior);
        if (!makeDownstream && !makeUpstream) {
            return graphResult;
        }
        ProjectDependencyGraph graph = (ProjectDependencyGraph)graphResult.get();
        List projects = graph.getAllProjects();
        CopyOnWriteArrayList<ModelProblem> problems = new CopyOnWriteArrayList<ModelProblem>();
        int degreeOfConcurrency = request.getDegreeOfConcurrency();
        boolean failFast = "FAIL_FAST".equals(request.getReactorFailureBehavior());
        Optional<Object> executor = degreeOfConcurrency > 1 ? Optional.of(new ForkJoinPool(degreeOfConcurrency)) : Optional.empty();
        BooleanSupplier hasFailures = () -> failFast && !problems.isEmpty();
        ConcurrentHashMap.KeySetView selectedProjects = ConcurrentHashMap.newKeySet();
        try {
            ConcurrentHashMap projectIUMap = new ConcurrentHashMap();
            try {
                Function<MavenProject, Collection<IInstallableUnit>> projectUnits = this.computeProjectUnits(problems);
                TychoGraphBuilder.runStream(projects.stream(), p -> projectIUMap.put(p, (Collection)projectUnits.apply((MavenProject)p)), hasFailures, executor);
            }
            catch (ExecutionException e) {
                this.log.error("Can't read projects", (Throwable)e);
                Result result = Result.error((Object)graph);
                executor.ifPresent(ExecutorService::shutdownNow);
                return result;
            }
            ConcurrentHashMap projectDependenciesMap = new ConcurrentHashMap();
            try {
                Collection availableIUs = projectIUMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                Function<Map.Entry<MavenProject, Collection<IInstallableUnit>>, Collection<IInstallableUnit>> function = this.computeProjectDependencies(availableIUs, problems, loggerAdapter);
                TychoGraphBuilder.runStream(projectIUMap.entrySet().stream(), entry -> projectDependenciesMap.put((MavenProject)entry.getKey(), (Collection)projectDependencies.apply((Map.Entry<MavenProject, Collection<IInstallableUnit>>)entry)), hasFailures, executor);
            }
            catch (ExecutionException e) {
                this.log.error("Can't resolve projects", (Throwable)e);
                Result result = Result.error((Object)graph);
                executor.ifPresent(ExecutorService::shutdownNow);
                return result;
            }
            if (hasFailures.getAsBoolean()) {
                if (loggerAdapter.isExtendedDebugEnabled()) {
                    for (ModelProblem modelProblem : problems) {
                        loggerAdapter.error(modelProblem.getMessage(), modelProblem.getException());
                    }
                }
                Result e = Result.error((Object)graph, problems);
                return e;
            }
            HashMap<IInstallableUnit, MavenProject> iuProjectMap = new HashMap<IInstallableUnit, MavenProject>();
            for (Map.Entry entry2 : projectIUMap.entrySet()) {
                MavenProject mavenProject = (MavenProject)entry2.getKey();
                for (IInstallableUnit iu : (Collection)entry2.getValue()) {
                    iuProjectMap.put(iu, mavenProject);
                }
            }
            if (loggerAdapter.isExtendedDebugEnabled()) {
                for (Map.Entry entry3 : projectDependenciesMap.entrySet()) {
                    MavenProject project2 = (MavenProject)entry3.getKey();
                    Collection depends = (Collection)entry3.getValue();
                    if (depends.isEmpty()) continue;
                    loggerAdapter.debug("[[ project " + project2.getName() + " depends on: ]]");
                    for (IInstallableUnit dependency : depends) {
                        MavenProject mavenProject = (MavenProject)iuProjectMap.get(dependency);
                        if (mavenProject == null) {
                            loggerAdapter.debug(" IU: " + dependency);
                            continue;
                        }
                        loggerAdapter.debug(" IU: " + dependency + " [of project " + mavenProject.getName() + "]");
                    }
                }
            }
            ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue(graph.getSortedProjects().stream().map(p -> new ProjectRequest((MavenProject)p, makeDownstream, makeUpstream, null)).collect(Collectors.toList()));
            loggerAdapter.debug("Computing additional " + makeBehavior + " dependencies based on initial project set of " + concurrentLinkedQueue.stream().map(r -> r.mavenProject).map(MavenProject::getName).collect(Collectors.joining(", ")));
            while (!concurrentLinkedQueue.isEmpty()) {
                ProjectRequest projectRequest = (ProjectRequest)concurrentLinkedQueue.poll();
                if (!selectedProjects.add(projectRequest.mavenProject)) continue;
                if (projectRequest.requestUpstream) {
                    Collection depends = projectDependenciesMap.getOrDefault(projectRequest.mavenProject, Collections.emptyList());
                    depends.stream().map(iuProjectMap::get).filter(Objects::nonNull).distinct().peek(project -> loggerAdapter.debug(" + add upstream project '" + project.getName() + "' of project '" + projectRequest.mavenProject.getName() + "'...")).forEach(project -> queue.add(new ProjectRequest((MavenProject)project, false, false, projectRequest)));
                }
                if (!projectRequest.requestDownstream) continue;
                projectDependenciesMap.entrySet().stream().filter(entry -> ((Collection)entry.getValue()).stream().map(iuProjectMap::get).filter(Objects::nonNull).anyMatch(projectRequest::matches)).map(Map.Entry::getKey).distinct().peek(project -> loggerAdapter.debug(" + add downstream project '" + project.getName() + "' of project '" + projectRequest.mavenProject.getName() + "'...")).forEach(project -> queue.add(new ProjectRequest((MavenProject)project, false, true, projectRequest)));
            }
            for (MavenProject mavenProject : projects) {
                if (!TYPE_ECLIPSE_TARGET_DEFINITION.equals(mavenProject.getPackaging())) continue;
                selectedProjects.add(mavenProject);
            }
        }
        finally {
            executor.ifPresent(ExecutorService::shutdownNow);
        }
        try {
            return Result.success((Object)new DefaultProjectDependencyGraph(projects, selectedProjects));
        }
        catch (DuplicateProjectException | CycleDetectedException e) {
            this.log.error("Can't compute project dependency graph", e);
            return Result.error((Object)graph);
        }
    }

    private Function<MavenProject, Collection<IInstallableUnit>> computeProjectUnits(List<ModelProblem> problems) {
        return project -> {
            PublisherInfo publisherInfo = new PublisherInfo();
            publisherInfo.setArtifactOptions(1);
            if (TYPE_ECLIPSE_PLUGIN.equals(project.getPackaging()) || TYPE_ECLIPSE_TEST_PLUGIN.equals(project.getPackaging())) {
                try {
                    BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)project.getBasedir());
                    IArtifactKey descriptor = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
                    IInstallableUnit iu = BundlesAction.createBundleIU((BundleDescription)bundleDescription, (IArtifactKey)descriptor, (IPublisherInfo)publisherInfo);
                    return Collections.singletonList(iu);
                }
                catch (IOException | BundleException e) {
                    problems.add((ModelProblem)new DefaultModelProblem("can't read " + project.getPackaging() + " project @ " + project.getBasedir(), ModelProblem.Severity.ERROR, null, null, 0, 0, (Exception)e));
                }
            } else if (TYPE_ECLIPSE_FEATURE.equals(project.getPackaging())) {
                FeatureParser parser = new FeatureParser();
                File basedir = project.getBasedir();
                Feature feature = parser.parse(basedir);
                final HashMap featureMap = new HashMap();
                FeaturesAction action = new FeaturesAction(new Feature[]{feature}){

                    protected void publishFeatureArtifacts(Feature feature, IInstallableUnit featureIU, IPublisherInfo publisherInfo) {
                    }

                    protected IInstallableUnit generateFeatureJarIU(Feature feature, IPublisherInfo publisherInfo) {
                        IInstallableUnit iu = super.generateFeatureJarIU(feature, publisherInfo);
                        featureMap.put(iu, feature);
                        return iu;
                    }
                };
                PublisherResult results = new PublisherResult();
                action.perform((IPublisherInfo)publisherInfo, (IPublisherResult)results, null);
                Set result = results.query(QueryUtil.ALL_UNITS, null).toSet();
                return result;
            }
            return Collections.emptyList();
        };
    }

    private Function<Map.Entry<MavenProject, Collection<IInstallableUnit>>, Collection<IInstallableUnit>> computeProjectDependencies(Collection<IInstallableUnit> availableIUs, List<ModelProblem> problems, MavenLogger logger) {
        return entry -> {
            Collection projectUnits = (Collection)entry.getValue();
            if (!projectUnits.isEmpty()) {
                MavenProject project = (MavenProject)entry.getKey();
                logger.debug("Resolve dependencies for project " + project.getName() + "...");
                try {
                    ProjectorResolutionStrategy resolutionStrategy = new ProjectorResolutionStrategy(logger);
                    ResolutionDataImpl data = new ResolutionDataImpl((ExecutionEnvironmentResolutionHints)NoExecutionEnvironmentResolutionHints.INSTANCE);
                    data.setFailOnMissing(false);
                    data.setAvailableIUs(Collections.unmodifiableCollection(availableIUs));
                    data.setRootIUs(Collections.unmodifiableCollection(projectUnits));
                    data.setSlicerPredicate(always -> true);
                    resolutionStrategy.setData((ResolutionData)data);
                    Collection resolve = resolutionStrategy.resolve(new HashMap(), (IProgressMonitor)new NullProgressMonitor());
                    resolve.removeAll(projectUnits);
                    return resolve;
                }
                catch (ResolverException e) {
                    problems.add((ModelProblem)new DefaultModelProblem("can't resolve " + project.getPackaging() + " project @ " + project.getBasedir(), ModelProblem.Severity.ERROR, null, null, 0, 0, (Exception)((Object)e)));
                }
            }
            return Collections.emptyList();
        };
    }

    private static <T> void runStream(Stream<T> stream, Consumer<? super T> consumer, BooleanSupplier hasFailures, Optional<ExecutorService> service) throws ExecutionException {
        if (hasFailures.getAsBoolean()) {
            return;
        }
        Predicate<Object> takeWhile = nil -> !hasFailures.getAsBoolean();
        if (service.isEmpty()) {
            ((Stream)stream.unordered()).takeWhile(takeWhile).forEach(consumer);
        } else {
            Future<?> future = service.get().submit(() -> ((Stream)((Stream)stream.unordered()).parallel()).takeWhile(takeWhile).forEach(consumer));
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class ProjectRequest {
        final MavenProject mavenProject;
        final ProjectRequest parent;
        final boolean requestDownstream;
        final boolean requestUpstream;

        ProjectRequest(MavenProject mavenProject, boolean requestDownstream, boolean requestUpstream, ProjectRequest parent) {
            this.requestDownstream = requestDownstream;
            this.requestUpstream = requestUpstream;
            this.parent = parent;
            this.mavenProject = mavenProject;
        }

        boolean matches(MavenProject mavenproject) {
            return this.mavenProject == mavenproject;
        }

        public String toString() {
            return "ProjectRequest [mavenProject=" + this.mavenProject + ", parent=" + this.parent + ", requestDownstream=" + this.requestDownstream + ", requestUpstream=" + this.requestUpstream + "]";
        }
    }
}

