/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.graph.DefaultGraphBuilder;
import org.apache.maven.graph.DefaultProjectDependencyGraph;
import org.apache.maven.graph.GraphBuilder;
import org.apache.maven.model.building.DefaultModelProblem;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.Result;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.tycho.build.MavenLoggerAdapter;
import org.eclipse.tycho.p2maven.MavenProjectDependencyProcessor;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.sonatype.maven.polyglot.mapping.Mapping;

@Component(role=GraphBuilder.class, hint="graphBuilder")
public class TychoGraphBuilder
extends DefaultGraphBuilder {
    @Requirement
    private Logger log;
    @Requirement(role=Mapping.class)
    private Map<String, Mapping> polyglotMappings;
    @Requirement
    private MavenProjectDependencyProcessor dependencyProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<ProjectDependencyGraph> build(MavenSession session) {
        boolean makeDownstream;
        Objects.requireNonNull(session);
        for (Mapping mapping : this.polyglotMappings.values()) {
            if (!(mapping instanceof AbstractTychoMapping)) continue;
            AbstractTychoMapping tychoMapping = (AbstractTychoMapping)mapping;
            tychoMapping.setExtensionMode(true);
            tychoMapping.setMultiModuleProjectDirectory(session.getRequest().getMultiModuleProjectDirectory());
            if (session.getRequest().getSystemProperties().getProperty("tycho.buildqualifier.format") == null) continue;
            tychoMapping.setSnapshotFormat("${qualifier}");
        }
        MavenExecutionRequest request = session.getRequest();
        ProjectDependencyGraph dependencyGraph = session.getProjectDependencyGraph();
        Result graphResult = super.build(session);
        if (dependencyGraph != null || graphResult.hasErrors()) {
            return graphResult;
        }
        session.getUserProperties().put("tycho.mode", "extension");
        MavenLoggerAdapter loggerAdapter = new MavenLoggerAdapter(this.log, Boolean.valueOf(session.getUserProperties().getProperty("tycho.debug.resolver")));
        String makeBehavior = request.getMakeBehavior();
        if (loggerAdapter.isExtendedDebugEnabled()) {
            loggerAdapter.debug("TychoGraphBuilder:");
            loggerAdapter.debug("  - SelectedProjects: " + request.getSelectedProjects());
            loggerAdapter.debug("  - ExcludedProjects: " + request.getExcludedProjects());
            loggerAdapter.debug("  - MakeBehavior:     " + makeBehavior);
        }
        boolean makeUpstream = "make-upstream".equals(makeBehavior) || "make-both".equals(makeBehavior);
        boolean bl = makeDownstream = "make-downstream".equals(makeBehavior) || "make-both".equals(makeBehavior);
        if (!makeDownstream && !makeUpstream) {
            return graphResult;
        }
        ProjectDependencyGraph graph = (ProjectDependencyGraph)graphResult.get();
        List projects = graph.getAllProjects();
        int degreeOfConcurrency = request.getDegreeOfConcurrency();
        Optional<Object> executor = degreeOfConcurrency > 1 ? Optional.of(new ForkJoinPool(degreeOfConcurrency)) : Optional.empty();
        ConcurrentHashMap.KeySetView selectedProjects = ConcurrentHashMap.newKeySet();
        try {
            MavenProjectDependencyProcessor.ProjectDependencyClosure dependencyClosure;
            try {
                dependencyClosure = this.dependencyProcessor.computeProjectDependencyClosure((Collection)projects, session);
            }
            catch (CoreException e) {
                this.log.error("Can't resolve projects", (Throwable)e);
                Result result = Result.error((Object)graph, this.toProblems(e.getStatus(), new ArrayList<ModelProblem>()));
                executor.ifPresent(ExecutorService::shutdownNow);
                return result;
            }
            if (loggerAdapter.isExtendedDebugEnabled()) {
                for (MavenProject project2 : projects) {
                    MavenProjectDependencyProcessor.ProjectDependencies depends = dependencyClosure.getProjectDependecies(project2);
                    if (depends.getDependencies().isEmpty()) continue;
                    loggerAdapter.debug("[[ project " + project2.getName() + " depends on: ]]");
                    for (IInstallableUnit dependency : depends.getDependencies()) {
                        Optional mavenProject = dependencyClosure.getProject(dependency);
                        if (mavenProject.isEmpty()) {
                            loggerAdapter.debug(" IU: " + dependency);
                            continue;
                        }
                        loggerAdapter.debug(" IU: " + dependency + " [of project " + ((MavenProject)mavenProject.get()).getName() + "]");
                    }
                }
            }
            ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue(graph.getSortedProjects().stream().map(p -> new ProjectRequest((MavenProject)p, makeDownstream, makeUpstream, null)).collect(Collectors.toList()));
            loggerAdapter.debug("Computing additional " + makeBehavior + " dependencies based on initial project set of " + queue.stream().map(r -> r.mavenProject).map(MavenProject::getName).collect(Collectors.joining(", ")));
            while (!queue.isEmpty()) {
                ProjectRequest projectRequest = (ProjectRequest)queue.poll();
                if (!selectedProjects.add(projectRequest.mavenProject)) continue;
                if (projectRequest.addDependencies) {
                    dependencyClosure.getDependencyProjects(projectRequest.mavenProject).forEach(project -> {
                        loggerAdapter.debug(" + add dependency project '" + project.getId() + "' of project '" + projectRequest.mavenProject.getId() + "'...");
                        queue.add(new ProjectRequest((MavenProject)project, false, true, projectRequest));
                    });
                }
                if (!projectRequest.addRequires) continue;
                dependencyClosure.dependencies().filter(entry -> ((Collection)entry.getValue()).stream().flatMap(dependency -> dependencyClosure.getProject(dependency).stream()).anyMatch(projectRequest::matches)).map(Map.Entry::getKey).distinct().peek(project -> loggerAdapter.debug(" + add project '" + project.getId() + "' that depends on '" + projectRequest.mavenProject.getId() + "'...")).forEach(project -> queue.add(new ProjectRequest((MavenProject)project, true, true, projectRequest)));
            }
            for (MavenProject mavenProject : projects) {
                if (!"eclipse-target-definition".equals(mavenProject.getPackaging())) continue;
                selectedProjects.add(mavenProject);
            }
        }
        finally {
            executor.ifPresent(ExecutorService::shutdownNow);
        }
        try {
            this.log.debug("=============== SELECTED PROJECTS ==================");
            selectedProjects.stream().sorted(Comparator.comparing(MavenProject::getGroupId, String.CASE_INSENSITIVE_ORDER).thenComparing(MavenProject::getArtifactId, String.CASE_INSENSITIVE_ORDER)).forEachOrdered(p -> this.log.debug(p.getId()));
            return Result.success((Object)new DefaultProjectDependencyGraph(projects, selectedProjects));
        }
        catch (DuplicateProjectException | CycleDetectedException e) {
            this.log.error("Can't compute project dependency graph", e);
            return Result.error((Object)graph);
        }
    }

    private List<ModelProblem> toProblems(IStatus status, List<ModelProblem> problems) {
        int severity = status.getSeverity();
        if (severity == 0 || severity == 1) {
            return problems;
        }
        Throwable throwable = status.getException();
        Exception exception = throwable == null ? null : (throwable instanceof Exception ? (Exception)throwable : new ExecutionException(throwable));
        ModelProblem.Severity serv = severity == 2 || severity == 8 ? ModelProblem.Severity.WARNING : ModelProblem.Severity.ERROR;
        problems.add((ModelProblem)new DefaultModelProblem(status.getMessage(), serv, null, null, 0, 0, exception));
        for (IStatus child : status.getChildren()) {
            this.toProblems(child, problems);
        }
        return problems;
    }

    private static final class ProjectRequest {
        final MavenProject mavenProject;
        final ProjectRequest parent;
        final boolean addRequires;
        final boolean addDependencies;

        ProjectRequest(MavenProject mavenProject, boolean addRequires, boolean addDependencies, ProjectRequest parent) {
            this.addRequires = addRequires;
            this.addDependencies = addDependencies;
            this.parent = parent;
            this.mavenProject = mavenProject;
        }

        boolean matches(MavenProject mavenproject) {
            return this.mavenProject == mavenproject;
        }

        public String toString() {
            return "ProjectRequest [mavenProject=" + this.mavenProject + ", parent=" + this.parent + ", addRequires=" + this.addRequires + ", addDependencies=" + this.addDependencies + "]";
        }
    }
}

