/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.build.bnd;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Map;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.build.bnd.TychoVersion;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.sonatype.maven.polyglot.mapping.Mapping;

@Component(role=Mapping.class, hint="bnd")
public class BndProjectMapping
extends AbstractTychoMapping {
    private static final String TYCHO_BND_PLUGIN = "tycho-bnd-plugin";
    @Requirement(role=Lifecycle.class)
    private Map<String, Lifecycle> lifecycles;

    public float getPriority() {
        return 100.0f;
    }

    protected boolean isValidLocation(Path location) {
        try {
            return BndProjectMapping.getFileName((Path)location).equals("bnd.bnd") && Workspace.findWorkspace((File)location.getParent().toFile()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected File getPrimaryArtifact(File dir) {
        File bndFile = new File(dir, "bnd.bnd");
        try {
            if (bndFile.exists() && Workspace.findWorkspace((File)dir.getParentFile()) != null) {
                return bndFile;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected String getPackaging() {
        return "jar";
    }

    public String getFlavour() {
        return "bnd";
    }

    protected void initModel(Model model, Reader artifactReader, Path artifactFile) throws IOException {
        try {
            Project project = Workspace.getProject((File)artifactFile.getParent().toFile());
            String g = project.getProperty("maven-groupId");
            String a = project.getProperty("maven-artifactId");
            String v = project.getProperty("maven-version");
            if (g != null) {
                model.setGroupId(g);
            }
            if (a == null) {
                model.setArtifactId(project.getName());
            } else {
                model.setArtifactId(a);
            }
            if (v == null) {
                model.setVersion(project.getBundleVersion());
            } else {
                model.setVersion(v);
            }
            model.setVersion(project.getBundleVersion());
            Plugin bndPlugin = BndProjectMapping.getPlugin((Model)model, (String)"org.eclipse.tycho", (String)TYCHO_BND_PLUGIN);
            bndPlugin.setExtensions(true);
            bndPlugin.setVersion(TychoVersion.getTychoVersion());
            BndProjectMapping.addPluginExecution((Plugin)bndPlugin, execution -> {
                execution.setId("clean");
                execution.addGoal("clean");
            });
            BndProjectMapping.addPluginExecution((Plugin)bndPlugin, execution -> {
                execution.setId("compile");
                execution.addGoal("compile");
            });
            BndProjectMapping.addPluginExecution((Plugin)bndPlugin, execution -> {
                execution.setId("testCompile");
                execution.addGoal("test-compile");
            });
            BndProjectMapping.addPluginExecution((Plugin)bndPlugin, execution -> {
                execution.setId("integration-test");
                execution.addGoal("integration-test");
            });
            BndProjectMapping.addPluginExecution((Plugin)bndPlugin, execution -> {
                execution.setId("build");
                execution.addGoal("build");
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                IOException io = (IOException)e;
                throw io;
            }
            if (e instanceof RuntimeException) {
                RuntimeException rt = (RuntimeException)e;
                throw rt;
            }
            throw new IOException(e);
        }
    }
}

