/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.build;

import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.core.shared.MavenLogger;

public class MavenLoggerAdapter
implements MavenLogger {
    private final Logger logger;
    private final boolean extendedDebug;

    public MavenLoggerAdapter(Logger logger, boolean extendedDebug) {
        this.logger = logger;
        this.extendedDebug = extendedDebug;
    }

    public void debug(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message);
        } else if (this.isExtendedDebugEnabled()) {
            this.logger.info(message);
        }
    }

    public void debug(String message, Throwable cause) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message, cause);
        } else if (this.isExtendedDebugEnabled()) {
            this.logger.info(message, cause);
        }
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable cause) {
        this.logger.warn(message, cause);
    }

    public void error(String message, Throwable cause) {
        this.logger.error(message, cause);
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled() || this.isExtendedDebugEnabled();
    }

    public boolean isExtendedDebugEnabled() {
        return this.extendedDebug;
    }
}

