/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.build.bnd;

import aQute.bnd.build.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.eclipse.tycho.pomless.NoParentPomFound;
import org.sonatype.maven.polyglot.mapping.Mapping;

@Component(role=Mapping.class, hint="bnd-workspace")
public class BndWorkspaceMapping
extends AbstractTychoMapping {
    private Map<String, List<String>> modulesCache = new ConcurrentHashMap<String, List<String>>();

    public float getPriority() {
        return -20.0f;
    }

    protected boolean isValidLocation(Path polyglotFile) {
        return BndWorkspaceMapping.hasBndWorkspace(polyglotFile.getParent());
    }

    public static boolean hasBndWorkspace(Path dir) {
        Path cnfPath = dir.resolve("cnf");
        return Files.isDirectory(cnfPath, new LinkOption[0]) && Files.isRegularFile(cnfPath.resolve("build.bnd"), new LinkOption[0]);
    }

    protected File getPrimaryArtifact(File dir) {
        File cnfDir = new File(dir, "cnf");
        if (new File(cnfDir, "build.bnd").isFile()) {
            return cnfDir;
        }
        return null;
    }

    public String getFlavour() {
        return "bnd-workspace";
    }

    protected String getPackaging() {
        return "pom";
    }

    protected void initModel(Model model, Reader artifactReader, Path cnfFolder) throws IOException {
        Path workspaceRoot = cnfFolder.getParent();
        List projects = this.modulesCache.computeIfAbsent(workspaceRoot.toAbsolutePath().toString(), path -> {
            List<String> list;
            block11: {
                Stream<Path> listing = Files.list(workspaceRoot);
                try {
                    this.logger.debug("Scanning " + path + "...");
                    List<String> modules = listing.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(dir -> Files.isRegularFile(dir.resolve("bnd.bnd"), new LinkOption[0])).map(Path::getFileName).map(String::valueOf).toList();
                    for (String module : modules) {
                        this.logger.debug("Found BND project " + module + ".");
                    }
                    list = modules;
                    if (listing == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (listing != null) {
                            try {
                                listing.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.error("Can't determine BND projects for path " + path + "!", (Throwable)e);
                        } else {
                            this.logger.warn("Can't determine BND projects for path " + path + "! (" + e.getMessage() + ")");
                        }
                        return List.of();
                    }
                }
                listing.close();
            }
            return list;
        });
        model.setModules(projects);
        model.setGroupId(workspaceRoot.getFileName().toString());
        model.setArtifactId("bnd-parent");
        model.setVersion("1.0.0");
        try {
            String bundleVersion;
            String v;
            String a;
            Workspace workspace = Workspace.findWorkspace((File)cnfFolder.toFile());
            String g = workspace.getProperty("maven-groupId");
            if (g != null) {
                model.setGroupId(g);
            }
            if ((a = workspace.getProperty("maven-artifactId")) != null) {
                model.setArtifactId(a);
            }
            if ((v = workspace.getProperty("maven-version")) != null) {
                model.setVersion(v);
            }
            if ((bundleVersion = workspace.getProperty("Bundle-Version")) != null) {
                model.setVersion(bundleVersion);
            }
        }
        catch (Exception e) {
            this.logger.debug("Can't derive properties from project!");
        }
    }

    protected Parent findParent(Path projectRoot, Map<String, ?> projectOptions) throws IOException {
        try {
            return super.findParent(projectRoot, projectOptions);
        }
        catch (NoParentPomFound e) {
            return null;
        }
    }
}

