/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.build;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Priority;
import javax.inject.Inject;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.interpolation.DefaultModelVersionProcessor;
import org.apache.maven.model.interpolation.ModelVersionProcessor;
import org.apache.maven.model.io.DefaultModelReader;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.tycho.build.BuildTimestampProvider;

@Priority(value=100)
@Component(role=ModelVersionProcessor.class)
public class TychoCiFriendlyVersions
extends DefaultModelVersionProcessor
implements ModelVersionProcessor {
    static final String PROPERTY_FORCE_QUALIFIER = "forceContextQualifier";
    static final String PROPERTY_BUILDQUALIFIER_FORMAT = "tycho.buildqualifier.format";
    static final String BUILD_QUALIFIER = "qualifier";
    static final String MICRO_VERSION = "micro";
    static final String MINOR_VERSION = "minor";
    static final String MAJOR_VERSION = "major";
    static final String RELEASE_VERSION = "releaseVersion";
    private static final Set<String> SIMPLE_PROPERTIES = Set.of("releaseVersion", "major", "minor", "micro");
    private PlexusContainer container;
    private Logger logger;
    private Map<File, MavenProject> rawProjectCache = new ConcurrentHashMap<File, MavenProject>();

    @Inject
    public TychoCiFriendlyVersions(PlexusContainer plexusContainer, Logger logger) {
        this.container = plexusContainer;
        this.logger = logger;
    }

    public boolean isValidProperty(String property) {
        return super.isValidProperty(property) || SIMPLE_PROPERTIES.contains(property) || BUILD_QUALIFIER.equals(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteModelProperties(Properties modelProperties, ModelBuildingRequest request) {
        super.overwriteModelProperties(modelProperties, request);
        for (String property : SIMPLE_PROPERTIES) {
            if (!request.getSystemProperties().containsKey(property)) continue;
            modelProperties.put(property, request.getSystemProperties().get(property));
        }
        if (request.getSystemProperties().containsKey(BUILD_QUALIFIER)) {
            modelProperties.put(BUILD_QUALIFIER, request.getSystemProperties().get(BUILD_QUALIFIER));
        } else {
            String forceContextQualifier = request.getSystemProperties().getProperty(PROPERTY_FORCE_QUALIFIER);
            if (forceContextQualifier != null) {
                modelProperties.put(BUILD_QUALIFIER, "." + forceContextQualifier);
            } else {
                String formatString = request.getSystemProperties().getProperty(PROPERTY_BUILDQUALIFIER_FORMAT);
                if (formatString != null) {
                    Date startTime = request.getBuildStartTime();
                    File pomFile = request.getPomFile();
                    if (startTime != null && pomFile != null) {
                        String provider = request.getSystemProperties().getProperty("tycho.buildqualifier.provider", "default");
                        try {
                            BuildTimestampProvider timestampProvider = (BuildTimestampProvider)this.container.lookup(BuildTimestampProvider.class, provider);
                            SimpleDateFormat format = new SimpleDateFormat(formatString);
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            MavenProject mavenProject = this.getMavenProject(pomFile);
                            timestampProvider.setQuiet(true);
                            try {
                                Date timestamp = timestampProvider.getTimestamp(this.getMavenSession(request), mavenProject, this.getExecution(mavenProject));
                                String qualifier = format.format(timestamp);
                                modelProperties.put(BUILD_QUALIFIER, "." + qualifier);
                            }
                            finally {
                                timestampProvider.setQuiet(false);
                            }
                        }
                        catch (MojoExecutionException | ComponentLookupException e) {
                            this.logger.warn("Cannot use '" + provider + "' as a timestamp provider for tycho-ci-friendly-versions (" + String.valueOf(e) + ")");
                        }
                    }
                }
            }
        }
    }

    private MojoExecution getExecution(MavenProject mavenProject) {
        Plugin projectPlugin = this.getPlugin("org.eclipse.tycho:tycho-packaging-plugin", mavenProject);
        if (projectPlugin == null) {
            projectPlugin = new Plugin();
            projectPlugin.setGroupId("org.eclipse.tycho");
            projectPlugin.setArtifactId("tycho-packaging-plugin");
            try {
                projectPlugin.setConfiguration((Object)Xpp3DomBuilder.build((Reader)new StringReader("<configuration><jgit.dirtyWorkingTree>ignore</jgit.dirtyWorkingTree></configuration>")));
            }
            catch (IOException | XmlPullParserException e) {
                projectPlugin.setConfiguration(null);
            }
        }
        return new MojoExecution(projectPlugin, "", "");
    }

    private Plugin getPlugin(String id, MavenProject mavenProject) {
        if (mavenProject == null) {
            return null;
        }
        Plugin plugin = mavenProject.getPlugin(id);
        if (plugin == null) {
            return this.getPlugin(id, mavenProject.getParent());
        }
        return plugin;
    }

    private MavenProject getMavenProject(File pom) {
        File parentPom;
        Parent parent;
        MavenProject project = this.rawProjectCache.computeIfAbsent(pom, file -> {
            MavenProject mavenProject = new MavenProject();
            DefaultModelReader modelReader = new DefaultModelReader();
            try {
                mavenProject.setModel(modelReader.read(pom, Map.of()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            mavenProject.setFile(pom);
            return mavenProject;
        });
        Model model = project.getModel();
        if (model != null && (parent = model.getParent()) != null && (parentPom = new File(pom.getParentFile(), parent.getRelativePath())).isFile()) {
            project.setParent(this.getMavenProject(parentPom));
        }
        return project;
    }

    private MavenSession getMavenSession(ModelBuildingRequest request) {
        try {
            LegacySupport legacySupport = (LegacySupport)this.container.lookup(LegacySupport.class);
            MavenSession session = legacySupport.getSession();
            if (session != null) {
                return session;
            }
        }
        catch (ComponentLookupException legacySupport) {
            // empty catch block
        }
        DefaultMavenExecutionRequest executionRequest = new DefaultMavenExecutionRequest();
        executionRequest.setBaseDirectory(request.getPomFile().getParentFile());
        executionRequest.setStartTime(request.getBuildStartTime());
        return new MavenSession(this.container, (MavenExecutionRequest)executionRequest, (MavenExecutionResult)new DefaultMavenExecutionResult(), Collections.emptyList());
    }
}

