/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.build.bnd;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Processor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.tycho.bndlib.JdtProjectBuilder;
import org.eclipse.tycho.pomless.AbstractTychoMapping;
import org.eclipse.tycho.pomless.NoParentPomFound;
import org.eclipse.tycho.pomless.ParentModel;
import org.eclipse.tycho.version.TychoVersion;
import org.sonatype.maven.polyglot.mapping.Mapping;

@Component(role=Mapping.class, hint="bnd")
public class BndProjectMapping
extends AbstractTychoMapping {
    private static final String TYCHO_BND_PLUGIN = "tycho-bnd-plugin";
    @Requirement(role=Lifecycle.class)
    private Map<String, Lifecycle> lifecycles;

    public float getPriority() {
        return 100.0f;
    }

    protected boolean isValidLocation(Path location) {
        try {
            return BndProjectMapping.getFileName((Path)location).equals("bnd.bnd") && Workspace.findWorkspace((File)location.getParent().toFile()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected File getPrimaryArtifact(File dir) {
        File bndFile = new File(dir, "bnd.bnd");
        try {
            if (bndFile.exists() && Workspace.findWorkspace((File)dir.getParentFile()) != null) {
                return bndFile;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected String getPackaging() {
        return "jar";
    }

    public String getFlavour() {
        return "bnd";
    }

    protected Properties getEnhancementProperties(Path file) throws IOException {
        Properties bnd = new Properties();
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            bnd.load(stream);
            Properties properties = bnd;
            return properties;
        }
    }

    protected void initModel(Model model, Reader artifactReader, Path artifactFile) throws IOException {
        try {
            Workspace.setDriver((String)"tycho-maven-build");
            Project project = Workspace.getProject((File)artifactFile.getParent().toFile());
            if (project.getSubProjects().isEmpty()) {
                model.setPackaging(this.getPackaging());
            } else {
                model.setPackaging("pom");
            }
            String g = project.getProperty("maven-groupId");
            String a = project.getProperty("maven-artifactId");
            String v = project.getProperty("maven-version");
            if (g != null) {
                model.setGroupId(g);
            }
            if (a == null || v == null) {
                try (ProjectBuilder builder = BndProjectMapping.createBuilder(project);){
                    if (a == null) {
                        a = builder.getBsn();
                    }
                    if (v == null) {
                        v = builder.getVersion();
                    }
                }
            }
            model.setArtifactId(a);
            model.setVersion(v);
            Build build = BndProjectMapping.getBuild((Model)model);
            build.setDirectory(BndProjectMapping.path(project.getTarget()));
            build.setOutputDirectory(BndProjectMapping.path(project.getSrcOutput()));
            build.setTestOutputDirectory(BndProjectMapping.path(project.getTestOutput()));
            File src = project.getSrc();
            build.setSourceDirectory(BndProjectMapping.path(src));
            build.setTestSourceDirectory(BndProjectMapping.path(project.getTestSrc()));
            Plugin bndPlugin = BndProjectMapping.getPlugin((Model)model, (String)"org.eclipse.tycho", (String)TYCHO_BND_PLUGIN);
            bndPlugin.setExtensions(true);
            bndPlugin.setVersion(TychoVersion.getTychoVersion());
            BndProjectMapping.addPluginExecution((Plugin)bndPlugin, execution -> {
                execution.setId("initialize");
                execution.addGoal("initialize");
            });
            BndProjectMapping.addPluginExecution((Plugin)bndPlugin, execution -> {
                execution.setId("clean");
                execution.addGoal("clean");
            });
            BndProjectMapping.addPluginExecution((Plugin)bndPlugin, execution -> {
                execution.setId("compile");
                execution.addGoal("compile");
            });
            BndProjectMapping.addPluginExecution((Plugin)bndPlugin, execution -> {
                execution.setId("testCompile");
                execution.addGoal("test-compile");
            });
            BndProjectMapping.addPluginExecution((Plugin)bndPlugin, execution -> {
                execution.setId("integration-test");
                execution.addGoal("integration-test");
            });
            BndProjectMapping.addPluginExecution((Plugin)bndPlugin, execution -> {
                execution.setId("build");
                execution.addGoal("build");
                execution.addGoal("run");
            });
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                IOException io = (IOException)e;
                throw io;
            }
            if (e instanceof RuntimeException) {
                RuntimeException rt = (RuntimeException)e;
                throw rt;
            }
            throw new IOException(e);
        }
    }

    private static ProjectBuilder createBuilder(Project project) throws Exception {
        JdtProjectBuilder builder = new JdtProjectBuilder(project);
        builder.setBase(project.getBase());
        builder.use((Processor)project);
        builder.setFailOk(true);
        return builder;
    }

    private static String path(File file) throws Exception {
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    protected ParentModel loadParent(Path projectRoot, Path fileOrFolder) throws NoParentPomFound, IOException {
        if (this.isCnfDir(projectRoot)) {
            throw new NoParentPomFound("The workspace configuration folder '" + String.valueOf(projectRoot) + "' can not contain a bnd-project, consider moving it to an own project or place a pom.xml in the config folder to manually configure the maven execution");
        }
        return super.loadParent(projectRoot, fileOrFolder);
    }

    private boolean isCnfDir(Path projectRoot) {
        try {
            Workspace workspace = Workspace.findWorkspace((File)projectRoot.toFile());
            File buildDir = workspace.getBuildDir();
            if (Files.isSameFile(projectRoot, buildDir.toPath())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

