/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.compiler.jdt;

import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.util.Util;

class CompilerMain
extends Main {
    private static final FilenameFilter POTENTIAL_ZIP_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return Util.isPotentialZipArchive((String)name);
        }
    };
    private File javaHome;
    private Logger mavenLogger;
    private String bootclasspathAccessRules;
    private boolean explicitBootClasspath = false;

    public CompilerMain(PrintWriter outWriter, PrintWriter errWriter, boolean systemExitWhenFinished, Logger logger) {
        super(outWriter, errWriter, systemExitWhenFinished);
        this.mavenLogger = logger;
    }

    public void setJavaHome(File javaHome) {
        this.javaHome = javaHome;
        this.mavenLogger.debug("Using javaHome: " + javaHome);
    }

    public void setBootclasspathAccessRules(String accessRules) {
        this.bootclasspathAccessRules = accessRules;
    }

    public File getJavaHome() {
        if (this.javaHome == null) {
            return super.getJavaHome();
        }
        return this.javaHome;
    }

    protected ArrayList handleEndorseddirs(ArrayList endorsedDirClasspaths) {
        if (this.explicitBootClasspath) {
            return new ArrayList();
        }
        if (this.javaHome == null) {
            return super.handleEndorseddirs(endorsedDirClasspaths);
        }
        if (endorsedDirClasspaths == null) {
            endorsedDirClasspaths = new ArrayList(4);
        }
        this.scanForArchives(endorsedDirClasspaths, new File(this.javaHome, "lib/endorsed"));
        this.mavenLogger.debug("Using endorsed dirs: " + endorsedDirClasspaths);
        return endorsedDirClasspaths;
    }

    protected ArrayList handleExtdirs(ArrayList extdirsClasspaths) {
        if (this.explicitBootClasspath) {
            return new ArrayList();
        }
        if (this.javaHome == null) {
            return super.handleExtdirs(extdirsClasspaths);
        }
        if (extdirsClasspaths == null) {
            extdirsClasspaths = new ArrayList(4);
        }
        this.scanForArchives(extdirsClasspaths, new File(this.javaHome, "lib/ext"));
        this.mavenLogger.debug("Using ext dirs: " + extdirsClasspaths);
        return extdirsClasspaths;
    }

    protected ArrayList handleBootclasspath(ArrayList bootclasspaths, String customEncoding) {
        int i;
        String[] paths;
        int bootclasspathsSize;
        if (bootclasspaths != null && (bootclasspathsSize = bootclasspaths.size()) != 0) {
            this.explicitBootClasspath = true;
            paths = new String[bootclasspathsSize];
            bootclasspaths.toArray(paths);
            bootclasspaths.clear();
            for (i = 0; i < bootclasspathsSize; ++i) {
                this.processPathEntries(4, bootclasspaths, paths[i], customEncoding, false, true);
            }
        } else {
            bootclasspaths = new ArrayList(4);
            if (this.javaHome != null) {
                File directoryToCheck = this.isMacOS() && this.hasClassesDirWithJars() ? new File(this.javaHome, "../Classes") : new File(this.javaHome, "lib");
                this.scanForArchives(bootclasspaths, directoryToCheck);
                if (bootclasspaths.isEmpty()) {
                    this.mavenLogger.warn("No classpath entries for boot classpath found scanning java home " + this.javaHome);
                }
            } else {
                try {
                    Util.collectRunningVMBootclasspath(bootclasspaths);
                }
                catch (IllegalStateException e) {
                    this.logger.logWrongJDK();
                    this.proceed = false;
                    return null;
                }
            }
        }
        if (this.bootclasspathAccessRules != null) {
            paths = new String[bootclasspaths.size()];
            for (i = 0; i < bootclasspaths.size(); ++i) {
                paths[i] = ((FileSystem.Classpath)bootclasspaths.get(i)).getPath() + this.bootclasspathAccessRules;
            }
            bootclasspaths.clear();
            for (i = 0; i < paths.length; ++i) {
                this.processPathEntries(4, bootclasspaths, paths[i], customEncoding, false, true);
            }
        }
        this.mavenLogger.debug("Using boot classpath: " + bootclasspaths);
        return bootclasspaths;
    }

    private boolean hasClassesDirWithJars() {
        File classesDir = new File(this.javaHome, "../Classes");
        if (!classesDir.isDirectory()) {
            return false;
        }
        File[] jars = classesDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") && new File(dir, name).isFile();
            }
        });
        return jars != null && jars.length > 0;
    }

    protected boolean isMacOS() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    private void scanForArchives(ArrayList classPathList, File dir) {
        File[] zipFiles;
        if (dir.isDirectory() && (zipFiles = dir.listFiles(POTENTIAL_ZIP_FILTER)) != null) {
            for (File zipFile : zipFiles) {
                classPathList.add(FileSystem.getClasspath((String)zipFile.getAbsolutePath(), null, null));
            }
        }
    }
}

