/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.compiler.jdt;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.tycho.compiler.jdt.CustomCompilerConfiguration;
import org.eclipse.tycho.compiler.jdt.JdkLibraryInfoProvider;
import org.eclipse.tycho.compiler.jdt.copied.LibraryInfo;

@Component(role=Compiler.class, hint="jdt")
public class JDTCompiler
extends AbstractCompiler {
    private static final String SEPARATOR = "----------";
    private static final char[] SEPARATOR_CHARS = new char[]{'/', '\\'};
    private static final char[] ADAPTER_PREFIX = "#ADAPTER#".toCharArray();
    private static final char[] ADAPTER_ENCODING = "ENCODING#".toCharArray();
    private static final char[] ADAPTER_ACCESS = "ACCESS#".toCharArray();
    static final Pattern LINE_PATTERN = Pattern.compile("(?:(\\d*)\\. )?(ERROR|WARNING) in (.*?)( \\(at line (\\d+)\\))?\\s*");
    @Requirement
    private JdkLibraryInfoProvider jdkLibInfoProvider;

    public JDTCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        CompilerResult messages;
        String[] sourceFiles;
        CustomCompilerConfiguration custom = new CustomCompilerConfiguration();
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = JDTCompiler.getSourceFiles((CompilerConfiguration)config)).length == 0) {
            return new CompilerResult();
        }
        this.getLogger().info("Compiling " + sourceFiles.length + " source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        Collection customCompilerArgumentEntries = config.getCustomCompilerArgumentsEntries();
        this.checkCompilerArgs(customCompilerArgumentEntries, custom);
        String[] args = this.buildCompilerArguments(config, custom, sourceFiles);
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty((String)executable)) {
                executable = "javac";
            }
            messages = this.compileOutOfProcess(config.getWorkingDirectory(), executable, args);
        } else {
            messages = this.compileInProcess(args, config, custom);
        }
        return messages;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return this.buildCompilerArguments(config, new CustomCompilerConfiguration(), JDTCompiler.getSourceFiles((CompilerConfiguration)config));
    }

    public String[] buildCompilerArguments(CompilerConfiguration config, CustomCompilerConfiguration custom, String[] sourceFiles) {
        List sourceLocations;
        Object[] annotationProcessors;
        ArrayList<Object> args = new ArrayList<Object>();
        Collection customCompilerArgumentsEntries = config.getCustomCompilerArgumentsEntries();
        for (Map.Entry entry : customCompilerArgumentsEntries) {
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((String)key) || key.startsWith("@")) continue;
            if ("use.java.home".equals(key)) {
                custom.javaHome = (String)entry.getValue();
                continue;
            }
            if ("org.osgi.framework.system.packages".equals(key)) {
                custom.bootclasspathAccessRules = (String)entry.getValue();
                continue;
            }
            args.add(key);
            String value = (String)entry.getValue();
            if (StringUtils.isEmpty((String)value)) continue;
            args.add(value);
        }
        File destinationDir = new File(config.getOutputLocation());
        if (!StringUtils.isEmpty((String)config.getProc())) {
            args.add("-proc:" + config.getProc());
        }
        if ((annotationProcessors = config.getAnnotationProcessors()) != null && annotationProcessors.length > 0) {
            args.add("-processor");
            args.add(StringUtils.join((Object[])annotationProcessors, (String)","));
        }
        if (config.getGeneratedSourcesDirectory() != null) {
            config.getGeneratedSourcesDirectory().mkdirs();
            args.add("-s");
            args.add(config.getGeneratedSourcesDirectory().getAbsolutePath());
        }
        args.add("-d");
        args.add(destinationDir.getAbsolutePath());
        List classpathEntries = config.getClasspathEntries();
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            args.add("-classpath");
            String cp = this.createClasspathArgument(classpathEntries, custom);
            args.add(cp);
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty() && sourceFiles.length == 0) {
            args.add("-sourcepath");
            args.add(JDTCompiler.getPathString((List)sourceLocations));
        }
        args.addAll(Arrays.asList(sourceFiles));
        if (config.isOptimize()) {
            args.add("-O");
        }
        if (config.isDebug()) {
            args.add("-g");
        }
        if (config.isVerbose()) {
            args.add("-verbose");
        }
        if (config.isShowDeprecation()) {
            args.add("-deprecation");
            config.setShowWarnings(true);
        }
        if (!StringUtils.isEmpty((String)config.getMaxmem())) {
            args.add("-J-Xmx" + config.getMaxmem());
        }
        if (!StringUtils.isEmpty((String)config.getMeminitial())) {
            args.add("-J-Xms" + config.getMeminitial());
        }
        if (!config.isShowWarnings()) {
            args.add("-nowarn");
        }
        if (config.isFailOnWarning()) {
            args.add("-failOnWarning");
        }
        if (StringUtils.isEmpty((String)config.getTargetVersion())) {
            args.add("-target");
            args.add("1.1");
        } else {
            args.add("-target");
            args.add(config.getTargetVersion());
        }
        if (!JDTCompiler.suppressSource(config) && StringUtils.isEmpty((String)config.getSourceVersion())) {
            args.add("-source");
            args.add("1.3");
        } else if (!JDTCompiler.suppressSource(config)) {
            args.add("-source");
            args.add(config.getSourceVersion());
        }
        if (!StringUtils.isEmpty((String)config.getReleaseVersion())) {
            args.add("--release");
            args.add(config.getReleaseVersion());
        }
        if (!JDTCompiler.suppressEncoding(config) && !StringUtils.isEmpty((String)config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        return args.toArray(new String[args.size()]);
    }

    private static boolean suppressSource(CompilerConfiguration config) {
        return "1.3".equals(config.getCompilerVersion());
    }

    private static boolean suppressEncoding(CompilerConfiguration config) {
        return "1.3".equals(config.getCompilerVersion());
    }

    CompilerResult compileOutOfProcess(File workingDirectory, String executable, String[] args) throws CompilerException {
        throw new UnsupportedOperationException("compileoutOfProcess not supported");
    }

    CompilerResult compileInProcess(String[] args, CompilerConfiguration config, CustomCompilerConfiguration custom) throws CompilerException {
        List<CompilerMessage> messages;
        String sourceLevel;
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        Main compiler = new Main(new PrintWriter(out), new PrintWriter(err), false, null, null);
        compiler.options.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "error");
        ArrayList<String> jdtCompilerArgs = new ArrayList<String>(Arrays.asList(args));
        if (custom.javaHome != null && ((sourceLevel = config.getSourceVersion()) == null || CompilerOptions.versionToJdkLevel((String)sourceLevel) <= 0x340000L)) {
            this.addExternalJavaHomeArgs(jdtCompilerArgs, custom.javaHome);
        }
        this.getLogger().debug("JDT compiler args: " + jdtCompilerArgs);
        boolean success = compiler.compile(jdtCompilerArgs.toArray(new String[0]));
        try {
            String output = err.toString();
            this.getLogger().debug("Original compiler output: " + output);
            messages = JDTCompiler.parseModernStream(new BufferedReader(new StringReader(output)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!success && messages.isEmpty()) {
            throw new CompilerException(err.toString());
        }
        return new CompilerResult(success, messages);
    }

    private void addExternalJavaHomeArgs(List<String> jdtCompilerArgs, String javaHome) {
        LibraryInfo jdkLibInfo = this.jdkLibInfoProvider.getLibraryInfo(javaHome);
        if (jdkLibInfo.getBootpath().length > 0) {
            this.addToCompilerArgumentsIfNotSet("-bootclasspath", String.join((CharSequence)File.pathSeparator, jdkLibInfo.getBootpath()), jdtCompilerArgs);
        }
        if (jdkLibInfo.getExtensionDirs().length > 0) {
            this.addToCompilerArgumentsIfNotSet("-extdirs", String.join((CharSequence)File.pathSeparator, jdkLibInfo.getExtensionDirs()), jdtCompilerArgs);
        }
        if (jdkLibInfo.getEndorsedDirs().length > 0) {
            this.addToCompilerArgumentsIfNotSet("-endorseddirs", String.join((CharSequence)File.pathSeparator, jdkLibInfo.getEndorsedDirs()), jdtCompilerArgs);
        }
    }

    private void addToCompilerArgumentsIfNotSet(String argument, String value, List<String> compilerArguments) {
        if (compilerArguments.contains(argument)) {
            return;
        }
        compilerArguments.add(argument);
        compilerArguments.add(value);
    }

    protected static List<CompilerMessage> parseModernStream(BufferedReader input) throws IOException {
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        String type = null;
        String file = null;
        int lineNr = -1;
        StringBuilder messageBuffer = new StringBuilder();
        String line = input.readLine();
        while (line != null) {
            Matcher matcher = LINE_PATTERN.matcher(line);
            if (matcher.matches()) {
                JDTCompiler.addMessageIfFound(messages, type, file, lineNr, messageBuffer.toString());
                matcher.group(1);
                type = matcher.group(2);
                file = matcher.group(3);
                String lineNumberString = matcher.group(5);
                lineNr = lineNumberString != null ? Integer.parseInt(lineNumberString) : -1;
                messageBuffer = new StringBuilder();
            } else if (!SEPARATOR.equals(line) && line.trim().length() > 0) {
                messageBuffer.append(EOL).append(line);
            }
            line = input.readLine();
        }
        JDTCompiler.addMessageIfFound(messages, type, file, lineNr, messageBuffer.toString());
        return messages;
    }

    private static void addMessageIfFound(List<CompilerMessage> messages, String type, String file, int line, String message) {
        if (type != null) {
            CompilerMessage.Kind kind = "ERROR".equals(type) ? CompilerMessage.Kind.ERROR : CompilerMessage.Kind.WARNING;
            messages.add(new CompilerMessage(file, kind, line, 0, line, 0, message));
        }
    }

    private String createClasspathArgument(List<String> classpath, CustomCompilerConfiguration custom) {
        String[] pathElements = classpath.toArray(new String[classpath.size()]);
        if (pathElements.length == 0) {
            return "";
        }
        if (custom.accessRules == null) {
            return Stream.of(pathElements).collect(Collectors.joining(File.pathSeparator));
        }
        int rulesLength = custom.accessRules.size();
        String[] rules = custom.accessRules.toArray(new String[rulesLength]);
        int nextRule = 0;
        StringJoiner result = new StringJoiner(File.pathSeparator);
        block0: for (String pathElement : pathElements) {
            result.add(pathElement);
            for (int j = nextRule; j < rulesLength; j += 2) {
                int ruleLength;
                String rule = rules[j];
                if (pathElement.endsWith(rule)) {
                    result.add(rules[j + 1]);
                    nextRule = j + 2;
                    continue block0;
                }
                if (rule.endsWith(File.separator)) {
                    ruleLength = rule.length();
                    if (!pathElement.regionMatches(false, pathElement.length() - ruleLength + 1, rule, 0, ruleLength - 1)) continue;
                    result.add(rules[j + 1]);
                    nextRule = j + 2;
                    continue block0;
                }
                if (!pathElement.endsWith(File.separator)) continue;
                ruleLength = rule.length();
                if (!pathElement.regionMatches(false, pathElement.length() - ruleLength - 1, rule, 0, ruleLength)) continue;
                result.add(rules[j + 1]);
                nextRule = j + 2;
                continue block0;
            }
        }
        return result.toString();
    }

    private void checkCompilerArgs(Collection<Map.Entry<String, String>> argEntries, CustomCompilerConfiguration custom) {
        for (Map.Entry<String, String> argEntry : argEntries) {
            String arg = argEntry.getKey();
            if (arg.charAt(0) != '@') continue;
            try {
                char[] content = Util.getFileCharContent((File)new File(arg.substring(1)), null);
                int offset = 0;
                int prefixLength = ADAPTER_PREFIX.length;
                while ((offset = CharOperation.indexOf((char[])ADAPTER_PREFIX, (char[])content, (boolean)true, (int)offset)) > -1) {
                    int accessStart;
                    int start = offset + prefixLength;
                    int end = CharOperation.indexOf((char)'\n', (char[])content, (int)start);
                    if (end == -1) {
                        end = content.length;
                    }
                    while (CharOperation.isWhitespace((char)content[end])) {
                        --end;
                    }
                    if (CharOperation.equals((char[])ADAPTER_ENCODING, (char[])content, (int)start, (int)(start + ADAPTER_ENCODING.length))) {
                        CharOperation.replace((char[])content, (char[])SEPARATOR_CHARS, (char)File.separatorChar, (int)start, (int)(end + 1));
                        int encodeStart = CharOperation.lastIndexOf((char)'[', (char[])content, (int)(start += ADAPTER_ENCODING.length), (int)end);
                        if (start < encodeStart && encodeStart < end) {
                            boolean isFile = CharOperation.equals((char[])SuffixConstants.SUFFIX_java, (char[])content, (int)(encodeStart - 5), (int)encodeStart, (boolean)false);
                            String str = String.valueOf(content, start, encodeStart - start);
                            String enc = String.valueOf(content, encodeStart, end - encodeStart + 1);
                            if (isFile) {
                                if (custom.fileEncodings == null) {
                                    custom.fileEncodings = new HashMap<String, String>();
                                }
                                custom.fileEncodings.put(str, enc);
                            } else {
                                if (custom.dirEncodings == null) {
                                    custom.dirEncodings = new HashMap<String, String>();
                                }
                                custom.dirEncodings.put(str, enc);
                            }
                        }
                    } else if (CharOperation.equals((char[])ADAPTER_ACCESS, (char[])content, (int)start, (int)(start + ADAPTER_ACCESS.length)) && (start += ADAPTER_ACCESS.length) < (accessStart = CharOperation.indexOf((char)'[', (char[])content, (int)start, (int)end)) && accessStart < end) {
                        String path = String.valueOf(content, start, accessStart - start);
                        String access = String.valueOf(content, accessStart, end - accessStart + 1);
                        if (custom.accessRules == null) {
                            custom.accessRules = new ArrayList<String>();
                        }
                        custom.accessRules.add(path);
                        custom.accessRules.add(access);
                    }
                    offset = end;
                }
            }
            catch (IOException iOException) {
            }
        }
    }
}

