/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.compiler;

import copied.org.apache.maven.plugin.AbstractCompilerMojo;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.jdt.internal.compiler.util.CtSym;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.eclipse.tycho.classpath.JavaCompilerConfiguration;
import org.eclipse.tycho.classpath.SourcepathEntry;
import org.eclipse.tycho.compiler.CopyMapping;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentUtils;
import org.eclipse.tycho.core.ee.StandardExecutionEnvironment;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironment;
import org.eclipse.tycho.core.maven.ToolchainProvider;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultClasspathEntry;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.osgitools.OsgiBundleProject;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.core.osgitools.project.BuildOutputJar;
import org.eclipse.tycho.core.osgitools.project.EclipsePluginProject;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.runtime.Adaptable;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public abstract class AbstractOsgiCompilerMojo
extends AbstractCompilerMojo
implements JavaCompilerConfiguration,
Adaptable {
    public static final String RULE_SEPARATOR = File.pathSeparator;
    public static final String RULE_EXCLUDE_ALL = "?**/*";
    private static final Object LOCK = new Object();
    private static final Set<String> MATCH_ALL = Collections.singleton("**/*");
    private static final String PREFS_FILE_PATH = ".settings" + File.separator + "org.eclipse.jdt.core.prefs";
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter
    private Dependency[] extraClasspathElements;
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="SYSTEM")
    private ToolchainProvider.JDKUsage useJDK;
    @Component
    private ToolchainManagerPrivate toolChainManager;
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private Set<String> excludes = new HashSet<String>();
    @Parameter
    private Set<String> excludeResources = new HashSet<String>();
    @Parameter(defaultValue="false")
    private boolean requireJREPackageImports;
    @Parameter(defaultValue="false")
    private boolean strictCompilerTarget;
    @Parameter(defaultValue="true")
    private boolean useProjectSettings;
    @Parameter(defaultValue="true")
    private boolean deriveReleaseCompilerArgumentFromTargetLevel = true;
    private BuildOutputJar outputJar;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Component
    private BundleReader bundleReader;
    @Parameter(defaultValue="true")
    private boolean copyResources;
    @Parameter(defaultValue="${project.build.directory}/compile-logs")
    private File logDirectory;
    @Parameter
    private String log;
    @Component
    ToolchainProvider toolchainProvider;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private Logger logger;
    private StandardExecutionEnvironment[] manifestBREEs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Manifest BREEs: " + Arrays.toString(this.getBREE())));
        this.getLog().debug((CharSequence)("Target Platform EE: " + this.getTargetExecutionEnvironment()));
        String effectiveTargetLevel = this.getTargetLevel();
        this.getLog().debug((CharSequence)("Effective source/target: " + this.getSourceLevel() + "/" + effectiveTargetLevel));
        this.checkTargetLevelCompatibleWithManifestBREEs(effectiveTargetLevel, this.manifestBREEs);
        Object object = LOCK;
        synchronized (object) {
            Iterator iterator = this.getEclipsePluginProject().getOutputJars().iterator();
            while (iterator.hasNext()) {
                BuildOutputJar jar;
                this.outputJar = jar = (BuildOutputJar)iterator.next();
                this.outputJar.getOutputDirectory().mkdirs();
                super.execute();
                this.doCopyResources();
            }
            BuildOutputJar dotOutputJar = this.getEclipsePluginProject().getDotOutputJar();
            if (dotOutputJar != null) {
                this.project.getArtifact().setFile(dotOutputJar.getOutputDirectory());
            }
        }
    }

    public StandardExecutionEnvironment[] getBREE() {
        if (this.manifestBREEs == null) {
            ManifestElement[] requireCapability;
            OsgiManifest manifest = this.bundleReader.loadManifest(this.project.getBasedir());
            this.manifestBREEs = (StandardExecutionEnvironment[])Arrays.stream(manifest.getExecutionEnvironments()).map(ee -> ExecutionEnvironmentUtils.getExecutionEnvironment((String)ee, (ToolchainManager)this.toolchainManager, (MavenSession)this.session, (Logger)this.logger)).toArray(StandardExecutionEnvironment[]::new);
            if (this.manifestBREEs.length == 0 && (requireCapability = manifest.getManifestElements("Require-Capability")) != null) {
                List eeFilters = Arrays.stream(requireCapability).filter(element -> "osgi.ee".equals(element.getValue())).map(element -> element.getDirective("filter")).map(filterDirective -> {
                    try {
                        return FrameworkUtil.createFilter((String)filterDirective);
                    }
                    catch (InvalidSyntaxException e) {
                        e.printStackTrace();
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                this.manifestBREEs = (StandardExecutionEnvironment[])ExecutionEnvironmentUtils.getProfileNames().stream().map(name -> name.split("-")).map(segments -> Map.of("osgi.ee", segments[0], "version", segments[1])).filter(eeCapability -> eeFilters.stream().anyMatch(filter -> filter.matches(eeCapability))).map(ee -> (String)ee.get("osgi.ee") + "-" + (String)ee.get("version")).map(ee -> ExecutionEnvironmentUtils.getExecutionEnvironment((String)ee, (ToolchainManager)this.toolchainManager, (MavenSession)this.session, (Logger)this.logger)).toArray(StandardExecutionEnvironment[]::new);
            }
        }
        return this.manifestBREEs;
    }

    private void doCopyResources() throws MojoExecutionException {
        if (!this.copyResources) {
            return;
        }
        for (String sourceRoot : this.getCompileSourceRoots()) {
            File sourceRootFile = new File(sourceRoot);
            if (!sourceRootFile.isDirectory()) {
                this.getLog().warn((CharSequence)("Source directory " + sourceRoot + " does not exist"));
                continue;
            }
            HashSet<String> excludes = new HashSet<String>();
            excludes.addAll(this.excludeResources);
            excludes.addAll(this.getCompileSourceExcludePaths());
            excludes.addAll(this.getEclipsePluginProject().getBuildProperties().getBinExcludes());
            excludes.add("**/*.java");
            StaleSourceScanner scanner = new StaleSourceScanner(0L, MATCH_ALL, excludes);
            CopyMapping copyMapping = new CopyMapping();
            scanner.addSourceMapping((SourceMapping)copyMapping);
            try {
                scanner.getIncludedSources(sourceRootFile, this.outputJar.getOutputDirectory());
                for (CopyMapping.SourceTargetPair sourceTargetPair : copyMapping.getSourceTargetPairs()) {
                    FileUtils.copyFile((File)new File(sourceRoot, sourceTargetPair.source), (File)sourceTargetPair.target);
                }
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Exception while scanning for resource files in " + sourceRoot, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception copying resource files from " + sourceRoot + " to " + this.outputJar.getOutputDirectory(), (Exception)e);
            }
        }
    }

    public EclipsePluginProject getEclipsePluginProject() throws MojoExecutionException {
        return ((OsgiBundleProject)this.getBundleProject()).getEclipsePluginProject(DefaultReactorProject.adapt((MavenProject)this.project));
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputJar.getOutputDirectory();
    }

    @Override
    public List<String> getClasspathElements() throws MojoExecutionException {
        ArrayList<String> classpath = new ArrayList<String>();
        for (ClasspathEntry cpe : this.getClasspath()) {
            for (File location : cpe.getLocations()) {
                classpath.add(location.getAbsolutePath() + this.toString(cpe.getAccessRules()));
            }
        }
        return classpath;
    }

    private BundleProject getBundleProject() throws MojoExecutionException {
        TychoProject projectType = this.projectTypes.get(this.project.getPackaging());
        if (!(projectType instanceof BundleProject)) {
            throw new MojoExecutionException("Not a bundle project " + this.project.toString());
        }
        return (BundleProject)projectType;
    }

    private String toString(Collection<ClasspathEntry.AccessRule> rules) {
        StringBuilder result = new StringBuilder();
        if (rules != null) {
            result.append("[");
            for (ClasspathEntry.AccessRule rule : rules) {
                if (result.length() > 1) {
                    result.append(RULE_SEPARATOR);
                }
                result.append(rule.isDiscouraged() ? "~" : "+");
                result.append(rule.getPattern());
            }
            if (result.length() > 1) {
                result.append(RULE_SEPARATOR);
            }
            result.append(RULE_EXCLUDE_ALL);
            result.append("]");
        }
        return result.toString();
    }

    @Override
    protected final List<String> getCompileSourceRoots() throws MojoExecutionException {
        ArrayList<String> roots = new ArrayList<String>();
        for (File folder : this.outputJar.getSourceFolders()) {
            roots.add(new File(folder.getAbsoluteFile().toURI().normalize()).toString());
        }
        return roots;
    }

    @Override
    protected final List<String> getCompileSourceExcludePaths() throws MojoExecutionException {
        return Collections.unmodifiableList(this.outputJar.getFilesToExclude());
    }

    public List<SourcepathEntry> getSourcepath() throws MojoExecutionException {
        ArrayList<SourcepathEntry> entries = new ArrayList<SourcepathEntry>();
        for (BuildOutputJar jar : this.getEclipsePluginProject().getOutputJars()) {
            final File outputDirectory = jar.getOutputDirectory();
            for (final File sourcesRoot : jar.getSourceFolders()) {
                SourcepathEntry entry = new SourcepathEntry(){

                    public File getSourcesRoot() {
                        return sourcesRoot;
                    }

                    public File getOutputDirectory() {
                        return outputDirectory;
                    }

                    public List<String> getIncludes() {
                        return null;
                    }

                    public List<String> getExcludes() {
                        return null;
                    }
                };
                entries.add(entry);
            }
        }
        return entries;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.includes, this.excludes);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            this.includes = Collections.singleton("**/*." + inputFileEnding);
            scanner = new SimpleSourceInclusionScanner(this.includes, Collections.emptySet());
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*." + inputFileEnding);
            }
            scanner = new SimpleSourceInclusionScanner(this.includes, this.excludes);
        }
        return scanner;
    }

    @Override
    protected CompilerConfiguration getCompilerConfiguration(List<String> compileSourceRoots, List<String> compileSourceExcludes) throws MojoExecutionException, MojoFailureException {
        String encoding;
        CompilerConfiguration compilerConfiguration = super.getCompilerConfiguration(compileSourceRoots, compileSourceExcludes);
        if (this.useProjectSettings) {
            String prefsFilePath = this.project.getBasedir() + File.separator + PREFS_FILE_PATH;
            if (!new File(prefsFilePath).exists()) {
                this.getLog().warn((CharSequence)("Parameter 'useProjectSettings' is set to true, but preferences file '" + prefsFilePath + "' could not be found!"));
            } else {
                compilerConfiguration.addCompilerCustomArgument("-properties", prefsFilePath);
            }
        }
        if ((encoding = (String)this.getEclipsePluginProject().getBuildProperties().getJarToJavacDefaultEncodingMap().get(this.outputJar.getName())) != null) {
            compilerConfiguration.setSourceEncoding(encoding);
        }
        compilerConfiguration.setTargetVersion(this.getTargetLevel());
        compilerConfiguration.setSourceVersion(this.getSourceLevel());
        String releaseLevel = this.getReleaseLevel();
        if (releaseLevel != null) {
            compilerConfiguration.setReleaseVersion(releaseLevel);
        }
        this.configureJavaHome(compilerConfiguration);
        this.configureBootclasspathAccessRules(compilerConfiguration);
        this.configureCompilerLog(compilerConfiguration);
        return compilerConfiguration;
    }

    private void configureCompilerLog(CompilerConfiguration compilerConfiguration) throws MojoFailureException {
        if (this.log == null) {
            return;
        }
        if (compilerConfiguration.getCustomCompilerArgumentsAsMap().containsKey("-log")) {
            throw new MojoFailureException("Compiler logging is configured by the 'log' compiler plugin parameter and the custom compiler argument '-log'. Only either of them is allowed.");
        }
        this.logDirectory.mkdirs();
        String logFileName = null;
        logFileName = ".".equals(this.outputJar.getName()) ? "@dot" : this.outputJar.getName().replaceAll("/", "_");
        Object logPath = this.logDirectory.getAbsolutePath();
        if (!((String)logPath).endsWith(File.separator)) {
            logPath = (String)logPath + File.separator;
        }
        String fileExtension = this.log;
        if ("plain".equals(this.log)) {
            fileExtension = "log";
        }
        logPath = (String)logPath + logFileName + "." + fileExtension;
        compilerConfiguration.addCompilerCustomArgument("-log", (String)logPath);
    }

    private void configureBootclasspathAccessRules(CompilerConfiguration compilerConfiguration) throws MojoExecutionException {
        ArrayList<ClasspathEntry.AccessRule> accessRules = new ArrayList<ClasspathEntry.AccessRule>();
        if (this.requireJREPackageImports) {
            accessRules.addAll(this.getStrictBootClasspathAccessRules());
        } else {
            accessRules.add((ClasspathEntry.AccessRule)new DefaultClasspathEntry.DefaultAccessRule("java/**", false));
            this.getTargetExecutionEnvironment().getSystemPackages().stream().map(systemPackage -> systemPackage.packageName).distinct().map(packageName -> packageName.trim().replace('.', '/') + "/*").map(accessRule -> new DefaultClasspathEntry.DefaultAccessRule(accessRule, false)).forEach(accessRules::add);
            accessRules.addAll(this.getBundleProject().getBootClasspathExtraAccessRules(DefaultReactorProject.adapt((MavenProject)this.project)));
        }
        if (!accessRules.isEmpty()) {
            compilerConfiguration.addCompilerCustomArgument("org.osgi.framework.system.packages", this.toString(accessRules));
        }
    }

    private List<ClasspathEntry.AccessRule> getStrictBootClasspathAccessRules() throws MojoExecutionException {
        return (List)DefaultReactorProject.adapt((MavenProject)this.project).getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_STRICT_BOOTCLASSPATH_ACCESSRULES);
    }

    private void configureJavaHome(CompilerConfiguration compilerConfiguration) throws MojoExecutionException {
        if (this.useJDK != ToolchainProvider.JDKUsage.BREE) {
            return;
        }
        StandardExecutionEnvironment[] brees = this.getBREE();
        String toolchainId = null;
        if (brees.length > 0) {
            toolchainId = brees[0].getProfileName();
        } else {
            this.getLog().warn((CharSequence)("useJDK=BREE configured, but no BREE is set in bundle. Fail back to currently running execution environment (" + this.getTargetExecutionEnvironment().getProfileName() + ")."));
            toolchainId = this.getTargetExecutionEnvironment().getProfileName();
        }
        DefaultJavaToolChain toolChain = this.toolchainProvider.findMatchingJavaToolChain(this.session, toolchainId);
        if (toolChain == null) {
            throw new MojoExecutionException("useJDK = BREE configured, but no toolchain of type 'jdk' with id '" + toolchainId + "' found. See http://maven.apache.org/guides/mini/guide-using-toolchains.html");
        }
        compilerConfiguration.addCompilerCustomArgument("use.java.home", toolChain.getJavaHome());
        this.configureBootClassPath(compilerConfiguration, toolChain);
    }

    private void configureBootClassPath(CompilerConfiguration compilerConfiguration, DefaultJavaToolChain javaToolChain) {
        Xpp3Dom[] includes;
        Xpp3Dom includeParent;
        Xpp3Dom bootClassPath;
        Xpp3Dom config = (Xpp3Dom)javaToolChain.getModel().getConfiguration();
        if (config != null && (bootClassPath = config.getChild("bootClassPath")) != null && (includeParent = bootClassPath.getChild("includes")) != null && (includes = includeParent.getChildren("include")).length > 0) {
            compilerConfiguration.addCompilerCustomArgument("-bootclasspath", this.scanBootclasspath(javaToolChain.getJavaHome(), includes, bootClassPath.getChild("excludes")));
        }
    }

    private String scanBootclasspath(String javaHome, Xpp3Dom[] includes, Xpp3Dom excludeParent) {
        Xpp3Dom[] excludes;
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(javaHome);
        scanner.setIncludes(AbstractOsgiCompilerMojo.getValues(includes));
        if (excludeParent != null && (excludes = excludeParent.getChildren("exclude")).length > 0) {
            scanner.setExcludes(AbstractOsgiCompilerMojo.getValues(excludes));
        }
        scanner.scan();
        StringBuilder bootClassPath = new StringBuilder();
        String[] includedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            if (i > 0) {
                bootClassPath.append(File.pathSeparator);
            }
            bootClassPath.append(new File(javaHome, includedFiles[i]).getAbsolutePath());
        }
        return bootClassPath.toString();
    }

    private static String[] getValues(Xpp3Dom[] doms) {
        String[] values = new String[doms.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = doms[i].getValue();
        }
        return values;
    }

    private ExecutionEnvironment getTargetExecutionEnvironment() {
        return TychoProjectUtils.getExecutionEnvironmentConfiguration((ReactorProject)DefaultReactorProject.adapt((MavenProject)this.project)).getFullSpecification();
    }

    public List<ClasspathEntry> getClasspath() throws MojoExecutionException {
        BundleProject projectType = this.getBundleProject();
        ArrayList<ClasspathEntry> classpath = new ArrayList<ClasspathEntry>(projectType.getClasspath(DefaultReactorProject.adapt((MavenProject)this.project)));
        if (this.extraClasspathElements != null) {
            ArtifactRepository localRepository = this.session.getLocalRepository();
            List remoteRepositories = this.project.getRemoteArtifactRepositories();
            for (Dependency extraDependency : this.extraClasspathElements) {
                Artifact artifact = this.repositorySystem.createDependencyArtifact(extraDependency);
                ArtifactResolutionRequest request = new ArtifactResolutionRequest();
                request.setArtifact(artifact);
                request.setLocalRepository(localRepository);
                request.setRemoteRepositories(remoteRepositories);
                request.setResolveRoot(true);
                request.setResolveTransitively(true);
                ArtifactResolutionResult result = this.repositorySystem.resolve(request);
                if (result.hasExceptions()) {
                    throw new MojoExecutionException("Could not resolve extra classpath entry", (Exception)result.getExceptions().get(0));
                }
                for (Artifact b : result.getArtifacts()) {
                    MavenProject bProject = null;
                    if (b instanceof ProjectArtifact) {
                        bProject = ((ProjectArtifact)b).getProject();
                    }
                    ArrayList<File> bLocations = new ArrayList<File>();
                    bLocations.add(b.getFile());
                    classpath.add((ClasspathEntry)new DefaultClasspathEntry(DefaultReactorProject.adapt((MavenProject)bProject), null, bLocations, null));
                }
            }
        }
        return classpath;
    }

    public String getExecutionEnvironment() throws MojoExecutionException {
        return this.getTargetExecutionEnvironment().getProfileName();
    }

    public String getSourceLevel() throws MojoExecutionException {
        if (this.source != null) {
            return this.source;
        }
        String javacSource = this.getEclipsePluginProject().getBuildProperties().getJavacSource();
        if (javacSource != null) {
            return javacSource;
        }
        String profileName = this.getEclipsePluginProject().getBuildProperties().getJreCompilationProfile();
        if (profileName != null) {
            return ExecutionEnvironmentUtils.getExecutionEnvironment((String)profileName, (ToolchainManager)this.toolchainManager, (MavenSession)this.session, (Logger)this.logger).getCompilerSourceLevelDefault();
        }
        return Arrays.stream(this.getBREE()).map(ExecutionEnvironment::getCompilerSourceLevelDefault).filter(Objects::nonNull).min(Comparator.comparing(Version::parseVersion)).or(() -> Optional.ofNullable(this.getTargetExecutionEnvironment().getCompilerSourceLevelDefault())).orElse("11");
    }

    public String getTargetLevel() throws MojoExecutionException {
        if (this.target != null) {
            return this.target;
        }
        String javacTarget = this.getEclipsePluginProject().getBuildProperties().getJavacTarget();
        if (javacTarget != null) {
            return javacTarget;
        }
        String profileName = this.getEclipsePluginProject().getBuildProperties().getJreCompilationProfile();
        if (profileName != null) {
            return ExecutionEnvironmentUtils.getExecutionEnvironment((String)profileName, (ToolchainManager)this.toolchainManager, (MavenSession)this.session, (Logger)this.logger).getCompilerTargetLevelDefault();
        }
        return Arrays.stream(this.getBREE()).map(ExecutionEnvironment::getCompilerTargetLevelDefault).filter(Objects::nonNull).min(Comparator.comparing(Version::parseVersion)).or(() -> Optional.ofNullable(this.getTargetExecutionEnvironment().getCompilerTargetLevelDefault())).orElse("11");
    }

    public String getReleaseLevel() throws MojoExecutionException {
        CtSym ctSym;
        String releaseLevel;
        if (this.release != null) {
            return this.release;
        }
        if (!this.deriveReleaseCompilerArgumentFromTargetLevel) {
            return null;
        }
        String targetLevel = this.getTargetLevel();
        String[] targetLevelSplit = targetLevel.split("\\.");
        if (targetLevelSplit.length == 1 && targetLevelSplit[0].matches("\\d+")) {
            releaseLevel = targetLevelSplit[0];
        } else if (targetLevelSplit.length == 2 && "1".equals(targetLevelSplit[0]) && targetLevelSplit[1].matches("\\d+")) {
            releaseLevel = targetLevelSplit[1];
        } else {
            this.logger.debug("Cannot determining 'maven.compiler.release' property automatically, because target level '" + targetLevel + "' has an unexpected format.");
            return null;
        }
        try {
            ctSym = JRTUtil.getCtSym((Path)Paths.get(System.getProperty("java.home"), new String[0]));
        }
        catch (IOException e) {
            this.logger.warn("Unable to determine 'maven.compiler.release' property automatically", (Throwable)e);
            return null;
        }
        int releaseLevelInt = Integer.parseInt(releaseLevel);
        String releaseCode = releaseLevelInt < 10 ? releaseLevel : String.valueOf((char)(65 + (releaseLevelInt - 10)));
        List releaseRoots = ctSym.releaseRoots(releaseCode);
        if (!releaseRoots.isEmpty()) {
            return releaseLevel;
        }
        this.logger.debug("Not determining 'maven.compiler.release' property automatically, because level '" + releaseLevel + "' is not supported by compiler.");
        return null;
    }

    private void checkTargetLevelCompatibleWithManifestBREEs(String effectiveTargetLevel, StandardExecutionEnvironment[] manifestBREEs) throws MojoExecutionException {
        ArrayList<CallSite> incompatibleBREEs = new ArrayList<CallSite>();
        for (StandardExecutionEnvironment ee : manifestBREEs) {
            if (ee.isCompatibleCompilerTargetLevel(effectiveTargetLevel)) continue;
            incompatibleBREEs.add((CallSite)((Object)(ee.getProfileName() + " (assumes " + ee.getCompilerTargetLevelDefault() + ")")));
        }
        if (!incompatibleBREEs.isEmpty()) {
            String message = "The effective compiler target level " + effectiveTargetLevel + " is incompatible with the following OSGi execution environments: " + incompatibleBREEs + " @ " + this.project;
            if (this.strictCompilerTarget) {
                throw new MojoExecutionException(message);
            }
            this.getLog().warn((CharSequence)message);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(JavaCompilerConfiguration.class)) {
            return adapter.cast((Object)this);
        }
        return null;
    }
}

