/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipsebuild;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tycho.eclipsebuild.EclipseBuildResult;

public class EclipseBuild
implements Callable<EclipseBuildResult>,
Serializable {
    private boolean debug;
    private String baseDir;

    EclipseBuild(Path projectDir, boolean debug) {
        this.debug = debug;
        this.baseDir = EclipseBuild.pathAsString(projectDir);
    }

    @Override
    public EclipseBuildResult call() throws Exception {
        EclipseBuildResult result = new EclipseBuildResult();
        Platform.addLogListener((status, plugin) -> this.debug(status.toString()));
        EclipseBuild.disableAutoBuild();
        this.deleteAllProjects();
        IProject project = this.importProject();
        IProgressMonitor debugMonitor = new IProgressMonitor(){

            public void worked(int work) {
            }

            public void subTask(String name) {
                EclipseBuild.this.debug("SubTask: " + name);
            }

            public void setTaskName(String name) {
                EclipseBuild.this.debug("Task: " + name);
            }

            public void setCanceled(boolean value) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void internalWorked(double work) {
            }

            public void done() {
            }

            public void beginTask(String name, int totalWork) {
                this.setTaskName(name);
            }
        };
        project.build(15, debugMonitor);
        project.build(6, debugMonitor);
        for (IMarker marker : project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2)) {
            result.addMarker(marker);
            this.debug(marker.toString());
        }
        ResourcesPlugin.getWorkspace().save(true, (IProgressMonitor)new NullProgressMonitor());
        return result;
    }

    static void disableAutoBuild() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(false);
        workspace.setDescription(desc);
    }

    private void deleteAllProjects() throws CoreException {
        for (IProject project : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            project.delete(9, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private IProject importProject() throws CoreException, IOException {
        IPath projectPath = IPath.fromOSString((String)this.baseDir);
        IPath projectDescriptionFile = projectPath.append(".project");
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().loadProjectDescription(projectDescriptionFile);
        projectDescription.setLocation(projectPath);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectDescription.getName());
        project.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
        project.open((IProgressMonitor)new NullProgressMonitor());
        return project;
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    static String pathAsString(Path path) {
        if (path != null) {
            return path.toAbsolutePath().toString();
        }
        return null;
    }
}

