/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipsebuild;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DependencyResolutionException;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.eclipsebuild.AbstractEclipseBuild;
import org.eclipse.tycho.eclipsebuild.EclipseBuildResult;
import org.eclipse.tycho.eclipsebuild.SetApiBaseline;
import org.eclipse.tycho.eclipsebuild.SetJVMs;
import org.eclipse.tycho.eclipsebuild.SetTargetPlatform;
import org.eclipse.tycho.model.project.EclipseProject;
import org.eclipse.tycho.osgi.framework.Bundles;
import org.eclipse.tycho.osgi.framework.EclipseApplication;
import org.eclipse.tycho.osgi.framework.EclipseApplicationFactory;
import org.eclipse.tycho.osgi.framework.EclipseApplicationManager;
import org.eclipse.tycho.osgi.framework.EclipseFramework;
import org.eclipse.tycho.osgi.framework.EclipseWorkspaceManager;
import org.eclipse.tycho.osgi.framework.Features;
import org.osgi.framework.BundleException;

public abstract class AbstractEclipseBuildMojo<Result extends EclipseBuildResult>
extends AbstractMojo {
    static final String PARAMETER_LOCAL = "local";
    @Parameter
    private Repository eclipseRepository;
    @Parameter(property="baselines", name="baselines")
    private List<Repository> baselines;
    @Parameter(defaultValue="false", property="tycho.eclipsebuild.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="tycho.eclipsebuild.debug")
    protected boolean debug;
    @Parameter(defaultValue="false")
    private boolean failOnResolutionError;
    @Parameter(property="tycho.eclipsebuild.application")
    private String application;
    @Parameter(defaultValue="false", property="tycho.eclipsebuild.local", name="local")
    private boolean local;
    @Parameter(defaultValue="true", property="tycho.eclipsebuild.printMarker")
    private boolean printMarker;
    @Parameter
    private List<String> bundles;
    @Parameter
    private List<String> features;
    @Parameter(property="project", readonly=true)
    protected MavenProject project;
    @Component
    protected MavenSession mavenSession;
    @Component
    private EclipseWorkspaceManager workspaceManager;
    @Component
    private EclipseApplicationManager eclipseApplicationManager;
    @Component
    private EclipseApplicationFactory applicationFactory;
    @Component
    private TychoProjectManager projectManager;
    @Component
    ToolchainManager toolchainManager;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        EclipseApplication application;
        Collection projectDependencies;
        Optional eclipseProjectValue = this.projectManager.getEclipseProject(this.project);
        if (eclipseProjectValue.isEmpty()) {
            return;
        }
        EclipseProject eclipseProject = (EclipseProject)eclipseProjectValue.get();
        if (!this.isValid(eclipseProject)) {
            return;
        }
        try {
            projectDependencies = this.projectManager.getProjectDependencies(this.project);
        }
        catch (Exception e) {
            throw new MojoFailureException("Can't resolve project dependencies", (Throwable)e);
        }
        Bundles bundles = new Bundles(this.getBundles(eclipseProject));
        Features features = new Features(this.getFeatures());
        if (this.local) {
            TargetPlatform targetPlatform = (TargetPlatform)this.projectManager.getTargetPlatform(this.project).orElseThrow(() -> new MojoFailureException("Can't get target platform for project " + this.project.getId()));
            application = this.eclipseApplicationManager.getApplication(targetPlatform, bundles, features, this.getName());
        } else {
            application = this.eclipseApplicationManager.getApplication(this.eclipseRepository, bundles, features, this.getName());
        }
        final String applicationName = this.application;
        boolean useApplication = applicationName != null && !applicationName.isBlank();
        List<Object> arguments = useApplication ? List.of("-application", applicationName) : List.of();
        try (final EclipseFramework framework = application.startFramework(this.workspaceManager.getWorkspace(EclipseApplicationManager.getRepository((Repository)this.eclipseRepository).getURL(), (Mojo)this), arguments);){
            if (this.debug) {
                framework.printState();
            }
            if (useApplication) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            framework.start();
                        }
                        catch (Exception e) {
                            AbstractEclipseBuildMojo.this.getLog().error((CharSequence)("Running application " + applicationName + " failed"), (Throwable)e);
                        }
                    }
                });
                thread.setName(this.getName() + " Application Thread");
                thread.start();
                framework.waitForApplicationStart(TimeUnit.SECONDS.toMillis(30L));
            }
            if (this.hasJDTNature(eclipseProject)) {
                if (framework.hasBundle("org.eclipse.jdt.launching")) {
                    ArrayList<Path> jvms = new ArrayList<Path>();
                    for (Toolchain toolchain : this.toolchainManager.getToolchains(this.mavenSession, "jdk", Map.of())) {
                        String tool = toolchain.findTool("java");
                        if (tool == null) continue;
                        jvms.add(Path.of(tool, new String[0]).getParent().getParent());
                    }
                    framework.execute((Callable)new SetJVMs(jvms, this.debug), new String[0]);
                } else {
                    this.getLog().info((CharSequence)"Skip set JVMs because org.eclipse.jdt.launching is not part of the framework...");
                }
            }
            if (this.hasPDENature(eclipseProject)) {
                if (framework.hasBundle("org.eclipse.pde.core")) {
                    framework.execute((Callable)new SetTargetPlatform(projectDependencies, this.debug), new String[0]);
                } else {
                    this.getLog().info((CharSequence)"Skip set Target Platform because org.eclipse.pde.core is not part of the framework...");
                }
            }
            if (this.hasAPIToolsNature(eclipseProject)) {
                if (framework.hasBundle("org.eclipse.pde.api.tools")) {
                    if (this.hasBaselinesSet()) {
                        framework.execute((Callable)new SetApiBaseline(this.project.getId(), this.getBaselineBundles(), this.debug), new String[0]);
                    } else {
                        this.getLog().info((CharSequence)"Skip set ApiBaseline because no baselines set...");
                    }
                } else {
                    this.getLog().info((CharSequence)"Skip set ApiBasline because org.eclipse.pde.api.tools is not part of the framework...");
                }
            }
            EclipseBuildResult result = (EclipseBuildResult)framework.execute(this.createExecutable(), this.getRequireBundles());
            if (this.printMarker) {
                Log log = this.getLog();
                result.markers().filter(marker -> marker.getAttribute("severity", -1) == 0).forEach(info -> AbstractEclipseBuildMojo.printMarker(info, result, arg_0 -> ((Log)log).info(arg_0)));
                result.markers().filter(marker -> marker.getAttribute("severity", -1) == 1).forEach(warn -> AbstractEclipseBuildMojo.printMarker(warn, result, arg_0 -> ((Log)log).warn(arg_0)));
                result.markers().filter(marker -> marker.getAttribute("severity", -1) == 2).forEach(error -> AbstractEclipseBuildMojo.printMarker(error, result, arg_0 -> ((Log)log).error(arg_0)));
            }
            this.handleResult(result);
        }
        catch (BundleException e) {
            throw new MojoFailureException("Can't start framework!", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause.getClass().getName().equals(CoreException.class.getName())) {
                throw new MojoFailureException(cause.getMessage(), cause);
            }
            throw new MojoExecutionException(cause);
        }
    }

    protected boolean isValid(EclipseProject eclipseProject) {
        return true;
    }

    protected abstract void handleResult(Result var1) throws MojoFailureException;

    protected abstract AbstractEclipseBuild<Result> createExecutable();

    protected String[] getRequireBundles() {
        return new String[0];
    }

    protected Set<String> getFeatures() {
        HashSet<String> set = new HashSet<String>();
        if (this.features != null) {
            set.addAll(this.features);
        }
        return set;
    }

    protected Set<String> getBundles(EclipseProject eclipseProject) {
        HashSet<String> set = new HashSet<String>();
        set.add("org.eclipse.core.resources");
        set.add("org.eclipse.core.runtime");
        set.add("org.eclipse.core.jobs");
        if (this.bundles != null) {
            set.addAll(this.bundles);
        }
        for (String requiredBundle : this.getRequireBundles()) {
            set.add(requiredBundle);
        }
        if (this.hasPDENature(eclipseProject)) {
            set.add("org.eclipse.pde.core");
        }
        if (this.hasJDTNature(eclipseProject)) {
            set.add("org.eclipse.jdt.core");
        }
        if (this.hasAPIToolsNature(eclipseProject)) {
            set.add("org.eclipse.pde.api.tools");
        }
        return set;
    }

    private Collection<Path> getBaselineBundles() throws MojoFailureException {
        try {
            Collection targetEnvironments = this.projectManager.getBaselineEnvironments(this.project);
            Optional artifactKey = this.projectManager.getArtifactKey(this.project);
            this.getLog().info((CharSequence)("Resolve API baseline for " + this.project.getId() + " with " + targetEnvironments.stream().map(String::valueOf).collect(Collectors.joining(", "))));
            return this.applicationFactory.getApiBaselineBundles(this.baselines.stream().filter(repo -> repo.getUrl() != null).map(repo -> new MavenRepositoryLocation(repo.getId(), URI.create(repo.getUrl()))).toList(), (ArtifactKey)artifactKey.get(), targetEnvironments);
        }
        catch (IllegalArtifactReferenceException e) {
            throw new MojoFailureException("Project specify an invalid artifact key", (Throwable)e);
        }
        catch (DependencyResolutionException e) {
            if (this.failOnResolutionError) {
                throw new MojoFailureException("Can't resolve API baseline!", (Throwable)e);
            }
            this.getLog().warn((CharSequence)("Can't resolve API baseline: " + Objects.requireNonNullElse(e.getMessage(), e.toString())));
            return List.of();
        }
    }

    private boolean hasJDTNature(EclipseProject eclipseProject) {
        return eclipseProject.hasNature("org.eclipse.jdt.core.javanature");
    }

    private boolean hasAPIToolsNature(EclipseProject eclipseProject) {
        return eclipseProject.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature");
    }

    private boolean hasPDENature(EclipseProject eclipseProject) {
        return eclipseProject.hasNature("org.eclipse.pde.PluginNature");
    }

    private boolean hasBaselinesSet() {
        return this.baselines != null && this.baselines.size() > 0;
    }

    private static void printMarker(IMarker marker, EclipseBuildResult result, Consumer<CharSequence> consumer) {
        consumer.accept(AbstractEclipseBuildMojo.asString(marker, result).toString().trim());
    }

    protected static StringBuilder asString(IMarker marker, EclipseBuildResult result) {
        String sourceId;
        String message;
        StringBuilder sb = new StringBuilder();
        String path = result.getMarkerPath(marker);
        if (path != null) {
            sb.append(path);
            int line = marker.getAttribute("lineNumber", -1);
            if (line > -1) {
                sb.append(":");
                sb.append(line);
            }
            sb.append(" ");
        }
        if (!(message = marker.getAttribute("message", "")).isBlank()) {
            sb.append(message);
            sb.append(" ");
        }
        if (!(sourceId = marker.getAttribute("sourceId", "")).isBlank()) {
            sb.append(sourceId);
            sb.append(" ");
        }
        return sb;
    }

    protected abstract String getName();
}

