/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipsebuild;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.tycho.eclipsebuild.AbstractEclipseBuild;

public class SetJVMs
implements Callable<Serializable>,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean debug;
    private Collection<String> jvms;

    public SetJVMs(Collection<Path> jvms, boolean debug) {
        this.debug = debug;
        this.jvms = jvms.stream().map(AbstractEclipseBuild::pathAsString).toList();
    }

    @Override
    public Serializable call() throws Exception {
        StandardVMType standardType = (StandardVMType)JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
        for (String entry : this.jvms) {
            this.debug("Adding JVM " + entry + "...");
            VMStandin workingCopy = new VMStandin((IVMInstallType)standardType, entry);
            workingCopy.setInstallLocation(new File(entry));
            workingCopy.setName(entry);
            IVMInstall install = workingCopy.convertToRealVM();
            if (SetJVMs.isValid(install)) continue;
            standardType.disposeVMInstall(install.getId());
        }
        return null;
    }

    private static boolean isValid(IVMInstall install) {
        IVMInstall2 vm;
        return install instanceof IVMInstall2 && (vm = (IVMInstall2)install).getJavaVersion() != null;
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }
}

