/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipsebuild;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.tycho.eclipsebuild.EclipseBuildProjectMojo;
import org.eclipse.tycho.helper.PluginConfigurationHelper;
import org.eclipse.tycho.resolver.InstallableUnitProvider;

@Component(role=InstallableUnitProvider.class, hint="eclipse-build")
public class EclipseBuildInstallableUnitProvider
implements InstallableUnitProvider {
    @Requirement
    PluginConfigurationHelper configurationHelper;

    public Collection<IInstallableUnit> getInstallableUnits(MavenProject project, MavenSession session) throws CoreException {
        Optional local;
        PluginConfigurationHelper.Configuration configuration = this.extracted(project, session);
        if (configuration != null && (local = configuration.getBoolean("local")).isPresent() && ((Boolean)local.get()).booleanValue()) {
            Optional list = configuration.getStringList("bundles");
            return InstallableUnitProvider.createIU(list.stream().flatMap(Collection::stream).map(bundleName -> MetadataFactory.createRequirement((String)"osgi.bundle", (String)bundleName, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)true)), (String)"eclipse-build-bundles");
        }
        return List.of();
    }

    private PluginConfigurationHelper.Configuration extracted(MavenProject project, MavenSession session) {
        try {
            return this.configurationHelper.getConfiguration(EclipseBuildProjectMojo.class, project, session);
        }
        catch (Exception e) {
            return null;
        }
    }
}

