/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipsebuild;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.core.resources.IMarker;
import org.eclipse.tycho.eclipsebuild.AbstractEclipseBuildMojo;
import org.eclipse.tycho.eclipsebuild.EclipseBuildResult;
import org.eclipse.tycho.eclipsebuild.EclipseProjectBuild;

@Mojo(name="eclipse-build", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class EclipseBuildProjectMojo
extends AbstractEclipseBuildMojo<EclipseBuildResult> {
    @Parameter(defaultValue="true", property="tycho.eclipsebuild.failOnError")
    private boolean failOnError;

    @Override
    protected String getName() {
        return "Eclipse Project Build";
    }

    protected EclipseProjectBuild createExecutable() {
        return new EclipseProjectBuild(this.project.getBasedir().toPath(), this.debug);
    }

    @Override
    protected void handleResult(EclipseBuildResult result) throws MojoFailureException {
        List<IMarker> errorMarkers;
        if (this.failOnError && (errorMarkers = result.markers().filter(marker -> marker.getAttribute("severity", -1) == 2).toList()).size() > 0) {
            String msg = errorMarkers.stream().map(problem -> EclipseBuildProjectMojo.asString(problem, result)).collect(Collectors.joining(System.lineSeparator()));
            throw new MojoFailureException("There are Build errors:" + System.lineSeparator() + msg);
        }
    }
}

