/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipsebuild;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.tycho.eclipsebuild.AbstractEclipseBuild;
import org.eclipse.tycho.eclipsebuild.EclipseProjectBuild;

public class SetApiBaseline
implements Callable<Serializable>,
Serializable {
    private boolean debug;
    private List<String> baselineBundles;
    private String name;

    SetApiBaseline(String name, Collection<Path> baselineBundles, boolean debug) {
        this.name = name;
        this.debug = debug;
        this.baselineBundles = baselineBundles.stream().map(AbstractEclipseBuild::pathAsString).toList();
    }

    @Override
    public Serializable call() throws Exception {
        ILogListener listener = (status, plugin) -> this.debug(status.toString());
        Platform.addLogListener((ILogListener)listener);
        EclipseProjectBuild.disableAutoBuild();
        this.debug("Setting API baseline:");
        IApiBaseline baseline = ApiModelFactory.newApiBaseline((String)this.name);
        IApiComponent[] components = (IApiComponent[])this.baselineBundles.stream().peek(this::debug).map(absoluteFile -> {
            try {
                return ApiModelFactory.newApiComponent((IApiBaseline)baseline, (String)absoluteFile);
            }
            catch (CoreException e) {
                return null;
            }
        }).filter(Objects::nonNull).toArray(IApiComponent[]::new);
        baseline.addApiComponents(components);
        ApiBaselineManager.getManager().removeApiBaseline(baseline.getName());
        ApiBaselineManager.getManager().addApiBaseline(baseline);
        ApiBaselineManager.getManager().setDefaultApiBaseline(baseline.getName());
        return null;
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }
}

