/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipserun;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.eclipse.sisu.equinox.launching.BundleStartLevel;
import org.eclipse.sisu.equinox.launching.DefaultEquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallation;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationDescription;
import org.eclipse.sisu.equinox.launching.EquinoxInstallationFactory;
import org.eclipse.sisu.equinox.launching.EquinoxLauncher;
import org.eclipse.sisu.equinox.launching.LaunchConfiguration;
import org.eclipse.sisu.equinox.launching.ProvisionedEquinoxInstallation;
import org.eclipse.sisu.equinox.launching.internal.EquinoxLaunchConfiguration;
import org.eclipse.tycho.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.IllegalArtifactReferenceException;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.TargetEnvironment;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentConfigurationImpl;
import org.eclipse.tycho.core.maven.ToolchainProvider;
import org.eclipse.tycho.core.resolver.P2ResolutionResult;
import org.eclipse.tycho.core.resolver.P2Resolver;
import org.eclipse.tycho.core.resolver.P2ResolverFactory;
import org.eclipse.tycho.eclipserun.Repository;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.target.facade.TargetPlatformFactory;

@Mojo(name="eclipse-run", threadSafe=true)
public class EclipseRunMojo
extends AbstractMojo {
    private static final Object CREATE_LOCK = new Object();
    private static final ConcurrentMap<String, Object> WORKSPACE_LOCKS = new ConcurrentHashMap<String, Object>();
    @Parameter(defaultValue="${project.build.directory}/eclipserun-work")
    private File work;
    @Parameter
    private File installation;
    @Parameter(defaultValue="true")
    private boolean clearWorkspaceBeforeLaunch;
    @Parameter(property="project")
    private MavenProject project;
    @Parameter
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    @Parameter(defaultValue="true")
    private boolean addDefaultDependencies;
    @Parameter(defaultValue="JavaSE-17")
    private String executionEnvironment;
    @Parameter
    private List<Repository> repositories;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter
    private String argLine;
    @Parameter
    private List<String> jvmArgs;
    @Parameter(property="eclipserun.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String appArgLine;
    @Parameter(alias="applicationsArgs")
    private List<String> applicationArgs;
    @Parameter(property="eclipserun.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter
    private Map<String, String> environmentVariables;
    @Parameter
    private BundleStartLevel[] bundleStartLevel;
    @Parameter
    private BundleStartLevel defaultStartLevel;
    @Component
    private EquinoxInstallationFactory installationFactory;
    @Component
    private EquinoxLauncher launcher;
    @Component
    private ToolchainProvider toolchainProvider;
    @Component
    P2ResolverFactory resolverFactory;
    @Component
    private Logger logger;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private TargetPlatformFactory platformFactory;

    public EclipseRunMojo() {
    }

    public EclipseRunMojo(File work, boolean clearWorkspaceBeforeLaunch, MavenProject project, List<Dependency> dependencies, boolean addDefaultDependencies, String executionEnvironment, List<Repository> repositories, MavenSession session, List<String> jvmArgs, boolean skip, List<String> applicationArgs, int forkedProcessTimeoutInSeconds, Map<String, String> environmentVariables, EquinoxInstallationFactory installationFactory, EquinoxLauncher launcher, ToolchainProvider toolchainProvider, P2ResolverFactory resolverFactory, Logger logger, ToolchainManager toolchainManager, TargetPlatformFactory platformFactory, File installation) {
        this.work = work;
        this.clearWorkspaceBeforeLaunch = clearWorkspaceBeforeLaunch;
        this.project = project;
        this.dependencies = dependencies;
        this.addDefaultDependencies = addDefaultDependencies;
        this.executionEnvironment = executionEnvironment;
        this.repositories = repositories;
        this.session = session;
        this.jvmArgs = jvmArgs;
        this.skip = skip;
        this.applicationArgs = applicationArgs;
        this.forkedProcessTimeoutInSeconds = forkedProcessTimeoutInSeconds;
        this.environmentVariables = environmentVariables;
        this.installationFactory = installationFactory;
        this.launcher = launcher;
        this.toolchainProvider = toolchainProvider;
        this.resolverFactory = resolverFactory;
        this.logger = logger;
        this.toolchainManager = toolchainManager;
        this.platformFactory = platformFactory;
        this.installation = installation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        ProvisionedEquinoxInstallation installation;
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution was skipped");
            return;
        }
        if (this.installation != null) {
            installation = new ProvisionedEquinoxInstallation(this.installation);
        } else {
            Object object = CREATE_LOCK;
            synchronized (object) {
                installation = this.createEclipseInstallation();
            }
        }
        this.runEclipse((EquinoxInstallation)installation);
    }

    private void addDefaultDependency(P2Resolver resolver, String bundleId) {
        try {
            resolver.addDependency("eclipse-plugin", bundleId, null);
        }
        catch (IllegalArtifactReferenceException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDefaultDependencies(P2Resolver resolver) {
        if (this.addDefaultDependencies) {
            this.addDefaultDependency(resolver, "org.eclipse.osgi");
            this.addDefaultDependency(resolver, "org.eclipse.equinox.launcher");
            this.addDefaultDependency(resolver, "org.eclipse.core.runtime");
        }
    }

    private EquinoxInstallation createEclipseInstallation() throws MojoFailureException {
        TargetPlatformConfigurationStub tpConfiguration = new TargetPlatformConfigurationStub();
        tpConfiguration.setIgnoreLocalArtifacts(true);
        if (this.repositories != null) {
            for (Repository repository : this.repositories) {
                tpConfiguration.addP2Repository(new MavenRepositoryLocation(repository.getId(), repository.getLocation()));
            }
        }
        ExecutionEnvironmentConfigurationImpl eeConfiguration = new ExecutionEnvironmentConfigurationImpl(this.logger, false, this.toolchainManager, this.session);
        eeConfiguration.setProfileConfiguration(this.executionEnvironment, "tycho-eclipserun-plugin <executionEnvironment>");
        TargetPlatform targetPlatform = this.platformFactory.createTargetPlatform(tpConfiguration, (ExecutionEnvironmentConfiguration)eeConfiguration, null);
        P2Resolver resolver = this.resolverFactory.createResolver(Collections.singletonList(TargetEnvironment.getRunningEnvironment()));
        for (Dependency dependency : this.dependencies) {
            try {
                resolver.addDependency(dependency.getType(), dependency.getArtifactId(), dependency.getVersion());
            }
            catch (IllegalArtifactReferenceException e) {
                throw new MojoFailureException("Invalid dependency " + dependency.getType() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        this.addDefaultDependencies(resolver);
        DefaultEquinoxInstallationDescription installationDesc = new DefaultEquinoxInstallationDescription();
        for (P2ResolutionResult result : resolver.resolveTargetDependencies(targetPlatform, null).values()) {
            for (P2ResolutionResult.Entry entry : result.getArtifacts()) {
                if (!"eclipse-plugin".equals(entry.getType())) continue;
                installationDesc.addBundle(entry.getId(), entry.getVersion(), entry.getLocation(true));
            }
        }
        installationDesc.setDefaultBundleStartLevel(this.defaultStartLevel);
        if (this.bundleStartLevel != null) {
            for (BundleStartLevel level : this.bundleStartLevel) {
                installationDesc.addBundleStartLevel(level);
            }
        }
        return this.installationFactory.createInstallation((EquinoxInstallationDescription)installationDesc, this.work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEclipse(EquinoxInstallation runtime) throws MojoExecutionException {
        try {
            File workspace = new File(this.work, "data").getAbsoluteFile();
            Object object = WORKSPACE_LOCKS.computeIfAbsent(workspace.getAbsolutePath(), k -> new Object());
            synchronized (object) {
                if (this.clearWorkspaceBeforeLaunch) {
                    FileUtils.deleteDirectory((File)workspace);
                }
                LaunchConfiguration cli = this.createCommandLine(runtime);
                File expectedLog = new File(workspace, ".metadata/.log");
                this.getLog().info((CharSequence)("Expected Eclipse log file: " + expectedLog.getCanonicalPath()));
                int returnCode = this.launcher.execute(cli, this.forkedProcessTimeoutInSeconds);
                if (returnCode != 0) {
                    throw new MojoExecutionException("Error while executing platform: return code=" + returnCode + ", see content of " + String.valueOf(expectedLog) + "for more details.");
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while executing platform", e);
        }
    }

    public LaunchConfiguration createCommandLine(EquinoxInstallation runtime) throws MojoExecutionException {
        EquinoxLaunchConfiguration cli = new EquinoxLaunchConfiguration(runtime);
        String executable = null;
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in tycho-eclipserun-plugin: " + String.valueOf(tc)));
            executable = tc.findTool("java");
            if (executable == null) {
                this.getLog().error((CharSequence)"No 'java' executable was found in toolchain. Current Java runtime will be used");
            }
        } else if (Objects.equals(this.executionEnvironment, "JavaSE-" + Runtime.version().feature())) {
            this.getLog().debug((CharSequence)"Using current Java runtime as it matches configured executionEnvironment");
        } else {
            this.getLog().warn((CharSequence)("No toolchain was found in tycho-eclipserun-plugin for: " + this.executionEnvironment + ". Current Java runtime will be used"));
        }
        cli.setJvmExecutable(executable);
        cli.setWorkingDirectory(this.project.getBasedir());
        cli.addVMArguments(this.splitArgLine(this.argLine));
        if (this.jvmArgs != null) {
            cli.addVMArguments(this.jvmArgs.toArray(new String[this.jvmArgs.size()]));
        }
        this.addProgramArgs(cli, "-install", runtime.getLocation().getAbsolutePath(), "-configuration", new File(this.work, "configuration").getAbsolutePath());
        File workspace = new File(this.work, "data");
        this.addProgramArgs(cli, "-data", workspace.getAbsolutePath());
        cli.addProgramArguments(this.splitArgLine(this.appArgLine));
        if (this.applicationArgs != null) {
            for (String arg : this.applicationArgs) {
                cli.addProgramArguments(new String[]{arg});
            }
        }
        if (this.environmentVariables != null) {
            cli.addEnvironmentVariables(this.environmentVariables);
        }
        return cli;
    }

    private String[] splitArgLine(String argumentLine) throws MojoExecutionException {
        try {
            return CommandLineUtils.translateCommandline((String)argumentLine);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error parsing commandline: " + e.getMessage(), e);
        }
    }

    private void addProgramArgs(EquinoxLaunchConfiguration cli, String ... arguments) {
        if (arguments != null) {
            for (String argument : arguments) {
                if (argument == null) continue;
                cli.addProgramArguments(new String[]{argument});
            }
        }
    }

    private Toolchain getToolchain() throws MojoExecutionException {
        return this.toolchainProvider.findMatchingJavaToolChain(this.session, this.executionEnvironment);
    }
}

