/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipsebuild;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.tycho.eclipsebuild.BundleListTargetLocation;
import org.eclipse.tycho.eclipsebuild.EclipseBuild;

public class SetTargetPlatform
implements Callable<Serializable>,
Serializable {
    private boolean debug;
    private List<String> targetBundles;

    SetTargetPlatform(Collection<Path> dependencyBundles, boolean debug) {
        this.debug = debug;
        this.targetBundles = dependencyBundles.stream().map(EclipseBuild::pathAsString).toList();
    }

    @Override
    public Serializable call() throws Exception {
        ILogListener listener = (status, plugin) -> this.debug(status.toString());
        Platform.addLogListener((ILogListener)listener);
        EclipseBuild.disableAutoBuild();
        ITargetPlatformService service = TargetPlatformService.getDefault();
        ITargetDefinition target = service.newTarget();
        target.setName("buildpath");
        this.debug("== Target Platform Bundles ==");
        TargetBundle[] bundles = (TargetBundle[])this.targetBundles.stream().peek(this::debug).map(absoluteFile -> {
            try {
                return new TargetBundle(new File((String)absoluteFile));
            }
            catch (CoreException e) {
                this.debug(e.toString());
                return null;
            }
        }).filter(Objects::nonNull).toArray(TargetBundle[]::new);
        target.setTargetLocations(new ITargetLocation[]{new BundleListTargetLocation(bundles)});
        service.saveTargetDefinition(target);
        LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(target);
        job.schedule();
        job.join();
        return null;
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }
}

