/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipserun;

import java.net.URI;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class Repository {
    private String id;
    private URI url;
    private Layout layout = Layout.BOTH;

    public Repository() {
    }

    public Repository(URI location) {
        this.url = location;
    }

    public URI getLocation() {
        if (this.url == null) {
            throw new IllegalStateException("Attribute 'url' is required for source repositories");
        }
        return this.url;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public String getId() {
        return this.id;
    }

    public void setLayout(String value) {
        for (Layout layout : Layout.values()) {
            if (!layout.matches(value)) continue;
            this.layout = layout;
            return;
        }
        String values = Arrays.stream(Layout.values()).map(Object::toString).collect(Collectors.joining(", "));
        throw new IllegalArgumentException("Unrecognized value for attribute 'layout': \"" + value + "\". Valid values are: " + values);
    }

    public static enum Layout {
        BOTH("p2"),
        METADATA("p2-metadata"),
        ARTIFACTS("p2-artifacts");

        private String literal;

        private Layout(String literal) {
            this.literal = literal;
        }

        boolean matches(String value) {
            return this.literal.equals(value);
        }

        public boolean hasMetadata() {
            return this != ARTIFACTS;
        }

        public boolean hasArtifacts() {
            return this != METADATA;
        }

        public String toString() {
            return this.literal;
        }
    }
}

