/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipsebuild;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tycho.TargetPlatform;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.eclipsebuild.EclipseBuild;
import org.eclipse.tycho.eclipsebuild.EclipseBuildResult;
import org.eclipse.tycho.eclipsebuild.SetTargetPlatform;
import org.eclipse.tycho.osgi.framework.Bundles;
import org.eclipse.tycho.osgi.framework.EclipseApplication;
import org.eclipse.tycho.osgi.framework.EclipseApplicationManager;
import org.eclipse.tycho.osgi.framework.EclipseFramework;
import org.eclipse.tycho.osgi.framework.EclipseWorkspaceManager;
import org.eclipse.tycho.osgi.framework.Features;
import org.osgi.framework.BundleException;

@org.apache.maven.plugins.annotations.Mojo(name="eclipse-build", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class EclipseBuildMojo
extends AbstractMojo {
    static final String PARAMETER_LOCAL = "local";
    private static final String NAME = "Eclipse Build Project";
    @Parameter
    private Repository eclipseRepository;
    @Parameter(defaultValue="false", property="tycho.eclipsebuild.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="tycho.eclipsebuild.debug")
    private boolean debug;
    @Parameter(defaultValue="false", property="tycho.eclipsebuild.local", name="local")
    private boolean local;
    @Parameter(defaultValue="true", property="tycho.eclipsebuild.failOnError")
    private boolean failOnError;
    @Parameter(defaultValue="true", property="tycho.eclipsebuild.printMarker")
    private boolean printMarker;
    @Parameter
    private List<String> bundles;
    @Parameter
    private List<String> features;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Component
    private EclipseWorkspaceManager workspaceManager;
    @Component
    private EclipseApplicationManager eclipseApplicationManager;
    @Component
    private TychoProjectManager projectManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        EclipseApplication application;
        Collection projectDependencies;
        try {
            projectDependencies = this.projectManager.getProjectDependencies(this.project);
        }
        catch (Exception e) {
            throw new MojoFailureException("Can't resolve project dependencies", (Throwable)e);
        }
        Bundles bundles = new Bundles(this.getBundles());
        Features features = new Features(this.getFeatures());
        if (this.local) {
            TargetPlatform targetPlatform = (TargetPlatform)this.projectManager.getTargetPlatform(this.project).orElseThrow(() -> new MojoFailureException("Can't get target platform for project " + this.project.getId()));
            application = this.eclipseApplicationManager.getApplication(targetPlatform, bundles, features, NAME);
        } else {
            application = this.eclipseApplicationManager.getApplication(this.eclipseRepository, bundles, features, NAME);
        }
        try (EclipseFramework framework = application.startFramework(this.workspaceManager.getWorkspace(EclipseApplicationManager.getRepository((Repository)this.eclipseRepository).getURL(), (Mojo)this), List.of());){
            if (this.debug) {
                framework.printState();
            }
            if (framework.hasBundle("org.eclipse.pde.core")) {
                framework.execute((Callable)new SetTargetPlatform(projectDependencies, this.debug));
            } else {
                this.getLog().info((CharSequence)"Skip set Target Platform because org.eclipse.pde.core is not part of the framework...");
            }
            EclipseBuildResult result = (EclipseBuildResult)framework.execute((Callable)new EclipseBuild(this.project.getBasedir().toPath(), this.debug));
            List<IMarker> errors = result.markers().filter(marker -> marker.getAttribute("severity", -1) == 2).toList();
            if (this.printMarker) {
                Log log = this.getLog();
                result.markers().filter(marker -> marker.getAttribute("severity", -1) == 0).forEach(info -> this.printMarker((IMarker)info, result, arg_0 -> ((Log)log).info(arg_0)));
                result.markers().filter(marker -> marker.getAttribute("severity", -1) == 1).forEach(warn -> this.printMarker((IMarker)warn, result, arg_0 -> ((Log)log).warn(arg_0)));
                errors.forEach(error -> this.printMarker((IMarker)error, result, arg_0 -> ((Log)log).error(arg_0)));
            }
            if (this.failOnError && errors.size() > 0) {
                String msg = errors.stream().map(problem -> this.asString((IMarker)problem, result)).collect(Collectors.joining(System.lineSeparator()));
                throw new MojoFailureException("There are Build errors:" + System.lineSeparator() + msg);
            }
        }
        catch (BundleException e) {
            throw new MojoFailureException("Can't start framework!", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause.getClass().getName().equals(CoreException.class.getName())) {
                throw new MojoFailureException(cause.getMessage(), cause);
            }
            throw new MojoExecutionException(cause);
        }
    }

    private Set<String> getFeatures() {
        HashSet<String> set = new HashSet<String>();
        if (this.features != null) {
            set.addAll(this.features);
        }
        return set;
    }

    private Set<String> getBundles() {
        HashSet<String> set = new HashSet<String>();
        set.add("org.eclipse.core.resources");
        set.add("org.eclipse.core.runtime");
        set.add("org.eclipse.core.jobs");
        if (this.bundles != null) {
            set.addAll(this.bundles);
        }
        return set;
    }

    private void printMarker(IMarker marker, EclipseBuildResult result, Consumer<CharSequence> consumer) {
        StringBuilder sb = this.asString(marker, result);
        consumer.accept(sb.toString().trim());
    }

    private StringBuilder asString(IMarker marker, EclipseBuildResult result) {
        String sourceId;
        String message;
        StringBuilder sb = new StringBuilder();
        String path = result.getMarkerPath(marker);
        if (path != null) {
            sb.append(path);
            int line = marker.getAttribute("lineNumber", -1);
            if (line > -1) {
                sb.append(":");
                sb.append(line);
            }
            sb.append(" ");
        }
        if (!(message = marker.getAttribute("message", "")).isBlank()) {
            sb.append(message);
            sb.append(" ");
        }
        if (!(sourceId = marker.getAttribute("sourceId", "")).isBlank()) {
            sb.append(sourceId);
            sb.append(" ");
        }
        return sb;
    }
}

