/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.eclipsebuild;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

class MarkerDTO
implements IMarker,
Serializable {
    private long id;
    private long creationTime;
    private String type;
    private String string;
    private HashMap<String, Object> attributes;
    private boolean exits;

    MarkerDTO(IMarker marker) {
        this.id = marker.getId();
        this.string = marker.toString();
        this.attributes = new HashMap();
        this.exits = marker.exists();
        try {
            this.creationTime = marker.getCreationTime();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            this.type = marker.getType();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            Map map = marker.getAttributes();
            if (map != null) {
                map.forEach((k, v) -> {
                    if (v == null) {
                        return;
                    }
                    this.attributes.put((String)k, v.toString());
                });
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public Object getAttribute(String attributeName) throws CoreException {
        return this.getAttribute(attributeName, null);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        try {
            return Integer.parseInt(this.getAttribute(attributeName, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getAttribute(String attributeName, String defaultValue) {
        return (String)this.attributes.getOrDefault(attributeName, defaultValue);
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        return Boolean.parseBoolean(this.getAttribute(attributeName, String.valueOf(defaultValue)));
    }

    public Map<String, Object> getAttributes() throws CoreException {
        this.checkExsits();
        return this.attributes;
    }

    public Object[] getAttributes(String[] attributeNames) throws CoreException {
        throw new CoreException(Status.error((String)"Not implemented"));
    }

    public long getCreationTime() throws CoreException {
        this.checkExsits();
        return this.creationTime;
    }

    public long getId() {
        return this.id;
    }

    public String getType() throws CoreException {
        this.checkExsits();
        return this.type;
    }

    public IResource getResource() {
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public void delete() throws CoreException {
        throw new CoreException(Status.error((String)"Not implemented"));
    }

    public boolean exists() {
        return this.exits;
    }

    public boolean isSubtypeOf(String superType) throws CoreException {
        throw new CoreException(Status.error((String)"Not implemented"));
    }

    public void setAttribute(String attributeName, int value) throws CoreException {
        throw new CoreException(Status.error((String)"Not implemented"));
    }

    public void setAttribute(String attributeName, Object value) throws CoreException {
        throw new CoreException(Status.error((String)"Not implemented"));
    }

    public void setAttribute(String attributeName, boolean value) throws CoreException {
        throw new CoreException(Status.error((String)"Not implemented"));
    }

    public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
        throw new CoreException(Status.error((String)"Not implemented"));
    }

    public void setAttributes(Map<String, ? extends Object> attributes) throws CoreException {
        throw new CoreException(Status.error((String)"Not implemented"));
    }

    private void checkExsits() throws CoreException {
        if (!this.exits) {
            throw new CoreException(Status.error((String)"DO not exits"));
        }
    }

    public String toString() {
        return this.string;
    }
}

