/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.gpg.AbstractGpgSigner;
import org.apache.maven.plugins.gpg.GpgVersion;
import org.apache.maven.plugins.gpg.GpgVersionParser;
import org.bouncycastle.openpgp.PGPException;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.tycho.gpg.BouncyCastleSigner;
import org.eclipse.tycho.gpg.KeyStore;
import org.eclipse.tycho.gpg.SignatureStore;

public class ProxySignerWithPublicKeyAccess
extends AbstractGpgSigner {
    private final AbstractGpgSigner delegate;
    private final BouncyCastleSigner signer;
    private KeyStore publicKeys;

    public ProxySignerWithPublicKeyAccess(AbstractGpgSigner delegate, String signer, File pgpInfo, File secretKeys) {
        this.delegate = delegate;
        this.setLog(delegate.getLog());
        if ("bc".equals(signer) || pgpInfo != null || secretKeys != null) {
            try {
                this.signer = this.getSigner(pgpInfo, secretKeys);
            }
            catch (IOException | MojoExecutionException | MojoFailureException | PGPException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.signer = null;
        }
    }

    public KeyStore getPublicKeys() {
        if (this.publicKeys == null) {
            try {
                this.publicKeys = KeyStore.create(this.getKeys(true));
            }
            catch (MojoExecutionException e) {
                new RuntimeException(e.getMessage(), e);
            }
        }
        return this.publicKeys;
    }

    protected BouncyCastleSigner getSigner(File pgpInfo, File secretKeys) throws MojoExecutionException, IOException, MojoFailureException, PGPException {
        this.keyname = this.delegate.keyname;
        BouncyCastleSigner signer = new BouncyCastleSigner();
        signer.setLog(this.getLog());
        if (pgpInfo != null) {
            signer.configureFromPGPInfo(this.keyname, pgpInfo);
            this.publicKeys = KeyStore.create(signer.getPublicKeys());
        } else if (secretKeys != null) {
            signer.configure(this.keyname, this.delegate.passphrase, null, Files.readString(secretKeys.toPath(), StandardCharsets.US_ASCII));
            this.publicKeys = KeyStore.create(signer.getPublicKeys());
        } else {
            String publicKeys = this.getPublicKeys().toArmoredString();
            String gpgSecretKeys = this.getKeys(false);
            if (this.keyname == null) {
                Path dummy = Files.createTempFile("dummy", ".txt", new FileAttribute[0]);
                Path signature = Files.createTempFile("dummy", ".asc", new FileAttribute[0]);
                Files.delete(signature);
                this.delegate.generateSignatureForFile(dummy.toFile(), signature.toFile());
                SignatureStore signatures = SignatureStore.create(Files.readString(signature, StandardCharsets.US_ASCII));
                this.keyname = PGPPublicKeyService.toHex((long)signatures.all().iterator().next().getKeyID());
                Files.delete(dummy);
                Files.delete(signature);
            }
            signer.configure(this.keyname, this.delegate.passphrase, publicKeys, gpgSecretKeys);
        }
        return signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureStore generateSignature(File file) throws MojoExecutionException {
        try {
            File signatureFile;
            if (this.signer != null) {
                return this.signer.generateSignature(file);
            }
            AbstractGpgSigner abstractGpgSigner = this.delegate;
            synchronized (abstractGpgSigner) {
                signatureFile = this.delegate.generateSignatureForArtifact(file);
            }
            SignatureStore signatureStore = SignatureStore.create(Files.readString(signatureFile.toPath(), StandardCharsets.US_ASCII));
            signatureFile.delete();
            return signatureStore;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void generateSignatureForFile(File file, File signature) throws MojoExecutionException {
        if (this.signer != null) {
            try {
                Files.writeString(signature.toPath(), (CharSequence)this.signer.generateSignature(file).toArmoredString(), new OpenOption[0]);
            }
            catch (IOException | PGPException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        } else {
            this.delegate.generateSignatureForFile(file, signature);
        }
    }

    private String getKeys(boolean isPublic) throws MojoExecutionException {
        Commandline cmd = new Commandline();
        String executable = "gpg" + (Os.isFamily((String)"windows") ? ".exe" : "");
        cmd.setExecutable(executable);
        if (this.delegate.args != null) {
            for (String arg : this.delegate.args) {
                cmd.createArg().setValue(arg);
            }
        }
        if (this.delegate.homeDir != null) {
            cmd.createArg().setValue("--homedir");
            cmd.createArg().setFile(this.delegate.homeDir);
        }
        ByteArrayInputStream in = null;
        if (isPublic) {
            cmd.createArg().setValue("--export");
        } else {
            cmd.createArg().setValue("--export-secret-keys");
            if (this.delegate.passphrase != null) {
                GpgVersionParser versionParser = GpgVersionParser.parse((String)executable);
                GpgVersion gpgVersion = versionParser.getGpgVersion();
                if (gpgVersion.isAtLeast(GpgVersion.parse((String)"2.0"))) {
                    cmd.createArg().setValue("--batch");
                }
                if (gpgVersion.isAtLeast(GpgVersion.parse((String)"2.1"))) {
                    cmd.createArg().setValue("--pinentry-mode");
                    cmd.createArg().setValue("loopback");
                }
                cmd.createArg().setValue("--passphrase-fd");
                cmd.createArg().setValue("0");
                in = new ByteArrayInputStream(this.delegate.passphrase.getBytes());
                if (StringUtils.isNotEmpty((String)this.delegate.secretKeyring)) {
                    if (gpgVersion.isBefore(GpgVersion.parse((String)"2.1"))) {
                        cmd.createArg().setValue("--secret-keyring");
                        cmd.createArg().setValue(this.delegate.secretKeyring);
                    } else {
                        this.getLog().warn((CharSequence)"'secretKeyring' is an obsolete option and is ignored. All secret keys are stored in the 'private-keys-v1.d' directory below the GnuPG home directory");
                    }
                }
            }
        }
        cmd.createArg().setValue("--armor");
        if (!this.delegate.defaultKeyring) {
            cmd.createArg().setValue("--no-default-keyring");
        }
        if (StringUtils.isNotEmpty((String)this.delegate.publicKeyring)) {
            cmd.createArg().setValue("--keyring");
            cmd.createArg().setValue(this.delegate.publicKeyring);
        }
        if (this.delegate.keyname != null) {
            cmd.createArg().setValue(this.delegate.keyname);
        }
        try {
            CommandLineUtils.StringStreamConsumer systemOut = new CommandLineUtils.StringStreamConsumer();
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, in, (StreamConsumer)systemOut, (StreamConsumer)systemOut);
            if (exitCode != 0) {
                throw new MojoExecutionException("Exit code: " + exitCode);
            }
            return systemOut.getOutput();
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute gpg command", (Exception)((Object)e));
        }
    }
}

