/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.gpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.gpg.AbstractGpgSigner;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.tycho.gpg.KeyStore;
import org.eclipse.tycho.gpg.SignatureStore;

public class BouncyCastleSigner
extends AbstractGpgSigner {
    private String publicKeys;
    private String secretKeys;
    private PGPSecretKey secretKey;
    private PGPPrivateKey privateKey;

    public BouncyCastleSigner configure(String keyname, String passphrase, String publicKeys, String secretKeys) throws IOException, PGPException {
        this.keyname = keyname == null ? null : keyname.toLowerCase();
        this.passphrase = passphrase;
        this.publicKeys = publicKeys;
        this.secretKeys = secretKeys;
        this.initPrivateKey();
        return this;
    }

    public BouncyCastleSigner configureFromPGPInfo(String keyname, File pgpInfo) throws PGPException, IOException {
        this.keyname = keyname;
        this.initFromPGPInfo(pgpInfo);
        return this;
    }

    public BouncyCastleSigner configureNewUserIDs(String passphrase, String ... userIDs) throws PGPException, IOException {
        this.passphrase = passphrase;
        this.init(userIDs);
        return this;
    }

    public String getPublicKeys() {
        return this.publicKeys;
    }

    public String getSecretKeys() {
        return this.secretKeys;
    }

    public SignatureStore generateSignature(File file) throws PGPException, IOException {
        PGPPublicKey publicKey = this.secretKey.getPublicKey();
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(publicKey.getAlgorithm(), 8).setProvider("BC"));
        signatureGenerator.init(0, this.privateKey);
        PGPSignatureSubpacketGenerator subpackets = new PGPSignatureSubpacketGenerator();
        subpackets.setIssuerFingerprint(false, publicKey);
        Iterator userIDs = publicKey.getUserIDs();
        if (userIDs.hasNext()) {
            subpackets.addSignerUserID(false, (String)userIDs.next());
        }
        signatureGenerator.setHashedSubpackets(subpackets.generate());
        signatureGenerator.init(0, this.privateKey);
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = in.read(buffer)) >= 0) {
                signatureGenerator.update(buffer, 0, read);
            }
        }
        SignatureStore signatureStore = SignatureStore.create(signatureGenerator.generate());
        return signatureStore;
    }

    protected void generateSignatureForFile(File file, File signature) throws MojoExecutionException {
        try {
            Files.writeString(signature.toPath(), (CharSequence)this.generateSignature(file).toArmoredString(), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void initFromPGPInfo(File pgpInfo) throws PGPException, IOException {
        List<String> lines = Files.readAllLines(pgpInfo.toPath(), StandardCharsets.US_ASCII);
        this.passphrase = lines.get(0);
        int index = lines.indexOf("-----END PGP PUBLIC KEY BLOCK-----");
        this.publicKeys = String.join((CharSequence)"\n", lines.subList(1, index + 1));
        this.secretKeys = String.join((CharSequence)"\n", lines.subList(index + 1, lines.size()));
        this.initPrivateKey();
    }

    private void initPrivateKey() throws IOException, PGPException {
        KeyStore keyStore = KeyStore.create("");
        Log log = this.getLog();
        try (InputStream stream = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(this.secretKeys.getBytes(StandardCharsets.US_ASCII)));){
            for (Object object : new JcaPGPObjectFactory(stream)) {
                if (!(object instanceof PGPSecretKeyRing)) continue;
                PGPSecretKeyRing secretKeyRing = (PGPSecretKeyRing)object;
                if (this.publicKeys == null) {
                    for (PGPSecretKey key : secretKeyRing) {
                        PGPPublicKey publicKey = key.getPublicKey();
                        if (log != null) {
                            log.info((CharSequence)("Secret key available for public key: " + PGPPublicKeyService.toHex((byte[])publicKey.getFingerprint())));
                        }
                        keyStore.add(publicKey);
                    }
                }
                if (this.secretKey != null) continue;
                this.secretKey = this.getSecretKey(secretKeyRing);
                if (this.secretKey == null) continue;
                byte[] fingerprint = this.secretKey.getPublicKey().getFingerprint();
                if (log != null) {
                    log.info((CharSequence)("Trying to get the private key of the secret key of public key: " + PGPPublicKeyService.toHex((byte[])fingerprint)));
                }
                this.privateKey = this.getPrivateKey(this.secretKey);
                if (this.privateKey == null) {
                    if (log != null) {
                        log.info((CharSequence)("Could not a create private key for the secret key of public key: " + PGPPublicKeyService.toHex((byte[])fingerprint)));
                    }
                    this.secretKey = null;
                    continue;
                }
                if (log == null) continue;
                log.info((CharSequence)("Got the private key of the secret key of public key: " + PGPPublicKeyService.toHex((byte[])fingerprint)));
            }
        }
        if (this.secretKey == null) {
            throw new PGPException("A secret key for keyname '" + this.keyname + "' not found.");
        }
        if (this.publicKeys == null) {
            this.publicKeys = keyStore.toArmoredString();
        }
    }

    private void init(String ... userIDs) throws PGPException, IOException {
        RSAKeyPairGenerator keyPairGenerator = new RSAKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), new SecureRandom(), 4096, 12));
        Date now = new Date(0L);
        ArrayList<PGPPublicKeyRing> publicKeyRings = new ArrayList<PGPPublicKeyRing>();
        ArrayList<PGPSecretKeyRing> secretKeyRings = new ArrayList<PGPSecretKeyRing>();
        for (String userID : userIDs) {
            BcPGPKeyPair signingKeyPair = new BcPGPKeyPair(3, keyPairGenerator.generateKeyPair(), now);
            PGPSignatureSubpacketGenerator signatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            signatureSubpacketGenerator.setKeyFlags(false, 3);
            signatureSubpacketGenerator.setPreferredSymmetricAlgorithms(false, new int[]{9, 7});
            signatureSubpacketGenerator.setPreferredHashAlgorithms(false, new int[]{10, 8});
            signatureSubpacketGenerator.setPreferredCompressionAlgorithms(false, new int[]{1, 3});
            BcPGPKeyPair encryptionKeyPair = new BcPGPKeyPair(2, keyPairGenerator.generateKeyPair(), now);
            PGPSignatureSubpacketGenerator encryptionSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            encryptionSubpacketGenerator.setKeyFlags(false, 12);
            PGPDigestCalculator digestCalculator = new BcPGPDigestCalculatorProvider().get(2);
            PGPSignatureSubpacketVector signatureSubpacketVector = signatureSubpacketGenerator.generate();
            BcPGPContentSignerBuilder contentSignerBuilder = new BcPGPContentSignerBuilder(3, 8);
            BcPBESecretKeyEncryptorBuilder secretKeyEncryptorBuilder = new BcPBESecretKeyEncryptorBuilder(9);
            PGPKeyRingGenerator keyRingGenerator = new PGPKeyRingGenerator(3, (PGPKeyPair)signingKeyPair, userID, digestCalculator, signatureSubpacketVector, null, (PGPContentSignerBuilder)contentSignerBuilder, secretKeyEncryptorBuilder.build(this.passphrase.toCharArray()));
            keyRingGenerator.addSubKey((PGPKeyPair)encryptionKeyPair, encryptionSubpacketGenerator.generate(), null);
            publicKeyRings.add(keyRingGenerator.generatePublicKeyRing());
            secretKeyRings.add(keyRingGenerator.generateSecretKeyRing());
        }
        ByteArrayOutputStream publicKeyOut = new ByteArrayOutputStream();
        try (ArmoredOutputStream targetStream = new ArmoredOutputStream((OutputStream)publicKeyOut);){
            targetStream.setHeader("Version", null);
            publicKeyRings.stream().map(it -> PGPPublicKeyService.toHex((byte[])it.getPublicKey().getFingerprint())).forEach(it -> targetStream.addHeader("Key", it));
            new PGPPublicKeyRingCollection(publicKeyRings).encode((OutputStream)targetStream);
        }
        ByteArrayOutputStream secretKeyOut = new ByteArrayOutputStream();
        try (ArmoredOutputStream targetStream = new ArmoredOutputStream((OutputStream)secretKeyOut);){
            targetStream.setHeader("Version", null);
            new PGPSecretKeyRingCollection(secretKeyRings).encode((OutputStream)targetStream);
        }
        this.publicKeys = publicKeyOut.toString(StandardCharsets.US_ASCII);
        this.secretKeys = secretKeyOut.toString(StandardCharsets.US_ASCII);
        this.secretKey = this.getSecretKey((PGPSecretKeyRing)secretKeyRings.get(0));
        this.privateKey = this.getPrivateKey(this.secretKey);
    }

    private PGPSecretKey getSecretKey(PGPSecretKeyRing secretKeyRing) throws PGPException {
        Iterator secretKeys = secretKeyRing.getSecretKeys();
        while (secretKeys.hasNext()) {
            PGPSecretKey pgpSecretKey = (PGPSecretKey)secretKeys.next();
            if (pgpSecretKey.isPrivateKeyEmpty() || !pgpSecretKey.isSigningKey()) continue;
            if (this.keyname == null) {
                return pgpSecretKey;
            }
            PGPPublicKey publicKey = pgpSecretKey.getPublicKey();
            String fingerprint = PGPPublicKeyService.toHex((byte[])publicKey.getFingerprint());
            if (fingerprint.endsWith(this.keyname)) {
                return pgpSecretKey;
            }
            Iterator subkeyBindings = publicKey.getSignaturesOfType(24);
            while (subkeyBindings.hasNext()) {
                PGPSignature pgpSignature = (PGPSignature)subkeyBindings.next();
                if (this.keyname != null && !PGPPublicKeyService.toHex((long)pgpSignature.getKeyID()).endsWith(this.keyname)) continue;
                return pgpSecretKey;
            }
        }
        return null;
    }

    private PGPPrivateKey getPrivateKey(PGPSecretKey pgpSecretKey) throws PGPException {
        PBESecretKeyDecryptor pbeSecretKeyDecryptor = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(this.passphrase.toCharArray());
        return pgpSecretKey.extractPrivateKey(pbeSecretKeyDecryptor);
    }

    public void dump(Path target) throws IOException {
        try (PrintStream out = new PrintStream(Files.newOutputStream(target, new OpenOption[0]));){
            out.println(this.passphrase);
            out.print(this.publicKeys);
            out.print(this.secretKeys);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Path target = Files.createTempFile("pgp", ".info", new FileAttribute[0]);
            new BouncyCastleSigner().configureNewUserIDs("passphrase", "Tester1 <tester1@example.com>", "Tester2 <tester2@example.com>").dump(target);
            new BouncyCastleSigner().configureFromPGPInfo(null, target.toFile());
            Files.copy(target, System.out);
        } else {
            BouncyCastleSigner signer = new BouncyCastleSigner();
            if (args.length == 3) {
                secretKeys = Files.readString(Path.of(args[2], new String[0]));
                signer.configure(args[0], args[1], null, secretKeys);
            } else {
                secretKeys = Files.readString(Path.of(args[1], new String[0]));
                signer.configure(null, args[0], null, secretKeys);
            }
            Path target = Files.createTempFile("pgp", ".info", new FileAttribute[0]);
            signer.generateSignature(target.toFile());
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

