/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.gpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;

public class KeyStore {
    private Map<String, PGPPublicKey> keys = new TreeMap<String, PGPPublicKey>();

    public static KeyStore create(String ... keys) {
        KeyStore keyStore = new KeyStore();
        keyStore.add(keys);
        return keyStore;
    }

    private KeyStore() {
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public Collection<? extends PGPPublicKey> all() {
        return this.keys.values();
    }

    public void add(PGPPublicKey key) {
        this.keys.put(PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key), key);
    }

    public void add(Collection<? extends PGPPublicKey> keys) {
        keys.stream().forEach(this::add);
    }

    public void add(KeyStore keyStore) {
        this.keys.putAll(keyStore.keys);
    }

    public void add(String ... keys) {
        for (String key : keys) {
            if (key == null) continue;
            KeyStore.readKeys(key).forEach(this::add);
        }
    }

    public Collection<PGPPublicKey> getKeys(long id) {
        return this.keys.values().stream().filter(key -> key.getKeyID() == id).collect(Collectors.toList());
    }

    public String toArmoredString() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ArmoredOutputStream armoredOut = new ArmoredOutputStream((OutputStream)out);){
            armoredOut.setHeader("Version", null);
            for (PGPPublicKey key : this.keys.values()) {
                key.encode((OutputStream)armoredOut);
            }
        }
        return out.toString(StandardCharsets.US_ASCII);
    }

    private static Set<PGPPublicKey> readKeys(String keys) {
        if (keys == null) {
            return Set.of();
        }
        HashSet<PGPPublicKey> result = new HashSet<PGPPublicKey>();
        try (InputStream stream = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(keys.getBytes(StandardCharsets.US_ASCII)));){
            new JcaPGPObjectFactory(stream).forEach(o -> {
                if (o instanceof PGPPublicKeyRingCollection) {
                    KeyStore.collectKeys((PGPPublicKeyRingCollection)o, result::add);
                }
                if (o instanceof PGPPublicKeyRing) {
                    KeyStore.collectKeys((PGPPublicKeyRing)o, result::add);
                }
                if (o instanceof PGPPublicKey) {
                    result.add((PGPPublicKey)o);
                }
            });
        }
        catch (IOException | PGPRuntimeOperationException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private static void collectKeys(PGPPublicKeyRingCollection pgpPublicKeyRingCollection, Consumer<PGPPublicKey> collector) {
        pgpPublicKeyRingCollection.forEach(keyring -> KeyStore.collectKeys(keyring, collector));
    }

    private static void collectKeys(PGPPublicKeyRing pgpPublicKeyRing, Consumer<PGPPublicKey> collector) {
        pgpPublicKeyRing.getPublicKeys().forEachRemaining(collector::accept);
    }
}

